<?php
    class Sns_Dropbox {

        private $key    = 'ei93frmgr1jowtj';
        private $secret = 'e93iqmmzqggctb3';
        private $userID = 1;
        private $storage = null;
        private $dropbox = null;

        private function __construct(){
            // Instantiate the Encrypter and storage objects
            $encrypter = new \Dropbox\OAuth\Storage\Encrypter('XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX');
            // Instantiate the database data store
            $storage = new \Dropbox\OAuth\Storage\DB($encrypter, $this->userID);
            $this->storage = $storage;
        }

        public function init(){
            // Check whether to use HTTPS and set the callback URL
            $protocol = (!empty($_SERVER['HTTPS'])) ? 'https' : 'http';
            $callback = $protocol . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

            // Create the consumer and API objects
            $OAuth = new \Dropbox\OAuth\Consumer\Curl($this->key, $this->secret, $this->storage, $callback);
            $this->dropbox = new \Dropbox\API($OAuth);
        }

        public function chunkedUpload( $filePath ){
            if( $this->isLinked() ){
                $this->dropbox->chunkedUpload( $filePath, false, '' );
            }
        }

        public function linkAccount(){
            $accountInfo = $this->dropbox->accountInfo();

            $info = array(
                'display_name'  => $accountInfo['body']->display_name,
                'email'         => $accountInfo['body']->email
            );
            $this->dropbox->updateAccountInfo($info);
        }

        public function unlinkAccount( $db ){
            $this->storage->delete( $db );
        }

        public function isLinked(){
            try{
                $res = $this->storage->get('access_token');
            } catch( \Dropbox\Exception $e ){
                Sns_Log::log_exception_obj( $e );
                $res = false;
            }
            if( false != $res ){
                return true;
            }
            return false;
        }

        public function draw(){
            $linked = $this->isLinked();
            if( !$linked ){
                $data = array(
                    'display_name' => '',
                    'email' => '',
                    'status' => 0
                );
            }else{
                $data = $this->storage->getData();
                $data['status'] = 1;
            }
?>
            <span class="dropbox-subtitle">Dropbox settings</span>
            <div class="dropbox-data">
                <form  class="dropbox-form" action="<?php echo admin_url('admin.php'); ?>">
                    <div class="form-group">
                        <label class="control-label col-sm-2">Name:</label>
                        <input id="dropbox-name" disabled="disabled" value="<?php echo $data['display_name']; ?>" type="text" class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-2">Email:</label>
                        <input id="dropbox-email" disabled="disabled" value="<?php echo $data['email']; ?>" type="text" class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2">Status:</label>
                        <span id="dropbox-status"><?php if( $linked ){ echo 'active'; }else{ echo 'inactive'; } ?></span>
                    </div>
                    <input type="hidden" name="action" value="sns_link_dropbox"/>
                    <input type="hidden" name="sns_backup_page" value="<?php echo $_GET['page']; ?>" />
                    <div class="dropbox-btns">
                        <button id="unlink-dropbox" class="btn btn-primary sns-action <?php if( !$linked ){ echo ' dn ';} ?>">Unlink</button>
                        <button type="submit" id="link-dropbox" class="btn btn-primary sns-action <?php if( $linked ){ echo ' dn ';} ?>">Link account</button>
                    </div>
                </form>
            </div>
            <div class="separator"></div>
<?php
        }

        private static $dropboxInstance = null;

        public static function getInstance(){
            if( is_null( self::$dropboxInstance ) ){
                self::$dropboxInstance = new Sns_Dropbox();
            }
            return self::$dropboxInstance;
        }

    }