<?php
    class Sns_Notification {

        const SET = '1';
        const NOT_SET = '0';

        private $settings;

        public function get_settings(){

            global $wpdb;
            $table = SNS_DB_PREFIX.'settings_notifications';
            $query = "   SELECT
                            `email`,
                            `enabled`
                         FROM `{$table}`
                         LIMIT 1
                   " ;
            $data = $wpdb->get_results( $query , ARRAY_A );
            return $data[0];

        }

        public function set_settings( $settings ){
            $this->settings = $settings;
        }

        public function save(){

            global $wpdb;
            $table = SNS_DB_PREFIX.'settings_notifications';
            $query = "   UPDATE `{$table}`
                         SET    `email` = '".$this->settings['email']."',
                                `enabled` = '".$this->settings['enabled']."'
                    ";
            $response = $wpdb->query( $query );
            if( $response === false ){
                throw new Sns_Exception_DB_Error( $query );
            }

        }

        public function notify_backup( $success , $backup_file = null ){

            $settings = $this->get_settings();
            if( $settings['enabled'] == self::SET && $settings['email'] != '' ){
                if( $success ){
                    $link = SNS_BACKUPS_URL.$backup_file;
                    wp_mail( $settings['email'] , 'Backup of your Wordpress site!' , 'Your backup is ready. You can download it <a href="'.$link.'">here</a>' ,  'Content-type: text/html', 'sns-backup' );
                }else{
                    wp_mail( $settings['email'] ,'Backup of your Wordpress site!' , 'Your backup couldn’t be created!' );
                }
            }

        }

        public function notify_restore( $succeed ){

            $settings = $this->get_settings();
            if( $settings['enabled'] == self::SET && $settings['email'] != '' ){
                if( $succeed ){
                    wp_mail( $settings['email'] , 'Restore of your Wordpress site!' , 'Your Wordpress site was successfully restored!');
                }else{
                    wp_mail( $settings['email'] , 'Restore of your Wordpress site!' , 'Your Wordpress site restoration failed!');
                }
            }

        }

        public function validate( ){

            $valid = true;
            if( isset ( $this->settings['email'] ) && $this->settings != '' ){
                $valid = is_email ( $this->settings['email'] );
            }
            if( $valid ){
                $this->settings['email'] = (!isset($this->settings['email']))?'':$this->settings['email'];
                $this->settings['enabled'] = (isset($this->settings['enabled']) && $this->settings['enabled'] == self::SET)?self::SET:self::NOT_SET;
            }
            return $valid;

        }

        public function draw(){

            $settings = $this->get_settings();
?>
            <form  class="notifications-form">
                <div class="form-group">
                    <label class="control-label col-sm-2">Enable:</label>
                    <input id="notification-enable" name="notifications[enabled]" <?php echo ($settings['enabled'] == self::SET)?' checked="checked" ':''; ?> type="checkbox" value="<?php echo self::SET; ?>">
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-2">Email:</label>
                    <input name="notifications[email]" placeholder="email@example.com" value="<?php echo $settings['email']; ?>" id="sns-settings-email" type="text" class="form-control"/>
                </div>
                <div class="separator"></div>
                <button type="submit" class="btn btn-primary sns-action">Save</button>
            </form>
<?php
        }

    }