<?php
    class Sns_Option {

        const FULL = 'full';
        const DB = 'database';
        const PLUGINS = 'plugins';
        const THEMES = 'themes';
        const WP_CONTENT = 'wp_content';
        const COUNT = 'count';

        const SET = 1;
        const NOT_SET = 0;

        public static function get_options_list(){
            return array(
                self::FULL,
                self::DB,
                self::PLUGINS,
                self::THEMES,
                self::WP_CONTENT,
                self::COUNT
            );
        }

        public static function get_locations(){
            return array(
                self::DB => '',
                self::PLUGINS => WP_PLUGIN_DIR.SNS_DS,
                self::THEMES => get_theme_root().SNS_DS,
                self::WP_CONTENT => WP_CONTENT_DIR.SNS_DS
            );
        }

        public static function get_options( $actives = false ){
            global $wpdb;
            $table = SNS_DB_PREFIX.'options';
            $query_str = "SELECT `option`, `value` FROM {$table}";
            if( $actives ){
                $query_str .= " WHERE `value` = ".self::SET;
            }
            $options = $wpdb->get_results( $query_str , OBJECT_K );
            return $options;
        }

        public static function save( $new_options ){

            global $wpdb;

            $table = SNS_DB_PREFIX.'options';
            $options_list = self::get_options_list();

            foreach( $options_list as $option ){
                if(!isset( $new_options[$option] )){
                    $new_options[$option] = self::NOT_SET;
                }elseif( $option != self::COUNT ){
                    $new_options[$option] = self::SET;
                }
                if( $option == self::COUNT && $new_options[$option] > SNS_BACKUPS_MAX_COUNT ){
                    $new_options[$option] = SNS_BACKUPS_MAX_COUNT;
                }
                $query = "  UPDATE `{$table}`
                            SET `value` = ".intval($new_options[$option])."
                            WHERE `option` = '{$option}'
                         ";
                $wpdb->query( $query );

            }

        }

        public static function draw(){
            $options = self::get_options();
?>
            <div class="menu-content">
                <form role="form" autocomplete="off" class="options-form" action="">
                    <div class="form-group checkbox-containter">
                        <label class="checkbox-inline">
                            <input name="options[full]" class="option-full" type="checkbox" value="<?php echo self::SET; ?>" <?php echo ($options['full']->value == self::SET)?' checked ':'';?>>Full backup
                        </label>
                        <label class="checkbox-inline">
                            <input name="options[plugins]" class="option" type="checkbox" value="<?php echo self::SET; ?>" <?php echo ($options['plugins']->value == self::SET)?' checked ':'';?>>plugins folder
                        </label>
                        <label class="checkbox-inline">
                            <input name="options[wp_content]" class="option" type="checkbox" value="<?php echo self::SET; ?>"  <?php echo ($options['wp_content']->value == self::SET)?' checked ':'';?>>Any folder inside wp-content
                        </label>
                    </div>
                    <div class="form-group checkbox-containter">
                        <label class="checkbox-inline">
                            <input name="options[database]" class="option" type="checkbox" value="<?php echo self::SET; ?>"  <?php echo ($options['database']->value == self::SET)?' checked ':'';?>>Database backup
                        </label>
                        <label class="checkbox-inline">
                            <input name="options[themes]" class="option" type="checkbox" value="<?php echo self::SET; ?>"  <?php echo ($options['themes']->value == self::SET)?' checked ':'';?>>themes folder
                        </label>
                    </div>
                    <div class="separator"></div>
                    <div class="form-group">
                        <label class="control-label col-sm-4">Local backups count:</label>
                        <select name="options[count]" class="form-control">
                            <?php
                                for( $i=1; $i<=SNS_BACKUPS_MAX_COUNT; $i++ ){
                                    $selected = ( $options['count']->value == $i )?' selected="selected" ':'';
                                    echo '<option value="'.$i.'"'.$selected.'>'.$i.'</option>';
                                }
                            ?>
                        </select>
                    </div>
                    <div class="separator"></div>
                    <button type="submit" class="btn btn-primary sns-action">Save</button>
                </form>
            </div>
        <?php
        }

    }