<?php
    class Sns_Schedule {

        const CONFIG_ENABLED = '1';
        const CONFIG_DISABLED = '0';

        const CONFIG_HOURLY = 'hourly';
        const CONFIG_DAILY = 'daily';
        const CONFIG_WEEKLY = 'weekly';
        const CONFIG_MONTHLY = 'monthly';

        public static function get_config_options(){
            return array(
                self::CONFIG_HOURLY,
                self::CONFIG_DAILY,
                self::CONFIG_WEEKLY,
                self::CONFIG_MONTHLY
            );
        }

        public static function get_config(){
            global $wpdb;
            $table = SNS_DB_PREFIX.'schedule_config';
            $query = "SELECT `enabled`, `periodicity` FROM `{$table}` LIMIT 1";
            $config = $wpdb->get_results( $query , ARRAY_A );

            return $config[0];
        }

        public static function save( $new_config ){
            global $wpdb;
            $table = SNS_DB_PREFIX.'schedule_config';

            $options = self::get_config_options();

            if( in_array( $new_config['periodicity'] , $options ) ){
                $enabled = ( isset($new_config['enabled']) && $new_config['enabled'] == self::CONFIG_ENABLED )?self::CONFIG_ENABLED:self::CONFIG_DISABLED;
                $query = " UPDATE   {$table}
                           SET      `enabled` = '{$enabled}',
                                    `periodicity` = '{$new_config['periodicity']}'
                        ";
                if( $wpdb->query( $query ) === false ){
                    throw new Sns_Exception_DB_Error( $query );
                }

                wp_clear_scheduled_hook( 'sns_schedule_run_backup_hourly' );
                wp_clear_scheduled_hook( 'sns_schedule_run_backup_daily' );
                wp_clear_scheduled_hook( 'sns_schedule_run_backup_weekly' );
                wp_clear_scheduled_hook( 'sns_schedule_run_backup_monthly' );

                if( $enabled == self::CONFIG_ENABLED){
                     switch( $new_config['periodicity'] ){
                         case self::CONFIG_HOURLY:
                             wp_schedule_event( time() + 60*60, 'hourly', 'sns_schedule_run_backup_hourly');
                             break;
                         case self::CONFIG_DAILY:
                             wp_schedule_event( time() + 60*60*24, 'daily', 'sns_schedule_run_backup_daily');
                             break;
                         case self::CONFIG_WEEKLY:
                             wp_schedule_event( time() + 60*60*24*7, 'weekly', 'sns_schedule_run_backup_weekly');
                             break;
                         case self::CONFIG_MONTHLY:
                             wp_schedule_event( time() + 60*60*24*30, 'monthly', 'sns_schedule_run_backup_monthly');
                             break;
                     }
                }
                return true;
            }
            return false;

        }

        public static function on_deactivate(){

            self::clearCrons();
            global $wpdb;
            $table = SNS_DB_PREFIX.'schedule_config';
            $status = self::CONFIG_DISABLED;
            $query =  "  UPDATE   `{$table}`
                         SET      `enabled` = '{$status}'
                    ";
            $wpdb->query( $query );

        }

        public static function clearCrons(){

            wp_clear_scheduled_hook( 'sns_schedule_run_backup_hourly' );
            wp_clear_scheduled_hook( 'sns_schedule_run_backup_daily' );
            wp_clear_scheduled_hook( 'sns_schedule_run_backup_weekly' );
            wp_clear_scheduled_hook( 'sns_schedule_run_backup_monthly' );

        }

        public static function draw(){
            $config = self::get_config();
?>
            <span class="menu-title">Configure schedule</span>
            <div class="tab-content">
                <form role="form" autocomplete="off" class="schedule-form" action="">
                    <div class="form-group">
                        <label class="checkbox-inline">
                            <input name="config[enabled]" type="checkbox" value="1" <?php echo ($config['enabled'] == self::CONFIG_ENABLED)?' checked ':'';?>>Enable
                        </label>
                    </div>

                    <label>How often you want to backup?</label>
                    <div class="periodicity-block">
                        <div class="form-group">
                            <label class="radio">
                                <input type="radio" name="config[periodicity]" value="<?php echo self::CONFIG_HOURLY;?>" <?php echo ($config['periodicity'] == self::CONFIG_HOURLY)?' checked ':'';?>>Each hour
                            </label>
                        </div>
                        <div class="form-group">
                            <label class="radio">
                                <input type="radio" name="config[periodicity]" value="<?php echo self::CONFIG_DAILY;?>" <?php echo ($config['periodicity'] == self::CONFIG_DAILY)?' checked ':'';?>>Each day
                            </label>
                        </div>
                        <div class="form-group">
                            <label class="radio">
                                <input type="radio" name="config[periodicity]" value="<?php echo self::CONFIG_WEEKLY;?>" <?php echo ($config['periodicity'] == self::CONFIG_WEEKLY)?' checked ':'';?>>Each week
                            </label>
                        </div>
                        <div class="form-group">
                            <label class="radio">
                                <input type="radio" name="config[periodicity]" value="<?php echo self::CONFIG_MONTHLY;?>" <?php echo ($config['periodicity'] == self::CONFIG_MONTHLY)?' checked ':'';?>>Each month
                            </label>
                        </div>
                    </div>
                    <div class="separator"></div>
                    <label>Where you want to save your backup?</label>
                    <?php
                        $destination = new Sns_Destination( Sns_Backup::BACKUP_MODE_SCHEDULE );
                        $destination->draw();
                    ?>
                    <div class="separator"></div>
                    <button type="submit" class="btn btn-primary sns-action">Save</button>
                </form>
            </div>
        <?php
        }

    }