jQuery(document).ready(function($) {

    $('#status_color').wpColorPicker();

    $('#upload_image_button').click(function() {
        tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');
        return false;
    });

    window.send_to_editor = function(html) {
        var imgurl = $('img',html).attr('src');
        $('#status_icon').val(imgurl);
        tb_remove();
    }

    display_email_dependent_fields();

    function display_email_dependent_fields(){
        if($("#sends_email:checked").length > 0){
            $('.email_dependent_fields').show();
            $('#email_to,#from_address,#from_name,#email_subject,#display_essential_info,#display_custom_info,#custom_title,#custom_info').removeAttr('disabled');
            if(!$("#display_custom_info:checked").length > 0){
                $('#custom_info').attr('disabled','disabled');
                $("#custom_info_wrapper").hide();
            }
            if( $('#email_to').val() == 'custom'){
                $('.custom_email_dependent_fields').show();
                $('#custom_email_address').removeAttr('disabled');
            }else{
                $('.custom_email_dependent_fields').hide();
                $('#custom_email_address').attr('disabled','disabled');
            }
        } else {
            $('.email_dependent_fields, .custom_email_dependent_fields').hide();
            $('#email_to,#from_address,#from_name,#email_subject,#display_essential_info,#display_custom_info,#custom_title,#custom_info,#custom_email_address').attr('disabled','disabled');
        }
    }
    function display_custom_email_address_field () {
        if( $('#email_to').val() == 'custom'){
            $('.custom_email_dependent_fields').show();
            $('#custom_email_address').removeAttr('disabled');
        }else{
            $('.custom_email_dependent_fields').hide();
            $('#custom_email_address').attr('disabled','disabled');
        }
    }

    $('#sends_email').change(display_email_dependent_fields);

    $('#email_to').change(display_custom_email_address_field);

    $('#display_custom_info').change(function(){
        if($('#display_custom_info:checked').length > 0){
            $('#custom_info').removeAttr('disabled');
            $("#custom_info_wrapper").show();
        } else {
            $('#custom_info').attr('disabled','disabled');
            $("#custom_info_wrapper").hide();
        }
    });

    $("#add_custom_status_form").validate({
        rules : {
            'display_for[]': {required : true},
            "status_name": "required",
            "from_address": {
                required: {
                    depends: function(element) {
                        if(jQuery("#sends_email:checked").length > 0){
                            return true;
                        } else {
                            return false;
                        };
                    }
                },
                email : true
            },
            "custom_email_address": {
                required: {
                    depends: function(element) {
                        if(jQuery("#sends_email:checked").length > 0 && jQuery("#email_to").val() == 'custom'){
                            return true;
                        } else {
                            return false;
                        };
                    }
                },
                email : true
            },
            "from_name": {
                required: {
                    depends: function(element) {
                        if(jQuery("#sends_email:checked").length > 0){
                            return true;
                        } else {
                            return false;
                        };
                    }
                }
            },
            "email_subject": {
                required: {
                    depends: function(element) {
                        if(jQuery("#sends_email:checked").length > 0){
                            return true;
                        } else {
                            return false;
                        };
                    }
                }
            },
            "custom_title": "required",
            "custom_info":  {
                required: {
                    depends: function(element) {
                        if(jQuery("#display_custom_info:checked").length > 0){
                            return true;
                        } else {
                            return false;
                        };
                    }
                }
            }
        },
        invalidHandler: function(event, validator) {
            // 'this' refers to the form
            var errors = validator.numberOfInvalids();
            if (errors) {
                var message = errors == 1
                    ? 'You missed <strong>1 field</strong>. It has been highlighted'
                    : 'You missed <strong>' + errors + '</strong> fields. They\'re highlighted below.';
                $("div.error p").html(message);
                $("div.error").show();
            } else {
                $("div.error").hide();
            }
        },
        errorPlacement: function(error, element) {
            $(element).parent().siblings('th:first').append('<br/>');
            error.appendTo( $(element).parent().siblings('th:first') );
        }
    });
});