<?php

/* 	=============================
   	Configurator Options (Redux) 
   	============================= */

if (!class_exists('woocommerce_product_configurator_Redux_Framework_config')) {

    class jckpcReduxConfig {

        public $args        = array();
        public $sections    = array();
        public $ReduxFramework;
        public $slug;
        public $pluginName;
        public $pluginVersion;
        public $pluginUrl;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if ( true == Redux_Helpers::isTheme( __FILE__ ) ) {
                $this->initSettings();
            } else {
                add_action('init', array($this, 'initSettings'), 10); 
            }

        }

        public function initSettings() {
        	global $jckpc;
        	
        	$this->slug = $jckpc->slug;
        	$this->pluginName = $jckpc->name;
        	$this->pluginVersion = $jckpc->version;
        	$this->pluginUrl = $jckpc->plugin_url;

            // Set the default arguments
            $this->setArguments();

            // Set a few help tabs so you can see how it's done
            // $this->setHelpTabs();

            // Create the sections and fields
            $this->setSections();

            if (!isset($this->args['opt_name'])) { // No errors please
                return;
            }

            // If Redux is running as a plugin, this will remove the demo notice and links
            add_action( 'redux/loaded', array( $this, 'remove_demo' ) );

            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
        }


        // Remove the demo link and the notice of integrated demo from the redux-framework plugin
        function remove_demo() {

            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if (class_exists('ReduxFrameworkPlugin')) {
                remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::instance(), 'plugin_metalinks'), null, 2);

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
            }
        }
        
        // setup the sections
        public function setSections() {

            $this->sections[] = array(
                'title'     => __('General Settings', $this->slug),
                'desc'      => '',
                'icon'      => 'el-icon-cog',
                // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
                'fields'    => array(
					
					array(
					    'id'       => 'enable_img_cache',
					    'type'     => 'checkbox',
					    'title'    => __('Enable Image Cache', $this->slug), 
					    'subtitle' => '',
					    'desc'     => __('Once added to cart, the customer\'s final variation image will be cached for 24 hours.', $this->slug),
					    'default'  => '1'// 1 = on | 0 = off
					)
                    
                )
            );
            
            $this->sections[] = array(
                'title'     => __('Image Container', $this->slug),
                'desc'      => '',
                'icon'      => 'el-icon-website',
                // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
                'fields'    => array(
					
					array(
						'id'       	=> 'image_container_width',
						'type'    	=> 'dimensions',
						'units'    	=> array('em','px','%'),
						'title'    	=> __('Image Container Width', $this->slug),
						'height' 	=> false,
						'default'  => array(
							'width'   => '48%',
							'units'    => '%'
						)
					),
					
					array(
					    'id'       => 'image_container_align',
					    'type'     => 'select',
					    'title'    => __('Image Container Alignment', $this->slug),
					    // Must provide key => value pairs for select options
					    'options'  => array(
					        'left' => __('Left', $this->slug),
					        'right' => __('Right', $this->slug),
					        'centre' => __('Centre', $this->slug),
					        'none' => __('None', $this->slug)
					    ),
					    'default'  => 'left'
					),
					
					array(
					    'id'             => 'image_container_margin',
					    'type'           => 'spacing',
					    'mode'           => 'margin',
					    'units'          => array('px'),
					    'units_extended' => 'false',
					    'title'          => __('Image Container Margin', $this->slug),
					    'default'            => array(
					        'margin-top'     => '0px', 
					        'margin-right'   => '0px', 
					        'margin-bottom'  => '30px', 
					        'margin-left'    => '0px',
					        'units'          => 'px', 
					    )
					),
					
					array(
					    'id'             => 'image_container_padding',
					    'type'           => 'spacing',
					    'mode'           => 'padding',
					    'units'          => array('px'),
					    'units_extended' => 'false',
					    'title'          => __('Image Container Padding', $this->slug),
					    'default'            => array(
					        'padding-top'     => '10px', 
					        'padding-right'   => '10px', 
					        'padding-bottom'  => '10px', 
					        'padding-left'    => '10px',
					        'units'          => 'px', 
					    )
					),
					
					array(
						'id'       => 'image_container_background',
						'type'     => 'color',
						'title'    => __('Image Container Background', $this->slug),
						'default'  => '#FFFFFF',
						'validate' => 'color'
					),
					
					array(
					    'id'       => 'enable_breakpoint',
					    'type'     => 'checkbox',
					    'title'    => __('Enable Breakpoint', $this->slug), 
					    'subtitle' => '',
					    'desc'     => __('Change the Image Container Width after a certain breakpoint.', $this->slug),
					    'default'  => '1'// 1 = on | 0 = off
					),
					
					array(
						'id'       	=> 'breakpoint',
						'type'    	=> 'dimensions',
						'units'    	=> array('px'),
						'title'    	=> __('Breakpoint', $this->slug),
						'required' => array( 
							array('enable_breakpoint','=','1')
						),
						'height' 	=> false,
						'default'  => array(
							'width'   => '768px',
							'units'    => 'px'
						)
					),
					
					array(
						'id'       	=> 'image_container_width_breakpoint',
						'type'    	=> 'dimensions',
						'units'    	=> array('em','px','%'),
						'title'    	=> __('Image Container Width After Breakpoint', $this->slug),
						'required' => array( 
							array('enable_breakpoint','=','1')
						),
						'height' 	=> false,
						'default'  => array(
							'width'   => '100%',
							'units'    => '%'
						)
					),
					
					array(
					    'id'       => 'image_container_align_breakpoint',
					    'type'     => 'select',
					    'title'    => __('Image Container Alignment After Breakpoint', $this->slug),
					    'required' => array( 
							array('enable_breakpoint','=','1')
						),
					    'options'  => array(
					        'left' => __('Left', $this->slug),
					        'right' => __('Right', $this->slug),
					        'centre' => __('Centre', $this->slug),
					        'none' => __('None', $this->slug)
					    ),
					    'default'  => 'centre'
					),
					
					array(
					    'id'             => 'image_container_margin_breakpoint',
					    'type'           => 'spacing',
					    'mode'           => 'margin',
					    'units'          => array('px'),
					    'units_extended' => 'false',
					    'required' => array( 
							array('enable_breakpoint','=','1')
						),
					    'title'          => __('Image Container Margin After Breakpoint', $this->slug),
					    'default'            => array(
					        'margin-top'     => '0px', 
					        'margin-right'   => '0px', 
					        'margin-bottom'  => '30px', 
					        'margin-left'    => '0px',
					        'units'          => 'px', 
					    )
					)
                    
                )
            );
            
            $this->sections[] = array(
                'title'     => __('Thumbnails', $this->slug),
                'desc'      => '',
                'icon'      => 'el-icon-th-large',
                // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
                'fields'    => array(
					
					array(
					    'id'       => 'show_thumbs',
					    'type'     => 'checkbox',
					    'title'    => __('Show Thumbnails?', $this->slug), 
					    'subtitle' => '',
					    'desc'     => __('When enabled, the product gallery will be displayed below the main product image.', $this->slug),
					    'default'  => '1'
					),
					
					/*
					
					array(
					    'id'       => 'thumb_align',
					    'type'     => 'select',
					    'title'    => __('Thumbnail Alignment', $this->slug),
					    'desc' 	   => __('Thumbnail alignment relative to the main image.', $this->slug),
					    'required' => array( 
							array('show_thumbs','=','1')
						),
					    'options'  => array(
					        'left' => __('Left', $this->slug),
					        'right' => __('Right', $this->slug),
					        'top' => __('Top', $this->slug),
					        'bottom' => __('Bottom', $this->slug)
					    ),
					    'default'  => 'bottom'
					),
					
					*/
					
					array(
					    'id'       => 'thumb_cols_rows',
					    'type'     => 'text',
					    'title'    => __('Thumbnail Columns', $this->slug),
					    'desc'     => __('Number of Thumbnails in a Column.', $this->slug),
					    'validate' => 'numeric',
					    'required' => array( 
							array('show_thumbs','=','1')
						),
					    'msg'      => 'Please enter a valid number.',
					    'default'  => '3'
					),
					
					array(
					    'id'       => 'thumb_spacing',
					    'type'     => 'text',
					    'title'    => __('Thumbnail Spacing (px)', $this->slug),
					    'desc'     => '',
					    'validate' => 'numeric',
					    'msg'      => 'Please enter a number (in pixels) for the thumbnail spacing.',
					    'default'  => '10'
					),
                    
                )
            );
            
            $this->sections[] = array(
                'title'     => __('Loader Styling', $this->slug),
                'desc'      => '',
                'icon'      => 'el-icon-refresh',
                // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
                'fields'    => array(
					
					array(
						'id'       => 'loading_overlay_colour',
						'type'     => 'color',
						'title'    => __('Loading Overlay Colour', $this->slug),
						'default'  => '#FFFFFF',
						'validate' => 'color'
					),
					
					array(
					    'id'       => 'loading_overlay_opacity',
					    'type'     => 'text',
					    'title'    => __('Loading Overlay Opacity', $this->slug),
					    'desc'     => __('Enter a number between 0 and 1. <br>0 = transparent, 1 = opaque.', $this->slug),
					    'validate' => 'numeric',
					    'msg'      => 'Please enter a number for the opacity.',
					    'default'  => '0.5'
					),
					
					array(
					    'id'       => 'loading_icon',
					    'type'     => 'image_select',
					    'title'    => __('Loading Icon', $this->slug), 
					    'subtitle' => '',
					    'options'  => array(
					        'spin1'      => array(
					            'alt'   => 'Spin 1', 
					            'img'   => $this->pluginUrl.'inc/admin/img/spin1.png'
					        ),
					        'spin2'      => array(
					            'alt'   => 'Spin 2', 
					            'img'   => $this->pluginUrl.'inc/admin/img/spin2.png'
					        ),
					        'spin3'      => array(
					            'alt'   => 'Spin 3', 
					            'img'  => $this->pluginUrl.'inc/admin/img/spin3.png'
					        ),
					        'spin4'      => array(
					            'alt'   => 'Spin 4', 
					            'img'   => $this->pluginUrl.'inc/admin/img/spin4.png'
					        ),
					        'spin5'      => array(
					            'alt'   => 'Spin 5', 
					            'img'   => $this->pluginUrl.'inc/admin/img/spin5.png'
					        ),
					        'spin6'      => array(
					            'alt'   => 'Spin 6', 
					            'img'  => $this->pluginUrl.'inc/admin/img/spin6.png'
					        )
					    ),
					    'default' => 'spin1'
					),
					
					array(
						'id'       => 'loading_icon_colour',
						'type'     => 'color',
						'title'    => __('Loading Icon Colour', $this->slug),
						'default'  => '#CCCCCC',
						'validate' => 'color'
					),
                    
                )
            );
			
			
        }

		// setup help tabs (not used currently)
        public function setHelpTabs() {

            // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
            $this->args['help_tabs'][] = array(
                'id'        => 'redux-help-tab-1',
                'title'     => __('Theme Information 1', $this->slug),
                'content'   => __('<p>This is the tab content, HTML is allowed.</p>', $this->slug)
            );

            $this->args['help_tabs'][] = array(
                'id'        => 'redux-help-tab-2',
                'title'     => __('Theme Information 2', $this->slug),
                'content'   => __('<p>This is the tab content, HTML is allowed.</p>', $this->slug)
            );

            // Set the help sidebar
            $this->args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', $this->slug);
        }

	/* 	=============================
	   	All the possible arguments for Redux.
	    For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments 
	   	============================= */
	   	
        public function setArguments() {

            $theme = wp_get_theme(); // For use with some settings. Not necessary.

            $this->args = array (
			  'opt_name' => 'jckpc_options',
			  'global_variable' => 'jckpc_options',
			  'default_mark' => ' *',
			  'hints' => 
			  array (
			    'icon' => 'el-icon-question-sign',
			    'icon_position' => 'right',
			    'icon_color' => 'lightgray',
			    'icon_size' => 'normal',
			    'tip_style' => 
			    array (
			      'color' => 'light',
			    ),
			    'tip_position' => 
			    array (
			      'my' => 'top left',
			      'at' => 'bottom right',
			    ),
			    'tip_effect' => 
			    array (
			      'show' => 
			      array (
			        'duration' => '500',
			        'event' => 'mouseover',
			      ),
			      'hide' => 
			      array (
			        'duration' => '500',
			        'event' => 'mouseleave unfocus',
			      ),
			    ),
			  ),
			  'menu_title' => 'Configurator',
			  'menu_type' => 'submenu',
			  'output' => '1',
			  'output_tag' => '1',
			  'page_icon' => 'icon-plugins',
			  'page_parent' => 'woocommerce',
			  'page_permissions' => 'manage_options',
			  'page_slug' => 'jck-product-configurator',
			  'page_title' => 'WooCommerce Product Configurator',
			  'save_defaults' => '1',
			  'show_import_export' => '0',
			);

            $this->args["display_name"] = $this->pluginName;
            $this->args["display_version"] = $this->pluginVersion;

			// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
			
            $this->args['share_icons'][] = array(
                'url'   => 'http://twitter.com/jamesckemp',
                'title' => 'Follow me on Twitter',
                'icon'  => 'el-icon-twitter'
            );
            $this->args['share_icons'][] = array(
                'url'   => 'http://www.jckemp.com/plugins/woocommerce-product-configurator/',
                'title' => 'Read the Documentation',
                'icon'  => 'el-icon-book'
            );

        }

    }
    
    global $reduxConfig;
    $reduxConfig = new jckpcReduxConfig();
}