<?php
/*
Plugin Name: WooCommerce Product Configurator
Plugin URI: http://www.jckemp.com
Description: Product Configurator plugin for WooCommerce
Version: 1.0.0
Author: James Kemp
Author Email: support@jckemp.com  
*/

class jckpc {

/* 	=============================
   	// !Constants 
   	============================= */	
   	
   	public $name = 'WooCommerce Product Configurator';
   	public $shortname = 'Configurator';
	public $slug = 'jckpc';
    public $version = "1.0.0";
    public $plugin_path;
    public $plugin_url;
    public $uploads_path;
    public $uploads_url;
	
/* 	=============================
   	// !Constructor 
   	============================= */
   	
	public function __construct()
	{
		
		$this->plugin_path = plugin_dir_path( __FILE__ );
        $this->plugin_url = plugin_dir_url( __FILE__ );
        $upload_dir = wp_upload_dir();
        $this->uploads_path = $upload_dir['basedir'].'/'.$this->slug.'-uploads';
        $this->uploads_url = $upload_dir['baseurl'].'/'.$this->slug.'-uploads';

		// Hook up to the init and plugins_loaded actions
		add_action( 'plugins_loaded', array( &$this, 'plugins_loaded' ) );
		add_action( 'init', array( &$this, 'initiate' ) );
	}
  
/* 	=============================
   	// !Runs when the plugin is initialized 
   	============================= */
   	
   	public function plugins_loaded()
   	{
   		// Load TGM and Redux Framework Options
	   	require $this->plugin_path . '/inc/admin/admin-init.php';
	   	
	   	add_filter( 'woocommerce_cart_item_thumbnail', array( &$this, 'cart_thumbnail' ), 10, 3 );
   	}
   	
	public function initiate()
	{		
		// Setup localization
		load_plugin_textdomain( $this->slug, false, dirname( plugin_basename( __FILE__ ) ) . '/lang' );
		
		// Create uploads folder
		if (!file_exists($this->uploads_path)) {
			mkdir($this->uploads_path, 0775, true);
		}
		
	/* 	=============================
	   	// !Trigger Functions on Init 
	   	============================= */
	
		if ( is_admin() )
		{
			add_action( 'woocommerce_product_write_panel_tabs', array( &$this, 'product_config_tab' ) );
			add_action( 'woocommerce_product_write_panels', array( &$this, 'product_config_tab_options' ) );
			add_action( 'woocommerce_process_product_meta', array( &$this, 'process_meta_product_config_tab' ), 10, 2 );
			
			add_action( 'wp_ajax_'.$this->slug.'_generate_image', array( &$this, 'generate_image' ) );
			add_action( 'wp_ajax_nopriv_'.$this->slug.'_generate_image', array( &$this, 'generate_image' ) );
			
			add_action( 'wp_ajax_'.$this->slug.'_get_composite_img_url', array( &$this, 'get_composite_img_url' ) );
			add_action( 'wp_ajax_nopriv_'.$this->slug.'_get_composite_img_url', array( &$this, 'get_composite_img_url' ) );
			
			add_action( 'wp_ajax_'.$this->slug.'_get_image_layer', array( &$this, 'get_image_layer' ) );
			add_action( 'wp_ajax_nopriv_'.$this->slug.'_get_image_layer', array( &$this, 'get_image_layer' ) );
			$this->register_scripts_and_styles();
		} else {
			add_action( 'template_redirect', array( &$this, 'setup_configurator_image' ), 20 );	
			add_action( 'template_redirect', array( &$this, 'register_scripts_and_styles' ) );
			add_action( 'woocommerce_order_item_name', array( &$this, 'add_image_to_order_item' ), 20, 2 );	
			add_action( 'woocommerce_order_item_class', array( &$this, 'order_item_class' ), 20, 3 );
		}
		 
	}
	
	public function setup_configurator_image(){
		global $post;
		
		$configuratorEnabled = get_post_meta( $post->ID, $this->slug.'_enabled', true );
		
		if($configuratorEnabled){
			$this->remove_hooks();
			add_action( 'woocommerce_before_single_product_summary', array( &$this, 'display_product_image' ), 20 );
		}
	}
	
	public function remove_hooks()
	{
		global $jckWooThumbsClass;
		
		remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);
		remove_action('woocommerce_before_single_product_summary', array( $jckWooThumbsClass, 'show_product_images' ), 20); 		
		
		// Remove images from Bazar theme
		if( class_exists( 'YITH_WCMG' ) )
		{
			$this->remove_filters_for_anonymous_class( 'woocommerce_before_single_product_summary', 'YITH_WCMG_Frontend', 'show_product_images', 20 );
			$this->remove_filters_for_anonymous_class( 'woocommerce_product_thumbnails', 'YITH_WCMG_Frontend', 'show_product_thumbnails', 20 );
		}
	}
	
/* 	=============================
   	Product Configurator Admin Tab 
   	============================= */
   	
   	public function configurator_allowed($post_id)
   	{
	   	$product = get_product( $post_id );
	   	
	   	if($product->is_type( 'variable' )) {
	   		$prodAtts = $product->get_variation_attributes();
	   		if(is_array($prodAtts) && !empty($prodAtts)) return true;
	   	}
	   	
	   	return false;
   	}
   	
   	// display tab in left hand side
	function product_config_tab( $tabs )
	{		
		global $post;
		
		if($this->configurator_allowed($post->ID))
		{
			echo '<li class="'.$this->slug.'_options_tab"><a href="#'.$this->slug.'_options">'.__($this->shortname, $this->slug).'</a></li>';
		}
	}
	
	function product_config_tab_options()
	{
		global $post;
		
		if($this->configurator_allowed($post->ID))
		{
			
			$setImages = get_post_meta( $post->ID, $this->slug.'_images', true );
			$defaults = get_post_meta( $post->ID, $this->slug.'_defaults', true );
			
			echo '<div id="'.$this->slug.'_options" class="panel woocommerce_options_panel">';
				
				echo '<div class="options_group">';
					echo '<p class="form-field">';
						woocommerce_wp_checkbox( array( 
							'id' => $this->slug.'_enabled', 
							'label' => __('Enable '.$this->shortname, $this->slug), 
							'description' => '' 
						) );
					echo '</p>';
				echo '</div>';
				
				$atts = $this->get_product_atts($post->ID);			
				
				foreach($atts as $attSlug => $attData)
				{
					echo '<div class="options_group custom_tab_options">';
						echo '<h2 style="padding-left: 12px;">'.$attData['name'].'</h2>';
						
						echo '<p class="form-field">';
							echo '<label>'.__('Default Value', $this->slug).'</label>';
							
							$selectName = $this->slug.'_defaults['.$attSlug.']';
							
							echo '<select name="'.$selectName.'">';
								echo '<option value="">'.__('Select a default...', $this->slug).'</value>';
								foreach($attData['values'] as $value)
								{
									$default = (isset($defaults[$attSlug])) ? $defaults[$attSlug] : '';
									echo '<option value="'.$value['att_val_slug'].'" '.selected($default, $value['att_val_slug'], 0).'>'.$value['att_val_name'].'</value>';
								}
							echo '</select>';
						echo '</p>';
						
						echo '<table class="widefat fixed" style="margin: 10px 12px 30px; width: 96%;">';
							
							echo '<thead>';
								echo '<tr>';
									echo '<th>'.__('Value', $this->slug).'</th>';
									echo '<th>'.__('Image', $this->slug).'</th>';
									echo '<th>'.__('Actions', $this->slug).'</th>';
								echo '</tr>';
							echo '</thead>';
							
							$tr_i = 0; foreach($attData['values'] as $value)
							{
							
								$rowName = $value['att_val_name'];
								$fieldName = $this->slug.'_images['.$attSlug.']['.$value['att_val_slug'].']';
								$fieldId = $attSlug.'_'.$value['att_val_slug'].'_image';
								$selectedImageId = (isset($setImages[$attSlug][$value['att_val_slug']])) ? $setImages[$attSlug][$value['att_val_slug']] : '';
								$popupTitle = sprintf( __('Set image for when %s is %s', $this->slug), esc_attr($attData['name']), esc_attr($value['att_val_name']) );
								$popupBtnTxt = __('Set Image', $this->slug);
								$btnText = __('Add Image', $this->slug);
								$classes = ($tr_i%2 == 0) ? 'alternate' : '';
								
								echo $this->image_upload_row($rowName, $fieldName, $fieldId, $selectedImageId, $popupTitle, $popupBtnTxt, $btnText, $classes);
								
							$tr_i++; }
							
						echo '</table>';
					echo '</div>';
				}
				
				echo '<div class="options_group custom_tab_options">';
				
					$rowName = __('Background Image', $this->slug);
					
					echo '<h2 style="padding-left: 12px;">'.$rowName.'</h2>';
					
					echo '<table class="widefat fixed" style="margin: 10px 12px 30px; width: 96%;">';
							
						echo '<thead>';
							echo '<tr>';
								echo '<th>&nbsp;</th>';
								echo '<th>'.__('Image', $this->slug).'</th>';
								echo '<th>'.__('Actions', $this->slug).'</th>';
							echo '</tr>';
						echo '</thead>';
						
						$fieldName = $this->slug.'_images[background]';
						$fieldId = $attSlug.'_background_image';
						$selectedImageId = (isset($setImages['background'])) ? $setImages['background'] : '';
						$popupTitle = __('Set background image', $this->slug);
						$popupBtnTxt = __('Set Image', $this->slug);
						$btnText = __('Add Image', $this->slug);
						$classes = 'alternate';
						
						echo $this->image_upload_row($rowName, $fieldName, $fieldId, $selectedImageId, $popupTitle, $popupBtnTxt, $btnText, $classes);
						
					echo '</table>';
				echo '</div>';
			
			echo '</div>';
		}
	}
	
	function process_meta_product_config_tab( $post_id )
	{
		if($this->configurator_allowed($post_id))
		{
			update_post_meta( $post_id, $this->slug.'_enabled', ( isset($_POST[$this->slug.'_enabled']) && $_POST[$this->slug.'_enabled'] ) ? 'yes' : 'no' );
			
			$images = ( isset($_POST[$this->slug.'_images']) && is_array($_POST[$this->slug.'_images']) ) ? $_POST[$this->slug.'_images'] : array();		
			update_post_meta( $post_id, $this->slug.'_images', $images );
			
			$defaults = ( isset($_POST[$this->slug.'_defaults']) && is_array($_POST[$this->slug.'_defaults']) ) ? $_POST[$this->slug.'_defaults'] : array();
			update_post_meta( $post_id, $this->slug.'_defaults', $defaults );	
		}
	}
	
	// helper to get attributes in a unified format
	public function get_product_atts($prod_id)
	{
		$product = get_product($prod_id);
		$atts = $product->get_attributes();
		
		$attVals = array();
		
		foreach($atts as $attName => $attData)
		{
			
			if($attData['is_variation'])
			{		
				$attVals[$attName] = array();
				
				$attVall_i = 0;
			
				if($attData['is_taxonomy'])
				{
					$tax = get_taxonomy($attName);
					$attVals[$attName]['name'] = $tax->labels->name;
					$terms = get_terms($attName);
					foreach($terms as $term)
					{
						$attVals[$attName]['values'][$attVall_i]['att_val_name'] = $term->name;
						$attVals[$attName]['values'][$attVall_i]['att_val_slug'] = $term->slug;
						$attVall_i++;
					}
				} else {
					$attVals[$attName]['name'] = $attData['name'];
					$terms = explode(' | ', $attData['value']);
					foreach($terms as $term)
					{
						$attVals[$attName]['values'][$attVall_i]['att_val_name'] = $term;
						$attVals[$attName]['values'][$attVall_i]['att_val_slug'] = sanitize_title_with_dashes($term);
						$attVall_i++;
					}
				}			
			}
		}
		
		return $attVals;
	}
	
	// layout helper for image table rows
	public function image_upload_row($rowName, $fieldName, $fieldId, $selectedImageId, $popupTitle, $popupBtnTxt, $btnText, $classes = '')
	{
	
		$return = '';
		$return .= '<tr class="uploader '.$classes.'">';
								
			$return .= '<td>'.$rowName.'</td>';
			
			$selectedImageSrc = ($selectedImageId != '') ? wp_get_attachment_image_src($selectedImageId, 'thumbnail') : false;
			$selectedImageUrl = ($selectedImageSrc) ? $selectedImageSrc[0] : false;
			
			$return .= '<td>';
				$return .= '<input type="hidden" name="'.$fieldName.'" id="'.$fieldId.'" value="'.$selectedImageId.'" />';
				$return .= '<div id="'.$fieldId.'_thumbwrap" class="'.$this->slug.'_attthumb" style="height: 50px; width: 50px; background: #eee;">';
					if($selectedImageSrc) $return .= '<img src="'.$selectedImageUrl.'" width="50" height="50">';
				$return .= '</div>';
			$return .= '</td>';
			
			$return .= '<td>';
				$return .= '<a href="#" class="'.$this->slug.'_upload_image_button" id="'.$fieldId.'_button" data-uploader_title="'.$popupTitle.'" data-uploader_button_text="'.$popupBtnTxt.'" data-uploader_field="#'.$fieldId.'">'.$btnText.'</a>';
				$return .= ' | <a href="#" class="'.$this->slug.'_remove_image_button" data-uploader_field="#'.$fieldId.'">'.__('Remove Image', $this->slug).'</a>';
			$return .= '</td>';
		
		$return .= '</tr>';
		
		return $return;
	}
	
/* 	=============================
   	Frontend Single Product Page 
   	============================= */
   	
   	public function display_product_image()
   	{
   		global $post, $jckpc_options;
   		
   		/*
   		echo '<pre>';
   		print_r($jckpc_options);
   		echo '</pre>';
   		*/
   		
   		$setImages = get_post_meta( $post->ID, $this->slug.'_images', true );
   		$defaults = get_post_meta( $post->ID, $this->slug.'_defaults', true );
   		
   		$images = array();
   		
   		if( $setImages['background'] && $setImages['background'] != '' )
   		{
   			$imgSrc = wp_get_attachment_image_src($setImages['background'], apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ));
	   		$images[] = '<img id="'.$this->slug.'_image_background" src="'.$imgSrc[0].'">';
   		}
   		
   		$setImages = array_reverse($setImages);
	   	
   		$img_i = 1; foreach($setImages as $attSlug => $attVals)
   		{
   			$default = ( isset($defaults[$attSlug]) && isset($setImages[$attSlug][$defaults[$attSlug]]) ) ? $setImages[$attSlug][$defaults[$attSlug]] : false;
   				
   			$images[$img_i] = '<div id="'.$this->slug.'_image_'.$attSlug.'">';
   			
	   			if($default)
	   			{
	   				$imgSrc = wp_get_attachment_image_src($default, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ));
		   			$images[$img_i] .= '<img src="'.$imgSrc[0].'">';
	   			}
   			
   			$images[$img_i] .= '</div>';
   		$img_i++; }
   		
   		// output images
   		
   		echo '<style>';
   			echo '#jckpc_images {';
   				// width
   				echo "width: {$jckpc_options['image_container_width']['width']};";
   				// align
   				if($jckpc_options['image_container_align'] == "centre")
   				{
	   				echo "margin-left: auto; margin-right: auto;";
	   				$jckpc_options['image_container_align'] = "none"; 
   				}
   				echo "float: {$jckpc_options['image_container_align']};";
   				// spacing
   				echo "margin-top: {$jckpc_options['image_container_margin']['margin-top']};";
   				echo "margin-right: {$jckpc_options['image_container_margin']['margin-right']};";
   				echo "margin-bottom: {$jckpc_options['image_container_margin']['margin-bottom']};";
   				echo "margin-left: {$jckpc_options['image_container_margin']['margin-left']};";
   				// padding
   				echo "padding-top: {$jckpc_options['image_container_padding']['padding-top']};";
   				echo "padding-right: {$jckpc_options['image_container_padding']['padding-right']};";
   				echo "padding-bottom: {$jckpc_options['image_container_padding']['padding-bottom']};";
   				echo "padding-left: {$jckpc_options['image_container_padding']['padding-left']};";
   				// background
   				echo "background: {$jckpc_options['image_container_background']};";
   			echo '}';
   			
   			$horThumbSpacing = $jckpc_options['thumb_spacing']/2;
   			$verThumbSpacing = $jckpc_options['thumb_spacing'];
   				
   			echo "#jckpc_thumbnails {";
   				echo "margin: {$verThumbSpacing}px -{$horThumbSpacing}px -{$verThumbSpacing}px;";
   			echo "}";
   			
   			echo '#jckpc_thumbnails a {';
   				echo "float: left;";
   				echo "display: inline;";
   				$thumbWidth = 100/(int)$jckpc_options['thumb_cols_rows'];
   				echo "width: {$thumbWidth}%;";
   				// spacing
   				echo "padding: 0 {$horThumbSpacing}px {$verThumbSpacing}px;";
   			echo '}';
   			
   			echo "#jckpc_image_wrap #jckpc_loading {";
   				// background
   				echo "background: {$jckpc_options['loading_overlay_colour']};";
   			echo "}";
   			
   			echo "#jckpc_image_wrap #jckpc_loading i {";
   				
   				$loadingIconMTop = 20/2;
   				
   				echo "font-size: 20px;";
   				echo "line-height: 20px;";
   				echo "margin-top: -{$loadingIconMTop}px;";
   				echo "color: {$jckpc_options['loading_icon_colour']};";
   			echo "}";
   			
   			// breakpoint
   			if($jckpc_options['enable_breakpoint'])
   			{
	   			echo "@media (max-width: {$jckpc_options['breakpoint']['width']}) {";
	   				echo '#jckpc_images {';
	   					// width
		   				echo "width: {$jckpc_options['image_container_width_breakpoint']['width']};";
		   				// align
		   				if($jckpc_options['image_container_align_breakpoint'] == "centre")
		   				{
			   				echo "margin-left: auto; margin-right: auto;";
			   				$jckpc_options['image_container_align_breakpoint'] = "none"; 
		   				}
		   				echo "float: {$jckpc_options['image_container_align_breakpoint']};";
		   				// spacing
		   				echo "margin-top: {$jckpc_options['image_container_margin_breakpoint']['margin-top']};";
		   				echo "margin-right: {$jckpc_options['image_container_margin_breakpoint']['margin-right']};";
		   				echo "margin-bottom: {$jckpc_options['image_container_margin_breakpoint']['margin-bottom']};";
		   				echo "margin-left: {$jckpc_options['image_container_margin_breakpoint']['margin-left']};";
	   				echo "}";
	   			echo "}";
   			}
   		echo '</style>';
   		
   		echo '<div id="'.$this->slug.'_images">';
   		
		   	echo '<div id="'.$this->slug.'_image_wrap" data-loading="0">';
		   	
		   		foreach($images as $image)
		   		{
		   			echo $image;
		   		}
		   		
		   		echo '<div id="'.$this->slug.'_loading"><i class="jckpc-icn-'.$jckpc_options['loading_icon'].' animate-spin"></i></div>';	   		
		   		
		   	echo '</div>';
		   	
		   	if($jckpc_options['show_thumbs']) $this->get_thumbnails();
		   	
	   	echo '</div>';
	   	
   	}
   	
   	public function get_thumbnails()
   	{
	   	global $post, $product, $woocommerce;

		$attachment_ids = $product->get_gallery_attachment_ids();
		
		if ( $attachment_ids ) {
			
			echo '<div id="'.$this->slug.'_thumbnails">';
		
				$loop = 0;
				$columns = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
		
				foreach ( $attachment_ids as $attachment_id ) {
		
					$classes = array( 'zoom' );
		
					if ( $loop == 0 || $loop % $columns == 0 )
						$classes[] = 'first';
		
					if ( ( $loop + 1 ) % $columns == 0 )
						$classes[] = 'last';
		
					$image_link = wp_get_attachment_url( $attachment_id );
		
					if ( ! $image_link )
						continue;
		
					$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ) );
					$image_class = esc_attr( implode( ' ', $classes ) );
					$image_title = esc_attr( get_the_title( $attachment_id ) );
		
					echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="%s" class="%s" title="%s" data-rel="prettyPhoto[product-gallery]">%s</a>', $image_link, $image_class, $image_title, $image ), $attachment_id, $post->ID, $image_class );
		
					$loop++;
				}
		
			echo '</div>';
		}
   	}
   	
   	public function get_image_data($pid, $atts)
   	{
	   	$imgData = array(
	   		'prodid' => $pid
	   	);
	   	
	   	if(!empty($atts)){
	   		foreach($atts as $attSlug => $attVal)
	   		{
	   			if(substr($attSlug, 0, 10) != "attribute_") $attSlug = 'attribute_'.$attSlug;
		   		$imgData[$attSlug] = sanitize_title_with_dashes($attVal);
	   		}
   		}
   		
   		return $imgData;	   	
   	}
   	
   	public function get_image_layer()
   	{
   		check_ajax_referer( $this->slug.'_ajax', 'nonce' );
   		
	   	$setImages = get_post_meta( $_POST['prodid'], $this->slug.'_images', true );
	    
	    header('Content-Type: application/json');
	    
	    $response = array(
	    	'response' => 'success'
	    );
	    
	    if($_POST['selectedVal'] == ""){
		    $defaults = get_post_meta( $_POST['prodid'], $this->slug.'_defaults', true );
		    $_POST['selectedVal'] = (isset($defaults[$_POST['selectedAtt']])) ? $defaults[$_POST['selectedAtt']] : false;
	    }
	    
	    if($_POST['selectedVal']){
		    $imgID = $setImages[$_POST['selectedAtt']][$_POST['selectedVal']];
		    $imgSrc = wp_get_attachment_image_src($imgID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ));
		    
		    $response['image'] = '<img src="'.$imgSrc[0].'" id="'.$this->slug.'_image_'.$_POST['selectedAtt'].'">';
	    } else {
		    $response['image'] = false;
	    }
	    
	    echo json_encode($response);
	    
	    die;
   	}
   	
   	public function ajax_img_get_params(){
   	
   		$params = array();
   	
	   	$params['setImages'] = get_post_meta( $_GET['prodid'], $this->slug.'_images', true );
	    $params['chosenAtts'] = $this->get_atts_from_querystring( $_GET['prodid'] );
	    $params['images'] = $this->get_images_from_chosen_atts($params['setImages'], $params['chosenAtts']);
	    
	    $params['imgData'] = $this->generate_img_paths($_GET['prodid'], $params['chosenAtts']);
	    
	    return $params;
	    
   	}
   	
   	public function generate_img_paths($prodid, $chosenAtts){
   		$imgName = $prodid.'-'.implode('-', array_filter($chosenAtts));
   		return array(
   			'imgName' => $imgName,
   			'finalImgPath' => $this->uploads_path.'/'.$imgName.'.png',
   			'finalImgUrl' => $this->uploads_url.'/'.$imgName.'.png'
   		);
   	}
   	
   	public function generate_image()
   	{
	   	
	    $params = $this->ajax_img_get_params();
	    
	    $bgSet = (isset($params['setImages']['background']) && $params['setImages']['background'] != '') ? true : false;
		   	
	   	// If bg is et, use it
	   	if($bgSet)
	   	{
		   	$bgsrc = wp_get_attachment_image_src($params['setImages']['background'], apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ));
		   	$compW = $bgsrc[1];
		   	$compH = $bgsrc[2];
		   	
		   	$bg = imagecreatefrompng($bgsrc[0]);
		   	
		// If no bg is set, create a base at the correct size,
		// but set it to be completely transparent
		} else {	   	
		   	list($compW, $compH) = getimagesize($params['images'][0]);
		   	$bg = imagecreatetruecolor($compW, $compH);
		   	
		   	imagesavealpha($bg, true);
		   	
		   	$trans_colour = imagecolorallocatealpha($bg, 0, 0, 0, 127);
		   	imagefill($bg, 0, 0, $trans_colour);
		}
		
		foreach ($params['images'] as $index => $srcImagePath)
		{	
			$img = imagecreatefrompng($srcImagePath);
			
			$x = 0;
			$y = 0;
			
			imagecopyresized($bg, $img, 0, 0, 0, 0, $compW, $compH, $compW, $compH);
			imagedestroy($img);
		}
		
		header('Content-Type: image/png');
		$createFinalImg = imagepng($bg, $params['imgData']['finalImgPath']);
		
		if($createFinalImg){
			set_transient( $params['imgData']['imgName'], $params['imgData']['finalImgUrl'], 24 * HOUR_IN_SECONDS );
			imagepng($bg);
		}
		
		die;
   	}
   	
   	public function get_atts_from_querystring( $prodid = false, $qarr = false )
   	{
   		
   		if(!$qarr) $qarr = $_GET;
   		
   		// Get defaults
   		$atts = get_post_meta( $prodid, $this->slug.'_defaults', true );
   		
	   	foreach ($qarr as $key => $value) 
	   	{
		    if (substr($key, 0, 10) == "attribute_")
		    {
		        $atts[str_replace('attribute_', '', $key)] = $value;
		    }
		}
		return $atts;
   	}
   	
   	public function get_images_from_chosen_atts($setImages, $chosenAtts)
   	{
   		$images = array();
	   	foreach($chosenAtts as $attSlug => $attVal)
	   	{
	   		if(isset($setImages[$attSlug][$attVal]) && $setImages[$attSlug][$attVal] != "")
	   		{
	   			$imgsrc = wp_get_attachment_image_src($setImages[$attSlug][$attVal], apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ));
	   			$images[] = $imgsrc[0];
	   		}
	   	}
	   	// reverse so the layering is correct
	   	return array_reverse($images);
   	}
   	
   	public function get_product_image_url($imgData)
   	{
	   	global $jckpc_options;
	   	
	   	$qstring = http_build_query($imgData);
	   	
	   	$chosenAtts = $this->get_atts_from_querystring($imgData['prodid'], $imgData);
	   	$imgPaths = $this->generate_img_paths($imgData['prodid'], $chosenAtts);
	   	
	   	if(!$jckpc_options['enable_img_cache']) delete_transient( $imgPaths['imgName'] );
	   	
	   	if ( false === get_transient( $imgPaths['imgName'] ) ) 
	    {
	    	return admin_url('admin-ajax.php').'?action=jckpc_generate_image&'.$qstring;
	    } else {
		    return $imgPaths['finalImgUrl'];
	    }
   	}
   	
/* 	=============================
   	Cart Functions 
   	============================= */
   	
   	public function cart_thumbnail($thumb, $cart_item, $cart_item_key){
	
		// check if product has configurator enable, otherwise echo $thumb instead
		
		$configuratorEnabled = get_post_meta( $cart_item['product_id'], $this->slug.'_enabled', true );
		
		if($configuratorEnabled){
			
			$atts = (isset($cart_item['variation']) && !empty($cart_item['variation'])) ? $cart_item['variation'] : array();
			
			$imgData = $this->get_image_data($cart_item['product_id'], $atts);
	   		
	   		return '<img src="'.$this->get_product_image_url($imgData).'">';
   		
   		}
   		
   		return $thumb;
	}
	
/* 	=============================
   	Order Functions 
   	============================= */
   	
   	public function order_item_class($class, $item, $order)
	{
		$prodid = $item['product_id'];
		
		$configuratorEnabled = get_post_meta( $prodid, $this->slug.'_enabled', true );
		
		if($configuratorEnabled)
		{
			$class .= ' '.$this->slug.'_configurated';
		}
		
		return $class;
	}
	
	public function add_image_to_order_item($item_name, $item)
	{	
		$prodid = $item['product_id'];
		
		$configuratorEnabled = get_post_meta( $prodid, $this->slug.'_enabled', true );
		
		if($configuratorEnabled)
		{
			$_product = get_product($prodid);
			$item_meta = new WC_Order_Item_Meta( $item['item_meta'], $_product );
			$attsStr = explode(', ', $item_meta->display(true, true));
			$atts = array();
			
			foreach($attsStr as $attStr)
			{
				$attStrSplit = explode(': ', $attStr);
				$atts[trim($attStrSplit[0])] = trim($attStrSplit[1]);
			}			
			
			$imgData = $this->get_image_data($prodid, $atts);
			$imgUrl = $this->get_product_image_url($imgData);
	   		
			$item_name = '<a href="'.$imgUrl.'" target="_blank" class="'.$this->slug.'_order_item_img"><img src="'.$imgUrl.'"></a> '.$item_name;
		}
		
		return $item_name;
	}
  
/* 	=============================
   	// !Frontend Scripts and Styles 
   	============================= */
   	
	public function register_scripts_and_styles()
	{
		if ( is_admin() )
		{
			$this->load_file( $this->slug . '-script', '/assets/admin/js/'.$this->slug.'-scripts.min.js', true );
		} else {
			global $post, $jckpc_options;
			
			$configuratorEnabled = get_post_meta( $post->ID, $this->slug.'_enabled', true );
			
			if(is_product() && $configuratorEnabled) {
				global $post;
			
				$this->load_file( $this->slug . '-script', '/assets/frontend/js/'.$this->slug.'-scripts.min.js', true );
				$this->load_file( $this->slug . '-style', '/assets/frontend/css/'.$this->slug.'-styles.min.css' );
				
				$vars = array( 
					'ajaxurl' => admin_url('admin-ajax.php'),
					'prodid' => $post->ID,
					'nonce' => wp_create_nonce( $this->slug.'_ajax' ),
					'settings' => $jckpc_options
				);
				
				wp_localize_script( $this->slug . '-script', $this->slug, $vars );		
				
			}	
		} // end if/else
	} // end register_scripts_and_styles
	
/* 	=============================
   	Helper function for registering and enqueueing scripts and styles.
   	@name: 			The ID to register with WordPress
   	@file_path: 	The path to the actual file
   	@is_script:		Optional argument for if the incoming file_path is a JavaScript source file.
   	@deps:			Array of dependancies
   	@inFooter:		Whther to load this script in the footer
   	============================= */
	
	private function load_file( $name, $file_path, $is_script = false, $deps = array('jquery'), $inFooter = true )
	{

		$url = plugins_url($file_path, __FILE__);
		$file = plugin_dir_path(__FILE__) . $file_path;

		if( file_exists( $file ) )
		{
			if( $is_script )
			{
				wp_register_script( $name, $url, $deps, $this->version, $inFooter ); //depends on jquery
				wp_enqueue_script( $name );
			} else {
				wp_register_style( $name, $url, array(), $this->version );
				wp_enqueue_style( $name );
			} // end if
		} // end if

	} // end load_file
	
/* 	=============================
   	Allow to remove method for a hook when it's a class method used
   	and the class doesn't have a variable assigned, but the class name is known
   	@hook_name: 	Name of the wordpress hook
   	@class_name: 	Name of the class where the add_action resides
   	@method_name:	Name of the method to unhook
   	@priority:		The priority of which the above method has in the add_action
   	============================= */
   	
	public function remove_filters_for_anonymous_class( $hook_name = '', $class_name ='', $method_name = '', $priority = 0 )
	{
	        global $wp_filter;
	        
	        // Take only filters on right hook name and priority
	        if ( !isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority]) )
	                return false;
	        
	        // Loop on filters registered
	        foreach( (array) $wp_filter[$hook_name][$priority] as $unique_id => $filter_array )
	        {
	                // Test if filter is an array ! (always for class/method)
	                if ( isset($filter_array['function']) && is_array($filter_array['function']) )
	                {
	                        // Test if object is a class, class and method is equal to param !
	                        if ( is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && get_class($filter_array['function'][0]) == $class_name && $filter_array['function'][1] == $method_name )
	                        {
	                                unset($wp_filter[$hook_name][$priority][$unique_id]);
	                        }
	                }
	                
	        }
	        
	        return false;
	}
  
} // end class

$jckpc = new jckpc();