<?php
/**
 *
 *   View for displaying saved TM EPOs
 *
 */

// Direct access security
if ( !defined( 'TM_EPO_PLUGIN_SECURITY' ) ) {
    die();
}
global $post_id, $tm_is_ajax, $woocommerce;
$attributes = maybe_unserialize( get_post_meta( $post_id, '_product_attributes', true ) );
$tm_meta_cpf=get_post_meta( $post_id, 'tm_meta_cpf', true );

// Check for variations
$variation_attribute_found = false;
if ( $attributes ) {
    foreach ( $attributes as $attribute ) {
        if ( isset( $attribute['is_variation'] ) ) {
            $variation_attribute_found = true;
            break;
        }
    }
}

// Get variations
$args = array(
    'post_type'     => 'product_variation',
    'post_status'   => array( 'private', 'publish' ),
    'numberposts'   => -1,
    'orderby'       => 'menu_order',
    'order'         => 'asc',
    'post_parent'   => $post_id
);
$variations = get_posts( $args );

if ( !$tm_is_ajax ):
?>
<div id="tm_extra_product_options" class="panel wc-metaboxes-wrapper">
    <div id="tm_extra_product_options_inner">
<?php
endif;
//  $variation_attribute_found && $variations
if ( ! ( $attributes  ) ) : ?>
        <div id="message" class="inline woocommerce-message">
            <p><?php _e( 'Before adding Extra Options, add and save some attributes on the <strong>Attributes</strong> tab.', TM_EPO_TRANSLATION ); ?></p>
        </div>
<?php else : ?>
        <p class="toolbar">
            <a href="#" class="close_all"><?php _e( 'Close all', TM_EPO_TRANSLATION ); ?></a><a href="#" class="expand_all"><?php _e( 'Expand all', TM_EPO_TRANSLATION ); ?></a>
        </p>
        <div class="woocommerce_tm_epos wc-metaboxes">
<?php
// Get parent data
$parent_data = array(
    'id'            => $post_id,
    'attributes'    => $attributes
);

$args = array(
    'post_type'     => TM_EPO_LOCAL_POST_TYPE,
    'post_status'   => array( 'private', 'publish' ),
    'numberposts'   => -1,
    'orderby'       => 'menu_order',
    'order'         => 'asc',
    'post_parent'   => $post_id
);
$tmepos = get_posts( $args );

if ( $tmepos ) {
    $loop = 0;
    foreach ( $tmepos as $price ) {
        $tmcp_id                        = absint( $price->ID );
        $tmcp_post_status               = esc_attr( $price->post_status );
        $tmcp_data                      = get_post_meta( $tmcp_id );
        $variation_fields               = array(
            '_regular_price',
            'tmcp_required',
            'tmcp_hide_price',
            'tmcp_limit',
            '_regular_price_type'
        );
        foreach ( $variation_fields as $field ) {
            $$field                     = isset( $tmcp_data[ $field ][0] ) ? maybe_unserialize( $tmcp_data[ $field ][0] ) : '';

        }
        /*
        * $key = attirbute
        * $k = variation
        * $v = price
        */
        if ( isset($_regular_price) && is_array( $_regular_price ) ) {
            foreach ( $_regular_price as $key=>$value ) {
                foreach ( $value as $k=>$v ) {
                    $_regular_price[$key][$k]=wc_format_localized_price( $v );
                }

            }
        }

        include ('html-tm-epo-admin.php');

        $loop++;
    }
}
?>
        </div>
        <p class="toolbar">
            <button type="button" class="fr button button-primary tm_add_epo" <?php disabled( ( count($attributes)>0 ), false ); ?>><?php _e( 'Add Extra Option', TM_EPO_TRANSLATION ); ?></button>
            <span class="fr">
<?php
/* Ouput Attributes List */
_e( 'Attribute:', TM_EPO_TRANSLATION );
echo ' <select class="tmcp_attr_list" name="tmcp_attr_list">';
foreach ( $attributes as $attribute ) {
    // Only deal with attributes that are not variations
    if (  $attribute['is_variation'] ) {
        continue;
    }

    echo '<option value="' . esc_attr( sanitize_title( $attribute['name'] ) ) . '">' . esc_html( wc_attribute_label( $attribute['name'] ) ) . '</option>';
}
echo '</select>';
?>
            </span>
        </p>



<div class="options_group woocommerce_options_panel">
<p class="form-field">
<?php
/* Ouput Exclude */
$tm_exclude=isset($tm_meta_cpf['exclude'])?$tm_meta_cpf['exclude']:'';
echo '<label for="tm_meta_cpf_exclude">'.__( 'Exclude from Global Extra Product Options:', TM_EPO_TRANSLATION ).'</label>';
echo '<input type="checkbox" value="1" id="tm_meta_cpf_exclude" name="tm_meta_cpf[exclude]" class="checkbox" '.checked(  $tm_exclude , '1' ,0) .'>';
?>
</p>
<p class="form-field">
<?php
/* Ouput Override */
$tm_override_display=isset($tm_meta_cpf['override_display'])?$tm_meta_cpf['override_display']:'';
echo '<label for="tm_meta_cpf_override_display">'.__( 'Override global display:', TM_EPO_TRANSLATION ).'</label>';
echo '<select id="tm_meta_cpf_override_display" name="tm_meta_cpf[override_display]">';
echo '<option value="" '.selected(  $tm_override_display , '' ,0) .'>' . __( 'Use global setting', TM_EPO_TRANSLATION ) . '</option>';
echo '<option value="normal" '.selected(  $tm_override_display , 'normal' ,0) .'>' . __( 'Always show', TM_EPO_TRANSLATION ) . '</option>';
echo '<option value="action" '.selected(  $tm_override_display , 'action' ,0) .'>' . __( 'Show only with action hook', TM_EPO_TRANSLATION ) . '</option>';
echo '</select>';
?>
</p>
</div>
<?php 
endif;

if ( !$tm_is_ajax ):
?>
    </div>
</div>
<?php endif; ?>