<?php
function klasik_child_styles() {
	if (!is_admin()) {
		/********** STYLE CONFIGURATION *************/
		wp_deregister_style('googleFonts');
		wp_register_style('googleFonts', 'http://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700,300italic,400italic|Homemade+Apple');
		wp_enqueue_style( 'googleFonts');
		
		wp_deregister_style( 'flexslider-css');
		wp_register_style('layerslider-css', get_stylesheet_directory_uri().'/css/layerslider.css', '', '', 'screen, all');
		wp_enqueue_style( 'layerslider-css');
		
		/********** SCRIPT CONFIGURATION *************/
		
		wp_register_script('jlayerslider', get_stylesheet_directory_uri().'/js/layerslider.js', array('jquery'), '1.0', true);
		wp_enqueue_script('jlayerslider');
		wp_register_script('jelastislide', get_stylesheet_directory_uri().'/js/jquery.elastislide.js', array('jquery'), '1.0', true);
		wp_enqueue_script('jelastislide');
		
		wp_dequeue_script('jquicksand');
		wp_register_script('jisotope', get_stylesheet_directory_uri().'/js/jquery.isotope.min.js', array('jquery'), '1.5.19', true);
		wp_enqueue_script('jisotope');
		
		wp_enqueue_script('jcustom');
		
	}
}

function klasik_child_setup() {
	remove_theme_support( 'post-formats');
	
	add_image_size( 'image-slider', 315, 227, true ); // Slider
	add_image_size( 'thumb-standard', 400, 297, true ); // Blog Image
	add_image_size( 'widget-feature', 133, 116, true );
	add_image_size( 'widget-portfolio', 400, 229, true );
	add_image_size( 'widget-post', 400, 229, true );
	
	remove_action("klasik_foot","klasik_print_js_quicksand",4);
	remove_action("klasik_foot","klasik_print_js_carousel",2);
	
}

add_action( 'after_setup_theme', 'klasik_child_setup' );
add_action('init', 'klasik_child_styles');

function klasik_custom_sidebar_init(){

	register_sidebar(array(
		'name'          => __('Top', 'klasik' ),
		'id'         	=> 'top',
		'description'   => __( 'Located at the top in the same row as logo.', 'klasik' ),
		'before_widget' => '<div class="widget-top"><ul><li id="%1$s" class="widget-container %2$s">',
		'after_widget' 	=> '<div class="clear"></div></li></ul></div>',
		'before_title' 	=> '<h3 class="widget-title">',
		'after_title' 	=> '</h3>',
	));
	
	register_sidebar(array(
		'name'          => __('Homepage Highlight', 'klasik' ),
		'id'         	=> 'homehighlight',
		'description'   => __( 'Located at the top of the slider in the homepage.', 'klasik' ),
		'before_widget' => '<div class="widget-homehighlight"><ul><li id="%1$s" class="widget-container %2$s">',
		'after_widget' 	=> '<div class="clear"></div></li></ul></div>',
		'before_title' 	=> '<h3 class="widget-title">',
		'after_title' 	=> '</h3>',
	));
	
	register_sidebar(array(
		'name'          => __('Footer Highlight', 'klasik' ),
		'id'         	=> 'footerhighlight',
		'description'   => __( 'Located at the top of the footersidebar.', 'klasik' ),
		'before_widget' => '<div id="%1$s" class="widget-footerhighlight %2$s">',
		'after_widget' 	=> '<div class="clear"></div></div>',
		'before_title' 	=> '<h3 class="widget-title">',
		'after_title' 	=> '</h3>',
	));
	
}
add_action( 'widgets_init', 'klasik_footer5_sidebar_init' );
add_action( 'widgets_init', 'klasik_custom_sidebar_init' );

function klasik_child_features_item_template($val, $content=''){
	$tpl = '<div class="%%CLASS%%" id="f-%%ID%%">';
		$tpl .= '<div class="border-container">';
			$tpl .= '<div class="item-container">';
				$tpl .= '<div class="feature-title-container">';
					$tpl .= '<div class="img-container">%%THUMB%%</div>';
					$tpl .= '<h3 class="feature-title">%%TITLE%%</h3>';
				$tpl .= '</div>';
				
				$tpl .= '<div class="feature-text">%%TEXT%%</div>';
	
				$tpl .= '<div class="clear"></div>';
			$tpl .= '</div>';
		$tpl .= '</div>';
	$tpl .= '</div>';
	return $tpl;
}

add_filter('klasik_features_item_template', 'klasik_child_features_item_template',2);

function klasik_child_pfilter_item_template($val, $content=''){
	$tpl  = '<div data-id="id-%%ID%%" class="%%CLASS%%">';
						
		$tpl .= '<div class="klasik-pf-img"><div class="shadowBottom">';
			$tpl .= '<a class="pfzoom" href="%%FULLIMG%%" data-rel=prettyPhoto[mixed] title="%%FULLIMGTITLE%%"><span class="rollover"></span>%%THUMB%%</a>';
			$tpl .= '<div class="clear"></div>';
		$tpl .= '</div></div>';
		
		$tpl .= '<div class="clear"></div>';
	$tpl .= '</div>';
	return $tpl;
}

add_filter('klasik_pfilter_item_template', 'klasik_child_pfilter_item_template',2);

if(!function_exists("ts_minicart")){
	function ts_minicart($id="",$class=""){
		
		global $woocommerce;
		$cart_subtotal = $woocommerce->cart->get_cart_subtotal();
		$link = $woocommerce->cart->get_cart_url();
		
		ob_start();
		the_widget('WC_Widget_Cart', '', array('widget_id'=>'cart-dropdown',
			'before_widget' => '',
			'after_widget' => '',
			'before_title' => '<span class="hidden">',
			'after_title' => '</span>'
		));
		$widget = ob_get_clean();
		
		$output = '<div id="'.$id.'" class="'.$class.'">';
			$output .= '<div id="shopping_cart">';
				$output .= '<a class="topcartbutton btnpanel" id="shop-bag" href="'.$link.'">'.$cart_subtotal.'</a><a class="cart_subtotal"></a>';
				$output .= '<div class="shop-box">';
					$output .= $widget;
				$output .= '</div>';
			$output .= '</div>';
		$output .= '</div>';
		
		return $output;
	}
}

if(!function_exists("klasik_child_print_js_carousel")){
	
	function klasik_child_print_js_carousel(){
	?>
	<script type="text/javascript">
	jQuery(document).ready(function(){
		//Add Class Js to html
		jQuery('.flexslider-carousel').flexslider({
			animation: "slide",
			touch:true,
			animationLoop: false,
			controlNav: false,
			itemWidth: 139,
			itemMargin: 0,
			minItems: 2,
			maxItems: 6
		});
	});
	</script>
	<?php
	}
	add_action("klasik_foot","klasik_child_print_js_carousel",2);
}

function klasik_child_options($val, $attr = '', $content = null){
	
	$shortname = 'klasik';
	
	$options = $val;
	$options[] = array( 'name' => __('Styles', 'templatesquare'),
		'type' => 'heading');
	
	$options[] = array( 'name' => __('Change Theme Color', 'templatesquare'),
		'desc' => __('Please change the color here to suit your need.', 'templatesquare'),
		'id' => $shortname."_theme_color",
		'std' => '#ff5555',
		'type' => 'color');
		
	$options[] = array( 'name' => __('Your Own Background', 'templatesquare'),
		'desc' => __('You can set your own background for your theme from here. It will overwrite the default theme background', 'templatesquare'),
		'id' => $shortname."_bgtheme",
		'std' => array(
			'color' => '',
			'image' => '',
			'repeat' => '',
			'position' => '',
			'attachment' => ''
		),
		'type' => 'background');
	
	return $options;
	
}
add_filter('klasik_optionsframework_options', 'klasik_child_options');

if(!function_exists("klasik_child_colorcss")){
	
	function klasik_child_colorcss(){
		$themecolorcss = klasik_get_option( 'klasik_theme_color');
		$optBGTheme = klasik_get_option( 'klasik_bgtheme');
			
		$optBGThemeColor = '';
		$optBGThemeImage = '';
		$optBGThemePosition = 'top center';
		$optBGThemeStyle = 'repeat';
		$optBGThemeAttachment = 'scroll';
		
		if($optBGTheme['color']!="" || $optBGTheme['image']!=""){
			$optBGThemeColor = $optBGTheme['color'];
			$optBGThemeImage = $optBGTheme['image'];
			$optBGThemePosition = $optBGTheme['position'];
			$optBGThemeStyle = $optBGTheme['repeat'];
			$optBGThemeAttachment = $optBGTheme['attachment'];
		}
		?>
        
        <?php if($optBGThemeImage!="" || $optBGThemeColor!=""){?>
		<style type="text/css" media="screen">
        body{
            background-color:<?php echo $optBGThemeColor ; ?>;
            background-image:url(<?php echo $optBGThemeImage ; ?>);
            background-repeat:<?php echo $optBGThemeStyle ; ?>;
            background-position: <?php echo $optBGThemePosition; ?>;
            background-attachment: <?php echo $optBGThemeAttachment ; ?>;
            
        }
        </style>
        <?php } ?>
        
		<?php
		if($themecolorcss !="" ){
		?>
		<style type="text/css">
		#layerslider.slideritems h3{background-color:<?php echo $themecolorcss; ?>;		}
		.entry-utility a, .entry-utility a:visited{ color:<?php echo $themecolorcss; ?>;}
		body.klasikt .products .star-rating span{color:<?php echo $themecolorcss; ?>;}
		body.klasikt span.onsale{background:<?php echo $themecolorcss; ?>;}
		body.klasikt div.product span.price, body.klasikt #content div.product span.price, body.klasikt div.product p.price, body.klasikt #content div.product p.price{color:<?php echo $themecolorcss; ?>;}
		body.klasikt a.button.alt, body.klasikt button.button.alt, body.klasikt input.button.alt, body.klasikt #respond input#submit.alt, body.klasikt #content input.button.alt{background:<?php echo $themecolorcss; ?>;}
		a, .colortext{color:<?php echo $themecolorcss; ?>;}
		body.klasikt ul.products li.product .price{color:<?php echo $themecolorcss; ?>;}
		#filter li.current a, #filter li a:hover{color:<?php echo $themecolorcss; ?>; }
		#filter li a:hover{color:<?php echo $themecolorcss; ?>;}
		.klasik-pf-text .pftitle a:hover{color:<?php echo $themecolorcss; ?>;}
        </style>
		<?php 
		} 
	}
	add_action("klasik_head","klasik_child_colorcss",9);
}