<?php
/**
 * The Template for displaying all single posts.
 *
 * @package WordPress
 * @subpackage Lastore
 * @since Lastore 1.0
 */

get_header(); ?>

    <div id="singlepost">
    
         <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
         <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
         
            
            <?php
            $custom = get_post_custom($post->ID);
			$cf_disablemeta = (isset($custom["klasik_disable_meta"][0]))? $custom["klasik_disable_meta"][0] : "";
            
            if(has_post_thumbnail($post->ID) ){
                $thumb = '<div class="postimg">'.get_the_post_thumbnail($post->ID, 'thumb-standard', array('alt' => '')).'<span class="shadow-680"></span></div>';
            }else{
                $thumb ="";
            }
            ?>
             
             <div class="header-wrapper">
                <?php 
				if($cf_disablemeta==""){ $hasmetaclass = 'hasmeta'; 
				?>
                <div class="entry-utility">
                    <div class="date"><?php the_time('F d, Y'); ?></div>
                    <div class="tag">/ <?php the_category(', '); ?></div>
                    <div class="comment">/ <?php comments_popup_link(__('No Comments', 'templatesquare'), __('1 Comments', 'templatesquare'), __('% Comments', 'templatesquare')); ?></div>
                </div>
                <?php
				 }else{
				 $hasmetaclass = 'nometa';
				 }
				 ?>
             </div>
             
             <div class="entry-text <?php echo $hasmetaclass; ?>">
                 <div class="entry-content">
                     <?php the_content(__('Read More','templatesquare'));?>
                </div>
             </div> 
             
            
         </article>
        <?php
        
        // If a user has filled out their description, show a bio on their entries.
        if ( get_the_author_meta( 'description' ) && $cf_disablemeta=="") : ?>
        <div id="entry-author-info">
            <div id="author-avatar">
                <?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'templatesquare_author_bio_avatar_size', 60 ) ); ?>
            </div><!-- author-avatar -->
            <div id="author-description">
                <h2><span class="author"><?php printf( __( 'About %s', 'templatesquare' ), get_the_author() ); ?></span></h2>
                <?php the_author_meta( 'description' ); ?>
            </div><!-- author-description	-->
        </div><!-- entry-author-info -->
        <?php endif; ?>

        <?php comments_template( '', true ); ?>
        
        <?php endwhile; ?>
    
    </div><!-- singlepost --> 

<?php get_footer(); ?>