/**
 * JS scripts processed in admin panel
 */

( function( $ ){
    $( document ).ready( function(){

        /**
         * Function handles the transfer od data between lightbox iframe and the editor.
          * In addition, it also sets up the thumbnails and values.
        */
        var handle_switching_image = function( image_id, html ) {
            $( 'body' ).append( '<div id="colorizer-temp-image">' + html + '</div>' );

            var img = $( '#colorizer-temp-image' ).find( 'img' ),
                imgid = parseInt( img.attr( 'class' ).replace( /\D/g, '' ), 10 );

            $( '#' + image_id ).val( imgid );
            $( '#' + image_id + '-thumb' ).attr( 'src', img.attr( 'src' ) );
            $( '#colorizer-temp-image' ).remove();

            tb_remove();
        }

        /**
         * Function handles the uploading of the mask image
         * @param string html
         */
        window.handle_colorizer_mask_image = function( html ) {
            handle_switching_image( php_data.mask_id, html );
        };

        /**
         * Function handles the uploading of the mask image
         * @param string html
         */
        window.handle_colorizer_background_image = function( html ) {
            handle_switching_image( php_data.background_id, html );
        };

        // Uploading new image
        $( '.admin-colorizer-container' ).on( 'click', '.add-colorizer-image', function( e ){
            e.preventDefault();

            window.send_to_editor = window['handle_' + $( this ).siblings( 'input[type=hidden]' ).attr( 'id' )];
            tb_show( '', 'media-upload.php?post_id=0&amp;type=image&amp;TB_iframe=true' );
        });

        // Remove the image
        $( '.admin-colorizer-container' ).on( 'click', '.remove-colorizer-image', function(){
            if ( confirm( php_data.confirm ) ) {
                var image_id = $( this ).siblings( 'input[type=hidden]' ).attr( 'id' );
                $( '#' + image_id + '-thumb' ).attr( 'src', php_data.def_image );
                $( '#' + image_id ).val( '' );
            }
        });

        // Plug colorpicker into attribute field
        $( '#tag-' + php_data.colorpicker_id ).iris({
            hide: false,
            palettes: true,
            mode: 'hsv'
        });
    });
})( jQuery );