<?php
/**
 * Template displays two images which will be converted by colorizer
 * @param string $image_link
 * @param string $image_title
 * @param string $gallery
 * @param string $image
 * @param string $colorizer_image
 * @param string $image_size
 * @param array $colors
 * @param string $background_image
 */
?>

<a href="<?php print $image_link; ?>" itemprop="image" class="woocommerce-main-image zoom" title="<?php print $image_title; ?>"
   rel="prettyPhoto <?php print $gallery; ?>">
    <div class="colorizer-image">
        <?php print $image; ?>
        <?php print wp_get_attachment_image( $colorizer_image, $image_size, false, array( 'id' => 'mask', 'class' => 'mask' ) ); ?>
    </div>
</a>

<?php foreach( $colors as $name => $rgb ): ?>
	<input type="hidden" id="colorizer-color-<?php print $name; ?>" value="<?php print $rgb; ?>" />
<?php endforeach;  ?>

<?php if ( !empty( $background_image ) ): ?>
	<style type="text/css">
		#mask {
			background-image: url(<?php print $background_image; ?>);
		}
	</style>
<?php endif;