(function($) {
    "use strict";

    $(document).ready(function() {

        var _tm_check_for_changes = 0;
        var tm_epo_sortable_options = {
            items: '.woocommerce_tm_epo',
            cursor: 'move',
            axis: 'y',
            handle: 'h3',
            scrollSensitivity: 40,
            forcePlaceholderSize: true,
            helper: 'clone',
            opacity: 0.65,
            placeholder: 'wc-metabox-sortable-placeholder',
            start: function(event, ui) {
                ui.item.css('background-color', '#f6f6f6');
            },
            stop: function(event, ui) {
                ui.item.removeAttr('style');
                tm_epo_row_indexes();
            }
        };

        /**
         * Update boxes
         */
        function tm_epo_update_boxes() {
            jQuery('.woocommerce_tm_epo').each(function(index, element) {
                var _root = jQuery(element);
                var _current_att = _root.find('.tmcp_attribute').val();
                _root.find('select.tmcp_att').hide();
                _root.find('select.tmcp_att.tmcp_attribute_' + _current_att).show();
                var attribute = _root.find('select.tmcp_att').val();
                var variation = _root.find('select.tmcp-variation').val();
                var show_field = "input.tmcp-price-input-attribute-" + attribute + ".tmcp-price-input-variation-" + variation+",select.tmcp-price-input-attribute-" + attribute + ".tmcp-price-input-variation-" + variation;
                _root.find("input.tmcp-price-input").hide();
                _root.find("select.tmcp-price-input-type").hide();
                _root.find(show_field).show();
                tm_epo_show_price_field(_root.find('select.tmcp-variation'), "variation");
            });
            // trigger woocommerce hide classes function
            jQuery('input#_downloadable').trigger('change');
        }
        tm_epo_update_boxes();

        function tm_epo_show_price_field(obj, what) {
            var val = obj.val();
            var _root = obj.closest('.woocommerce_tm_epo');
            _root.find("input.tmcp-price-input").hide();
            _root.find("select.tmcp-price-input-type").hide();
            var loop = _root.find('input.tmcp_loop').val();
            var attribute = _root.find('select.tmcp_att').val();
            var variation = _root.find('select.tmcp-variation').val();
            var show_field = "";
            switch (what) {
                case "variation":
                    variation = val;
                    show_field = "input.tmcp-price-input-variation-" + val + ".tmcp-price-input-attribute-" + attribute+",select.tmcp-price-input-variation-" + val + ".tmcp-price-input-attribute-" + attribute;
                    break;
                case "attribute":
                    attribute = val;
                    show_field = "input.tmcp-price-input-attribute-" + val + ".tmcp-price-input-variation-" + variation+",select.tmcp-price-input-attribute-" + val + ".tmcp-price-input-variation-" + variation;
                    break;
            }
            if (_root.find(show_field).length <= 0) {
                _root.find(".tmcp_pricing td").append('<input type="text" size="5" name="tmcp_regular_price[' + loop + '][' + attribute + '][' + variation + ']" value="" class="wc_input_price tmcp-price-input tmcp-price-input-variation-' + variation + ' tmcp-price-input-attribute-' + attribute + '" />');
                _root.find(".tmcp_pricing td").append('<select class="tmcp-price-input-type tmcp-price-input tmcp-price-input-variation-' + variation + ' tmcp-price-input-attribute-' + attribute + '" name="tmcp_regular_price_type[' + loop + '][' + attribute + '][' + variation + ']"><option value="">'+tm_epo_admin_meta_boxes.i18n_fixed_type+'</option><option value="percent">'+tm_epo_admin_meta_boxes.i18n_percent_type+'</option></select>');            
            }
            _root.find(show_field).show();
        }

        $('#tm_extra_product_options').on('change', 'select.tmcp-variation', function(e) {
            tm_epo_show_price_field($(this), "variation");
        });
        $('#tm_extra_product_options').on('change', 'select.tmcp_att', function(e) {
            tm_epo_show_price_field($(this), "attribute");
        });

        /**
         * Set Ordering
         */
        $('#tm_extra_product_options').on('woocommerce_tm_epo_added', function() {
            $('.woocommerce_tm_epos').sortable(tm_epo_sortable_options);
        });
        $('#tm_extra_product_options').on('woocommerce_tm_epos_loaded', function() {
            $('.woocommerce_tm_epos').sortable(tm_epo_sortable_options);
        });

        function tm_epo_row_indexes() {
            $('.woocommerce_tm_epos .woocommerce_tm_epo').each(function(index, el) {
                $('.tm_epo_menu_order', el).val(parseInt($(el).index('.woocommerce_tm_epos .woocommerce_tm_epo'), 10));
            });
        }
        $('.woocommerce_tm_epos').sortable(tm_epo_sortable_options);

        /*
         * Add custom check handlers
         */
        function tm_epo_check() {

            if (_tm_check_for_changes == 1) {
                $('#tm_extra_product_options').block({
                    message: null,
                    overlayCSS: {
                        background: '#fff url(' + tm_epo_admin_meta_boxes.plugin_url + '/images/ajax-loader.gif) no-repeat center',
                        opacity: 0.6
                    }
                });
                var data = {
                    action: 'woocommerce_tm_load_epos',
                    post_id: tm_epo_admin_meta_boxes.post_id,
                    security: tm_epo_admin_meta_boxes.load_tm_epo_nonce
                };
                $.post(tm_epo_admin_meta_boxes.ajax_url, data, function(response) {
                    $('#tm_extra_product_options_inner').html(response);
                    $('#tm_extra_product_options').unblock();
                    $('#tm_extra_product_options').trigger('woocommerce_tm_epos_loaded');
                    _tm_check_for_changes = 0;
                    tm_epo_update_boxes();
                });
            }

        }



        $('#variable_product_options').on('click', 'button.remove_variation', function(e) {
            _tm_check_for_changes = 1;
        });
        $('#variable_product_options').on('woocommerce_variations_added', function() {
            _tm_check_for_changes = 1;
        });
        $('.product_attributes').on('click', 'button.add_new_attribute', function() {
            _tm_check_for_changes = 1;
        });
        $('.save_attributes').on('click', function() {
            _tm_check_for_changes = 1;
        });
        $('.tm_epo_class a').on('click', function() {
            tm_epo_check();
        });

        /*
         * Add extra option
         */
        $('#tm_extra_product_options').on('click', 'button.tm_add_epo', function() {
            var attribute_type = $('select.tmcp_attr_list').val();
            var thisrow = $('.woocommerce_tm_epos .woocommerce_tm_epo.' + attribute_type);
            if (thisrow.length > 0) {
                thisrow.find('.woocommerce_tmcp_attributes').show();
                return;
            }
            $('.woocommerce_tm_epos').block({
                message: null,
                overlayCSS: {
                    background: '#fff url(' + tm_epo_admin_meta_boxes.plugin_url + '/images/ajax-loader.gif) no-repeat center',
                    opacity: 0.6
                }
            });
            var loop = $('.woocommerce_tm_epo').length;
            var data = {
                action: 'woocommerce_tm_add_epo',
                post_id: tm_epo_admin_meta_boxes.post_id,
                att_id: attribute_type,
                loop: loop,
                security: tm_epo_admin_meta_boxes.add_tm_epo_nonce
            };
            $.post(tm_epo_admin_meta_boxes.ajax_url, data, function(response) {
                if (response == 'max') {
                    alert(tm_epo_admin_meta_boxes.i18n_max_tmcp);
                    $('.woocommerce_tm_epos').unblock();
                } else {
                    $('.woocommerce_tm_epos').append(response);
                    $('.woocommerce_tm_epos').unblock();
                    $('#tm_extra_product_options').trigger('woocommerce_tm_epo_added');
                    tm_epo_update_boxes();
                }
            });
            return false;
        });

        /*
         * Remove extra option
         */
        $('#tm_extra_product_options').on('click', 'button.remove_tm_epo', function(e) {
            e.preventDefault();
            var answer = window.confirm(tm_epo_admin_meta_boxes.i18n_remove_tmcp);
            if (answer) {
                var el = $(this).parent().parent();
                var variation = $(this).attr('rel');
                if (variation > 0) {
                    $(el).block({
                        message: null,
                        overlayCSS: {
                            background: '#fff url(' + tm_epo_admin_meta_boxes.plugin_url + '/images/ajax-loader.gif) no-repeat center',
                            opacity: 0.6
                        }
                    });
                    var data = {
                        action: 'woocommerce_tm_remove_epo',
                        tmcpid: variation,
                        security: tm_epo_admin_meta_boxes.delete_tm_epo_nonce
                    };
                    $.post(tm_epo_admin_meta_boxes.ajax_url, data, function(response) {
                        // Success
                        $(el).fadeOut('300', function() {
                            $(el).remove();
                        });
                    });
                } else {
                    $(el).fadeOut('300', function() {
                        $(el).remove();
                    });
                }
            }
            return false;
        });
    });
})(jQuery);