<?php
/*
Plugin Name: TM WooCommerce Extra Product Options
Plugin URI: http://epo.themecomplete.com/
Description: A WooCommerce plugin for adding extra product options.
Version: 2.1.1
Author: themecomplete
Author URI: http://themecomplete.com/
*/

define ( 'TM_EPO_PLUGIN_SECURITY', 1 );
define ( 'TM_EPO_TRANSLATION', 'tm-extra-product-options' );
define ( 'TM_EPO_LOCAL_POST_TYPE', "tm_product_cp" );
define ( 'TM_EPO_GLOBAL_POST_TYPE', "tm_global_cp" );

class EPO_CHECK {
    function __construct() {
        add_action( 'admin_init', array( $this, 'check_version' ) );

        if ( ! self::compatible_version() ) {
            return;
        }
    }

    function check_version() {
        if ( ! self::compatible_version() ) {
            if ( is_plugin_active( plugin_basename( __FILE__ ) ) ) {
                deactivate_plugins( plugin_basename( __FILE__ ) );
                add_action( 'admin_notices', array( $this, 'disabled_notice' ) );
                if ( isset( $_GET['activate'] ) ) {
                    unset( $_GET['activate'] );
                }
            }
        }
        if ( self::old_version() ) {
            deactivate_plugins( 'woocommerce-tm-custom-price-fields/tm-woo-custom-prices.php' );
            add_action( 'admin_notices', array( $this, 'deprecated_notice' ) );
        }
    }

    function deprecated_notice() {
        $active_plugins = apply_filters( 'active_plugins', get_option('active_plugins' ) );
            
            if ( in_array( 'woocommerce-tm-custom-price-fields/tm-woo-custom-prices.php', $active_plugins ) ){
                $deactivate_url = 'plugins.php?action=deactivate&plugin=' . urlencode( 'woocommerce-tm-custom-price-fields/tm-woo-custom-prices.php' ) . '&plugin_status=all&paged=1&s&_wpnonce=' . urlencode( wp_create_nonce( 'deactivate-plugin_woocommerce-tm-custom-price-fields/tm-woo-custom-prices.php' ) );
                $message = '<strong>Important:</strong> It is highly recommended that you <a href="' . esc_url( admin_url( $deactivate_url ) ) . '">deactivate the old Custom Price Fields</a> plugin.';
                echo '<div class="error fade"><p>' . $message . '</p></div>' . "\n";
            }else{
                $delete_url = 'plugins.php?action=delete-selected&checked%5B0%5D=' . urlencode( 'woocommerce-tm-custom-price-fields/tm-woo-custom-prices.php' ) . '&plugin_status=all&paged=1&s&_wpnonce=' . urlencode( wp_create_nonce( 'bulk-plugins' ) );
                $message = '<strong>Important:</strong> It is highly recommended that you <a href="' . esc_url( admin_url( $delete_url ) ) . '">delete the old Custom Price Fields</a> plugin.';
                echo '<div class="error fade"><p>' . $message . '</p></div>' . "\n";
            }       
    }

    function disabled_notice() {
        $message = '<strong>Important:</strong> TM WooCommerce Extra Product Options requires WordPress 3.5 or later.';
        echo '<div class="error fade"><p>' . $message . '</p></div>' . "\n";       
    } 

    public function stop_plugin(){
        if ( ! self::compatible_version() ) {
            return true;
        }
        if ( self::old_version() ) {
            return true;
        }

        return false;
    }

    static function activation_check() {
        if ( ! self::compatible_version() ) {
            deactivate_plugins( plugin_basename( __FILE__ ) );
            wp_die( __( 'TM WooCommerce Extra Product Options requires WordPress 3.5 or later.', TM_EPO_TRANSLATION ) );
        }
    }

    static function compatible_version() {
        if ( version_compare( $GLOBALS['wp_version'], '3.5', '<' ) ) {
             return false;
         }

        return true;
    }

    static function old_version() {
        if (  class_exists( 'TM_Custom_Prices' )  )  {
             return true;
         }

        return false;
    }
}

global $epo_check;
$epo_check = new EPO_CHECK();
register_activation_hook( __FILE__, array( 'EPO_CHECK', 'activation_check' ) );
if ($epo_check->stop_plugin()){
    return;
}

require_once ('external/tm-functions.php');

if ( tm_woocommerce_check() ) {
    
    /**
     * Load plugin textdomain.
     */
    function tm_epo_load_textdomain() {
        load_plugin_textdomain( 'tm-extra-product-options', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' ); 
    }
    add_action( 'plugins_loaded', 'tm_epo_load_textdomain' );    

    /**
     *  Register post type
     */
    function tm_epo_register_post_type(){
        register_post_type( TM_EPO_LOCAL_POST_TYPE,
            array(
                'labels'                => array(
                    'name' => _x( 'TM Extra Product Options', 'post type general name' , TM_EPO_TRANSLATION)
                ),
                'publicly_queryable'    => false,
                'exclude_from_search'   => true,
                'rewrite'               => false,
                'show_in_nav_menus'     => false,
                'public'                => false,
                'hierarchical'          => false,
                'supports'              => false
            )
        );
        register_post_type( TM_EPO_GLOBAL_POST_TYPE,
            array(
                'show_ui'               => false,
                'capability_type'       => 'product',
                'map_meta_cap'          => true,
                'publicly_queryable'    => false,
                'exclude_from_search'   => true,
                'rewrite'               => false,
                'query_var'             => false,
                'show_in_nav_menus'     => false,
                'labels'                => array(
                    'name'          => _x( 'TM Global Product Options', 'post type general name' , TM_EPO_TRANSLATION),
                    'edit_item'     => __( 'Edit Global Product Options Form', TM_EPO_TRANSLATION ),
                    'search_items'  => __( 'Search Forms', TM_EPO_TRANSLATION ),
                ),
                'public'                => false,
                'hierarchical'          => false,
                'supports'              => array( 'title', 'excerpt' )
            )
        );
        register_taxonomy_for_object_type( 'product_cat', TM_EPO_GLOBAL_POST_TYPE );
    }
    add_action( 'init', 'tm_epo_register_post_type' );

    /**
     * Load HTML functions
     */
    include_once ( 'class-tm-epo-html.php' );

    global $_TM_Extra_Product_Options;

    /**
     * Load admin interface
     */
    if ( is_admin() ) {
        function tm_add_Extra_Product_Options_settings($settings){            
            $_setting = include( untrailingslashit( plugin_dir_path(  __FILE__  ) ).'/admin/class-tm-epo-settings.php'  );
            if ( $_setting instanceof WC_Settings_Page ) {
                $settings[] = $_setting;
            }
            return $settings;
        }
        add_filter( 'woocommerce_get_settings_pages', 'tm_add_Extra_Product_Options_settings' );

        include_once ( 'admin/tm-epo-admin.php' );
        $_TM_Extra_Product_Options = new TM_EPO_Admin();

        include_once ( 'admin/tm-global-epo-admin.php' );
        $_TM_Extra_Product_Options = new TM_Global_EPO_Admin();
        
        include_once ( 'admin/class-tm-epo-builder.php' );
    }

    /**
     * Load main plugin interface
     */
    include_once ( 'class-tm-extra-product-options.php' );    
    $_TM_Extra_Product_Options = new TM_Extra_Product_Options();
}

?>