<?php
/**
 * The default template for displaying content. Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage Lastore
 * @since Lastore 1.0
 */
 
 global $post, $more;
 $more = 0;
?>
	
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php
        $custom = get_post_custom($post->ID);
		if(has_post_thumbnail($post->ID) ){
            $thumb = '<div class="postimg">'.get_the_post_thumbnail($post->ID, 'thumb-standard', array('alt' => '')).'</div>';
        }else{
            $thumb ="";
        }
        ?>
        
        
         <?php if(!is_search()){ ?>
            <?php echo $thumb;?>
         <?php } ?>
         <div class="header-wrapper">
         	<div class="entry-utility">
                <div class="date"><?php the_time('F d, Y'); ?></div>
                <div class="tag">/ <?php the_category(', '); ?></div>
                <div class="comment">/ <?php comments_popup_link(__('No Comments', 'templatesquare'), __('1 Comments', 'templatesquare'), __('% Comments', 'templatesquare')); ?></div>
            </div>
            <h2 class="posttitle"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'templatesquare' ), the_title_attribute( 'echo=0' ) ); ?>" data-rel="bookmark"><?php the_title(); ?></a></h2>
         </div>
         <div class="entry-text">
             <div class="entry-content">
             	<?php the_excerpt();?>
                <a href="<?php the_permalink(); ?>" class="more-link"><?php _e('Read More', 'templatesquare'); ?></a>
            </div>
         </div> 
    
		<div class="clear"></div>
	</article><!-- end post -->