<?php 
/**
 * Clean up gallery_shortcode()
 *
 * Re-create the [gallery] shortcode and use thumbnails styling from Bootstrap
 *
 * @link http://twitter.github.com/bootstrap/components.html#thumbnails
 */
function kadence_gallery($attr) {
  $post = get_post();
  static $instance = 0;
  $instance++;

  if (!empty($attr['ids'])) {
    if (empty($attr['orderby'])) {
      $attr['orderby'] = 'post__in';
    }
    $attr['include'] = $attr['ids'];
  }

  $output = apply_filters('post_gallery', '', $attr);

  if ($output != '') {
    return $output;
  }

  if (isset($attr['orderby'])) {
    $attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
    if (!$attr['orderby']) {
      unset($attr['orderby']);
    }
  }

  extract(shortcode_atts(array(
    'order'      => 'ASC',
    'orderby'    => 'menu_order ID',
    'id'         => $post->ID,
    'itemtag'    => '',
    'icontag'    => '',
    'captiontag' => '',
    'masonry'    => '',
    'speed'      => '',
    'height'     => '',
    'width'      => '',
    'caption'    => '',
    'type'       => '',
    'columns'    => 3,
    'size'       => 'full',
    'include'    => '',
    'exclude'    => ''
  ), $attr));

  $id = intval($id);

  if ($order === 'RAND') {
    $orderby = 'none';
  }

  $gallery_rn = (rand(10,100));

  if (!empty($include)) {
    $_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

    $attachments = array();
    foreach ($_attachments as $key => $val) {
      $attachments[$val->ID] = $_attachments[$key];
    }
  } elseif (!empty($exclude)) {
    $attachments = get_children(array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));
  } else {
    $attachments = get_children(array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));
  }

  if (empty($attachments)) {
    return '';
  }

  if (is_feed()) {
    $output = "\n";
    foreach ($attachments as $att_id => $attachment) {
      $output .= wp_get_attachment_link($att_id, $size, true) . "\n";
    }
    return $output;
  }
  if (isset($type) && $type == 'carousel') {
    // CAROUSEL
  if(empty($speed)) {$speed = '9000';}
  if(empty($scroll) || $scroll == 1) {$scroll = 'items:1,';} else {$scroll = '';}

ob_start(); ?>
        <div class="carousel_outerrim kad-animation" data-animation="fade-in" data-delay="0">
        <div class="home-margin fredcarousel">
        <div id="carouselcontainer-<?php echo $gallery_rn; ?>" class="rowtight fadein-carousel">
        <div id="carousel-<?php echo $gallery_rn; ?>" class="clearfix caroufedselgallery kad-light-wp-gallery">
            <?php if ($columns == '2') {$itemsize = 'tcol-lg-6 tcol-md-6 tcol-sm-6 tcol-xs-12 tcol-ss-12'; $imgsize = 560; $md = 2; $sm = 2; $xs = 1; $ss = 1;}
              else if ($columns == '1') {$itemsize = 'tcol-lg-12 tcol-md-12 tcol-sm-12 tcol-xs-12 tcol-ss-12'; $imgsize = 560; $md = 1; $sm = 1; $xs = 1; $ss = 1;} 
              else if ($columns == '3'){ $itemsize = 'tcol-lg-4 tcol-md-4 tcol-sm-4 tcol-xs-6 tcol-ss-12'; $imgsize = 400; $md = 3; $sm = 3; $xs = 2; $ss = 1;} 
              else if ($columns == '6'){ $itemsize = 'tcol-lg-2 tcol-md-2 tcol-sm-3 tcol-xs-4 tcol-ss-6'; $imgsize = 240; $md = 6; $sm = 4; $xs = 3; $ss = 2;}
              else if ($columns == '8' || $columns == '9' || $columns == '7'){ $itemsize = 'tcol-lg-2 tcol-md-2 tcol-sm-3 tcol-xs-4 tcol-ss-4'; $imgsize = 240; $md = 6; $sm = 4; $xs = 3; $ss = 3;}
              else if ($columns == '12' || $columns == '11'){ $itemsize = 'tcol-lg-1 tcol-md-1 tcol-sm-2 tcol-xs-2 tcol-ss-3'; $imgsize = 240; $md = 6; $sm = 4; $xs = 3; $ss = 2;} 
              else if ($columns == '5'){ $itemsize = 'tcol-lg-25 tcol-md-25 tcol-sm-3 tcol-xs-4 tcol-ss-6'; $imgsize = 240; $md = 5; $sm = 4; $xs = 3; $ss = 2;} 
              else {$itemsize = 'tcol-lg-3 tcol-md-3 tcol-sm-4 tcol-xs-4 tcol-ss-12'; $imgsize = 300; $md = 4; $sm = 3; $xs = 3; $ss = 1;}
              if(!empty($height)) {$imgheight = $height;} else {$imgheight = $imgsize;} ?>
                <?php  foreach ($attachments as $id => $attachment) {
                        $attachment_url = wp_get_attachment_url($id);
                          $image = aq_resize($attachment_url, $imgsize, $imgheight, true);
                          if(empty($image)) {$image = $attachment_url;}
                      
                      $link = isset($attr['link']) && 'post' == $attr['link'] ? wp_get_attachment_link($id, $size, true, false) : wp_get_attachment_link($id, $size, false, false);

                  echo '<div class="'.$itemsize.' gallery_item"><div class="carousel_item grid_item"><a href="'.$attachment_url.'" rel="lightbox[pp_gal]" class="lightboxhover">';
                  echo '<img src="'.$image.'" alt="'.esc_attr($attachment->post_excerpt).'" class=""/>';
                  
                            if (trim($attachment->post_excerpt) && $caption == true) {
                  echo '<div class="caption kad_caption"><div class="kad_caption_inner">' . wptexturize($attachment->post_excerpt) . '</div></div>';
                  echo '</a>';
              }
              echo '</div></div>';
                }?>
                </div>
              </div>
      <div class="clearfix"></div>
            <a id="prevport-<?php echo $gallery_rn; ?>" class="prev_carousel icon-arrow-left" href="#"></a>
      <a id="nextport-<?php echo $gallery_rn; ?>" class="next_carousel icon-arrow-right" href="#"></a>
      </div></div>
      <script type="text/javascript"> jQuery( window ).load(function () {var $wcontainer = jQuery('#carouselcontainer-<?php echo $gallery_rn; ?>'); var $container = jQuery('#carousel-<?php echo $gallery_rn; ?>');
          setWidths(); $container.carouFredSel({
              scroll: { <?php echo $scroll; ?> easing: "swing", duration: 700, pauseOnHover : true}, auto: {play: true, timeoutDuration: <?php echo $speed; ?>},
              prev: '#prevport-<?php echo $gallery_rn; ?>', next: '#nextport-<?php echo $gallery_rn; ?>', pagination: false, swipe: true, items: {visible: null}
            });
            jQuery(window).on("debouncedresize", function( event ) { setWidths();
              $container.trigger("updateSizes");
            });                       
          $wcontainer.animate({'opacity' : 1});
          function getUnitWidth() {var width;
          if(jQuery(window).width() <= 480) {
          width = $wcontainer.width() / <?php echo $ss;?>;
          } else if(jQuery(window).width() <= 768) {
          width = $wcontainer.width() / <?php echo $xs;?>;
          } else if(jQuery(window).width() <= 990) {
          width = $wcontainer.width() / <?php echo $sm;?>;
          } else {
          width = $wcontainer.width() / <?php echo $md;?>;
          }
          return width;
          }
          function setWidths() {
          var unitWidth = getUnitWidth() -1;
          $container.children().css({ width: unitWidth });
          } });
      </script>       

  <?php  $output = ob_get_contents();
    ob_end_clean();

  } elseif (isset($type) && $type == 'slider') {

          if (!empty($height)) $slideheight = $height; else $slideheight = 400; 
          if (!empty($width)) $slidewidth = $width; else $slidewidth = 1140;
           if(empty($speed)) {$speed = '7000';}

          ob_start(); ?>
                <div id="flexslider<?php echo $gallery_rn;?>" class="flexslider" style="max-width:<?php echo $slidewidth;?>px;">
                    <ul class="slides kad-light-wp-gallery">
                   <?php  foreach ($attachments as $id => $attachment) {
                          $attachment_url = wp_get_attachment_url($id);
                          $image = aq_resize($attachment_url, $slidewidth, $slideheight, true);
                          if(empty($image)) {$image = $attachment_url;}
                          $link = isset($attr['link']) && 'post' == $attr['link'] ? wp_get_attachment_link($id, $size, true, false) : wp_get_attachment_link($id, $size, false, false);
                            echo '<li><a href="'.$attachment_url.'" rel="lightbox[pp_gal]" class="lightboxhover">';
                              echo '<img src="'.$image.'" alt="'.esc_attr($attachment->post_excerpt).'" class=""/>';
                                  if (trim($attachment->post_excerpt) && $caption == true) {
                                      echo '<div class="caption flex-caption"><div><div class="captiontext headerfont"><p>' . wptexturize($attachment->post_excerpt) . '</p></div></div></div>';
                                    }
                              echo '</a>';
                            echo '</li>';
                     } ?>
                      </ul>
                  </div> <!--Flex Slides-->
                  <script type="text/javascript">
                    jQuery(window).load(function () {
                        jQuery('#flexslider<?php echo $gallery_rn;?>').flexslider({
                            animation: "fade",
                            animationSpeed: 400,
                            slideshow: true,
                            slideshowSpeed: <?php echo $speed;?>,

                            before: function(slider) {
                              slider.removeClass('loading');
                            }  
                          });
                        });
      </script>
  <?php  $output = ob_get_contents();
    ob_end_clean();

  } else {
    // NORMAL
  global $virtue_premium; if(isset($virtue_premium['virtue_animate_in']) && $virtue_premium['virtue_animate_in'] == 1) {$animate = 1;} else {$animate = 0;}
  $output .= '<div id="kad-wp-gallery'.$gallery_rn.'" class="kad-wp-gallery kad-light-wp-gallery clearfix rowtight" data-fade-in="'.$animate.'">';
    if ($columns == '2') {$itemsize = 'tcol-lg-6 tcol-md-6 tcol-sm-6 tcol-xs-12 tcol-ss-12'; $imgsize = 560; $md = 2; $sm = 2; $xs = 1; $ss = 1;} 
    else if ($columns == '1') {$itemsize = 'tcol-lg-12 tcol-md-12 tcol-sm-12 tcol-xs-12 tcol-ss-12'; $imgsize = 560; $md = 1; $sm = 1; $xs = 1; $ss = 1;} 
    else if ($columns == '3'){ $itemsize = 'tcol-lg-4 tcol-md-4 tcol-sm-4 tcol-xs-6 tcol-ss-12'; $imgsize = 366; $md = 3; $sm = 3; $xs = 2; $ss = 1;} 
    else if ($columns == '6'){ $itemsize = 'tcol-lg-2 tcol-md-2 tcol-sm-3 tcol-xs-4 tcol-ss-6'; $imgsize = 240; $md = 6; $sm = 4; $xs = 3; $ss = 2;}
    else if ($columns == '8' || $columns == '9' || $columns == '7'){ $itemsize = 'tcol-lg-2 tcol-md-2 tcol-sm-3 tcol-xs-4 tcol-ss-4'; $imgsize = 230; $md = 6; $sm = 4; $xs = 3; $ss = 3;}
    else if ($columns == '12' || $columns == '11'){ $itemsize = 'tcol-lg-1 tcol-md-1 tcol-sm-2 tcol-xs-2 tcol-ss-3'; $imgsize = 240; $md = 6; $sm = 4; $xs = 3; $ss = 2;} 
    else if ($columns == '5'){ $itemsize = 'tcol-lg-25 tcol-md-25 tcol-sm-3 tcol-xs-4 tcol-ss-6'; $imgsize = 240; $md = 5; $sm = 4; $xs = 3; $ss = 2;} 
    else {$itemsize = 'tcol-lg-3 tcol-md-3 tcol-sm-4 tcol-xs-6 tcol-ss-12'; $imgsize = 269; $md = 4; $sm = 3; $xs = 2; $ss = 1;}

  $i = 0;
  foreach ($attachments as $id => $attachment) {
    $attachment_url = wp_get_attachment_url($id);
    if(!empty($masonry)) {
      if($masonry == 'true'){
        $image = aq_resize($attachment_url, $imgsize, false);
      } else {
         $image = aq_resize($attachment_url, $imgsize, $imgsize, true);
      }

    } else {
          if(isset($virtue_premium['virtue_gallery_masonry']) && $virtue_premium['virtue_gallery_masonry'] ==  '1') {
          $image = aq_resize($attachment_url, $imgsize, false);
        } else {
          $image = aq_resize($attachment_url, $imgsize, $imgsize, true);
        }
    }
    if(empty($image)) {$image = $attachment_url;}
    $link = isset($attr['link']) && 'post' == $attr['link'] ? wp_get_attachment_link($id, $size, true, false) : wp_get_attachment_link($id, $size, false, false);

    $output .= '<div class="'.$itemsize.' g_item"><div class="grid_item kad_gallery_fade_in gallery_item"><a href="'.$attachment_url.'" rel="lightbox[pp_gal]" class="lightboxhover">
                          <img src="'.$image.'" alt="'.esc_attr($attachment->post_excerpt).'" class="light-dropshaddow"/>';
    if (trim($attachment->post_excerpt) && $caption == true) {
      $output .= '<div class="caption kad_caption"><div class="kad_caption_inner">' . wptexturize($attachment->post_excerpt) . '</div></div>';
    }
     $output .= '</a>';
    $output .= '</div></div>';
  }
  $output .= '</div>';
  $output .= '<script type="text/javascript">jQuery(document).ready(function ($) {var $container = $("#kad-wp-gallery'.$gallery_rn.'");$container.imagesLoadedn( function(){$container.isotopeb({masonry: {columnWidth: ".g_item"}, transitionDuration: "0.8s"}); if($container.attr("data-fade-in") == 1){$(".kad-wp-gallery .kad_gallery_fade_in").css("opacity",0);$(".kad-wp-gallery .kad_gallery_fade_in").each(function(i){$(this).delay(i*150).animate({"opacity":1},350);});}});});';
  $output .= '</script>';
  }
  
  return $output;
}
if(isset($virtue_premium['virtue_gallery']) && $virtue_premium['virtue_gallery'] == '1')  {
  remove_shortcode('gallery');
  add_shortcode('gallery', 'kadence_gallery');
} 