<?php 
// Virtue Shortcode Generator 

// Enqueue scripts

function kad_shortcode_button_scripts(){
	 wp_enqueue_media();
  	wp_enqueue_script('kadwidget_upload', get_template_directory_uri() . '/assets/js/widget_upload.js');
	wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_style('kad-shortcode-css', get_template_directory_uri() . '/lib/kad_shortcodes/css/kad-short-pop.css'); 
	wp_enqueue_script('kad_shortcode',get_template_directory_uri() . '/lib/kad_shortcodes/js/kad_shortcode_pop.js',array( 'jquery', 'wp-color-picker' ),'1.0.0 ', TRUE);
}

add_action('admin_enqueue_scripts','kad_shortcode_button_scripts');

add_action('admin_footer','kad_shortcode_content');

function virtue_shortcode_option( $name, $attr_option, $type, $shortcode ){
	
	$kad_option_element = null;
	
	(isset($attr_option['desc']) && !empty($attr_option['desc'])) ? $desc = '<p class="description">'.$attr_option['desc'].'</p>' : $desc = '';
	
		
	switch( $attr_option['type'] ){
		
		case 'radio':
	    
		$kad_option_element .= '<div class="label"><strong>'.$attr_option['title'].': </strong></div><div class="content">';
	    foreach( $attr_option['values'] as $val => $title ){
	    
		(isset($attr_option['def']) && !empty($attr_option['def'])) ? $def = $attr_option['def'] : $def = '';
		
		 $kad_option_element .= '
			<label for="shortcode-option-'.$shortcode.'-'.$name.'-'.$val.'">'.$title.'</label>
		    <input class="attr" type="radio" data-attrname="'.$name.'" name="'.$shortcode.'-'.$name.'" value="'.$val.'" id="shortcode-option-'.$shortcode.'-'.$name.'-'.$val.'"'. ( $val == $def ? ' checked="checked"':'').'>';
	    }
		
		$kad_option_element .= $desc . '</div>';
		
	    break;
	    case 'checkbox':
		
		$kad_option_element .= '<div class="label"><label for="' . $name . '"><strong>' . $attr_option['title'] . ': </strong></label></div>    <div class="content"> <input type="checkbox" class="' . $name . '" data-attrname="'.$name.'" id="' . $name . '" />'. $desc. '</div> ';
		
		break;
		case 'select':

		$kad_option_element .= '
		<div class="label"><label for="'.$name.'"><strong>'.$attr_option['title'].': </strong></label></div>
		
		<div class="content"><select id="'.$name.'" class="kad-sc-select">';
			$values = $attr_option['values'];
			foreach( $values as $value => $vname ){
				if($value == $attr_option['default']) { $selected=' selected="selected"';} else { $selected=""; }
		    	$kad_option_element .= '<option value="'.$value.'" ' . $selected .'>'.$vname.'</option>';
			}
		$kad_option_element .= '</select>' . $desc . '</div>';

		break;
		case 'icon-select':

		$kad_option_element .= '
		<div class="label"><label for="'.$name.'"><strong>'.$attr_option['title'].': </strong></label></div>
		
		<div class="content"><select id="'.$name.'" class="kad-icon-select">';
			$values = $attr_option['values'];
			foreach( $values as $value ){
		    	$kad_option_element .= '<option value="'.$value['name'].'">'.$value['name'].'</option>';
			}
		$kad_option_element .= '</select>' . $desc . '</div>';

		break;
		case 'color':
			
	           $kad_option_element .= '
	           <div class="label"><label><strong>'.$attr_option['title'].' </strong></label></div>
			   <div class="content"><input type="text" value="'. ( isset($attr_option['default']) ? $attr_option['default'] : "" ) . '" class="kad-popup-colorpicker" data-attrname="'.$name.'" style="width: 70px;" data-default-color="'. ( isset($attr_option['default']) ? $attr_option['default'] : "" ) . '"/>';
			   $kad_option_element .= $desc . '</div>';
		break;
		case 'textarea':
		$kad_option_element .= '
		<div class="label"><label for="shortcode-option-'.$name.'"><strong>'.$attr_option['title'].': </strong></label></div>
		<div class="content"><textarea class="kad-sc-'.$name.'" data-attrname="'.$name.'"></textarea> ' . $desc . '</div>';
		break;
		case 'text':
		default:
		    $kad_option_element .= '
			<div class="label"><label for="shortcode-option-'.$name.'"><strong>'.$attr_option['title'].': </strong></label></div>
			<div class="content"><input class="attr kad-sc-'.$name.'" type="text" data-attrname="'.$name.'" value="" />' . $desc . '</div>';
		break;
	}
	
	$kad_option_element .= '<div class="clear"></div>';
    
	
    return $kad_option_element;
}

function kad_shortcode_content(){

	//Columns
$virtue_shortcodes['columns'] = array( 
	'title'=>__('Columns', 'virtue'), 
	'attr'=>array(
		'columns'=>array(
			'type'=>'radio', 
			'title'=>__('Columns','virtue'),
			'values' => array(
				"span6" => '<img src="'. get_template_directory_uri().'/assets/img/twocolumn.jpg" />' . __("Two Columns", "virtue"),
				"span4right" => '<img src="'. get_template_directory_uri().'/assets/img/twocolumnright.jpg" />' . __("Two Columns offset Right", "virtue"),
				"span4left" => '<img src="'. get_template_directory_uri().'/assets/img/twocolumnleft.jpg" />' . __("Two Columns offset Left", "virtue"),
				"span4" => '<img src="'. get_template_directory_uri().'/assets/img/threecolumn.jpg" />' . __("Three Columns", "virtue"),
				"span3" => '<img src="'. get_template_directory_uri().'/assets/img/fourcolumn.jpg" />' . __("Four Columns", "virtue"),
				)
		),
	) 
);
	// Divider 
$virtue_shortcodes['hr'] = array( 
	'title'=>__('Divider', 'virtue'), 
	'attr'=>array(
		'style'=>array(
			'type'=>'select', 
			'title'=>__('Style', 'virtue'),
			'values' => array(
				"line" => __("Line", "virtue"),
				"dots" => __("Dots", "virtue"),
				"gradient" => __("Gradient", "virtue"),
				)
		),
		'size'=>array(
			'type'=>'select', 
			'title'=>__('Size','virtue'),
			'values' => array(
				"1px" => "1px",
				"2px" => "2px",
				"3px" => "3px",
				"4px" => "4px",
				"5px" => "5px",
				)
		),
		'color'=>array(
			'type'=>'color', 
			'title'  => __('Color','virtue'),
		)
	) 
);
// Spacer
$virtue_shortcodes['space'] = array( 
	'title'=>__('Spacing', 'virtue'), 
	'attr'=>array(
		'size'=>array(
			'type'=>'select', 
			'title'=>__('Size','virtue'),
			'values' => array(
				"10px" => "10px",
				"20px" => "20px",
				"30px" => "30px",
				"40px" => "40px",
				"50px" => "50px",
				)
		)
	) 
);
// Spacer
$virtue_shortcodes['tabs'] = array( 
	'title'=>__('Tabs', 'virtue'), 
);
$virtue_shortcodes['accordion'] = array( 
	'title'=>__('Accordion', 'virtue'),
);
$virtue_shortcodes['pullquote'] = array( 
	'title'=>__('Pull-Quotes', 'virtue'), 
	'attr'=>array(
		'align'=>array(
			'type'=>'select', 
			'title'=>__('Align', 'virtue'),
			'values' => array(
				"center" => __('Center','virtue'),
				"left" => __('Left','virtue'),
				"right" => __('Right','virtue'),
				)
		),
		'content'=>array(
			'type'=>'textarea', 
			'title'=>__('Pull-Quote Text', 'virtue')
		)
	) 
);
$virtue_shortcodes['blockquote'] = array( 
	'title'=>__('Block-Quotes', 'virtue'), 
	'attr'=>array(
		'align'=>array(
			'type'=>'select', 
			'title'=>__('Align', 'virtue'),
			'values' => array(
				"center" => __('Center','virtue'),
				"left" => __('Left','virtue'),
				"right" => __('Right','virtue'),
				)
		),
		'content'=>array(
			'type'=>'textarea', 
			'title'=>__('Block-Quote Text', 'virtue')
		)
	) 
);

$icons = array(
     array('name' => '', 'value' => ''), array('name' => 'icon-home'),array('name' => 'icon-home2'),array('name' => 'icon-office'),array('name' => 'icon-newspaper'),array('name' => 'icon-pencil'),array('name' => 'icon-pencil2'),array('name' => 'icon-pencil3'),array('name' => 'icon-pencil4'),array('name' => 'icon-quill'),array('name' => 'icon-quill2'),array('name' => 'icon-pen'),array('name' => 'icon-pen2'),array('name' => 'icon-home3'),array('name' => 'icon-marker'),array('name' => 'icon-brush'),array('name' => 'icon-palette'),array('name' => 'icon-palette2'),array('name' => 'icon-droplet'),array('name' => 'icon-droplet2'),array('name' => 'icon-paint-format'),array('name' => 'icon-images'),array('name' => 'icon-image'),array('name' => 'icon-image2'),array('name' => 'icon-images2'),array('name' => 'icon-camera'),array('name' => 'icon-camera2'),array('name' => 'icon-camera3'),array('name' => 'icon-camera4'),array('name' => 'icon-camera5'),array('name' => 'icon-music'),array('name' => 'icon-music2'),array('name' => 'icon-piano'),array('name' => 'icon-guitar'),array('name' => 'icon-headphones'),array('name' => 'icon-play'),array('name' => 'icon-movie'),array('name' => 'icon-film'),array('name' => 'icon-gamepad'),array('name' => 'icon-pacman'),array('name' => 'icon-bullhorn'),array('name' => 'icon-megaphone'),array('name' => 'icon-connection'),array('name' => 'icon-radio'),array('name' => 'icon-mic'),array('name' => 'icon-book'),array('name' => 'icon-books'),array('name' => 'icon-library'),array('name' => 'icon-file'),array('name' => 'icon-profile'),array('name' => 'icon-file2'),array('name' => 'icon-copy'),array('name' => 'icon-paste'),array('name' => 'icon-folder'),array('name' => 'icon-folder-open'),array('name' => 'icon-certificate'),array('name' => 'icon-cc'),array('name' => 'icon-tag'),array('name' => 'icon-tag2'),array('name' => 'icon-tags'),array('name' => 'icon-cart'),array('name' => 'icon-cart2'),array('name' => 'icon-cart3'),array('name' => 'icon-cart4'),array('name' => 'icon-basket'),array('name' => 'icon-basket2'),array('name' => 'icon-bag'),array('name' => 'icon-bag2'),array('name' => 'icon-bag3'),array('name' => 'icon-coin'),array('name' => 'icon-credit'),array('name' => 'icon-support'),array('name' => 'icon-phone'),array('name' => 'icon-address-book'),array('name' => 'icon-envelope'),array('name' => 'icon-mail-send'),array('name' => 'icon-envelope2'),array('name' => 'icon-pushpin'),array('name' => 'icon-location'),array('name' => 'icon-location2'),array('name' => 'icon-compass'),array('name' => 'icon-compass2'),array('name' => 'icon-map'),array('name' => 'icon-map2'),array('name' => 'icon-direction'),array('name' => 'icon-clock'),array('name' => 'icon-clock2'),array('name' => 'icon-watch'),array('name' => 'icon-alarm'),array('name' => 'icon-bell'),array('name' => 'icon-stopwatch'),array('name' => 'icon-calendar'),array('name' => 'icon-calendar2'),array('name' => 'icon-print'),array('name' => 'icon-mouse'),array('name' => 'icon-screen'),array('name' => 'icon-screen2'),array('name' => 'icon-laptop'),array('name' => 'icon-mobile'),array('name' => 'icon-mobile2'),array('name' => 'icon-tablet'),array('name' => 'icon-cabinet'),array('name' => 'icon-drawer'),array('name' => 'icon-drawer2'),array('name' => 'icon-box'),array('name' => 'icon-box-add'),array('name' => 'icon-box-remove'),array('name' => 'icon-cd'),array('name' => 'icon-storage'),array('name' => 'icon-undo'),array('name' => 'icon-redo'),array('name' => 'icon-rotate'),array('name' => 'icon-rotate2'),array('name' => 'icon-undo2'),array('name' => 'icon-redo2'),array('name' => 'icon-forward'),array('name' => 'icon-reply'),array('name' => 'icon-bubble'),array('name' => 'icon-bubbles'),array('name' => 'icon-bubbles2'),array('name' => 'icon-bubbles3'),array('name' => 'icon-user'),array('name' => 'icon-users'),array('name' => 'icon-users2'),array('name' => 'icon-users3'),array('name' => 'icon-vcard'),array('name' => 'icon-tshirt'),array('name' => 'icon-bubble-notification'),array('name' => 'icon-bubble2'),array('name' => 'icon-bubble3'),array('name' => 'icon-quotes-left'),array('name' => 'icon-quotes-right'),array('name' => 'icon-busy'),array('name' => 'icon-spinner'),array('name' => 'icon-spinner2'),array('name' => 'icon-search'),array('name' => 'icon-search2'),array('name' => 'icon-zoom-in'),array('name' => 'icon-zoom-out'),array('name' => 'icon-expand'),array('name' => 'icon-contract'),array('name' => 'icon-key'),array('name' => 'icon-key2'),array('name' => 'icon-keyhole'),array('name' => 'icon-lock'),array('name' => 'icon-wrench'),array('name' => 'icon-settings'),array('name' => 'icon-equalizer'),array('name' => 'icon-equalizer2'),array('name' => 'icon-equalizer3'),array('name' => 'icon-cog'),array('name' => 'icon-cogs'),array('name' => 'icon-tools'),array('name' => 'icon-screwdriver'),array('name' => 'icon-wand'),array('name' => 'icon-aid'),array('name' => 'icon-bug'),array('name' => 'icon-inject'),array('name' => 'icon-construction'),array('name' => 'icon-pie'),array('name' => 'icon-stats'),array('name' => 'icon-stats2'),array('name' => 'icon-stats3'),array('name' => 'icon-bars'),array('name' => 'icon-bars2'),array('name' => 'icon-bars3'),array('name' => 'icon-gift'),array('name' => 'icon-balloon'),array('name' => 'icon-stats-up'),array('name' => 'icon-gift2'),array('name' => 'icon-medal'),array('name' => 'icon-crown'),array('name' => 'icon-trophy'),array('name' => 'icon-glass'),array('name' => 'icon-glass2'),array('name' => 'icon-bottle'),array('name' => 'icon-food'),array('name' => 'icon-food2'),array('name' => 'icon-cup'),array('name' => 'icon-leaf'),array('name' => 'icon-leaf2'),array('name' => 'icon-apple-fruit'),array('name' => 'icon-tree'),array('name' => 'icon-paw'),array('name' => 'icon-steps'),array('name' => 'icon-flower'),array('name' => 'icon-rocket'),array('name' => 'icon-meter'),array('name' => 'icon-meter-fast'),array('name' => 'icon-mug'),array('name' => 'icon-dashboard'),array('name' => 'icon-hammer'),array('name' => 'icon-fire'),array('name' => 'icon-bomb'),array('name' => 'icon-lab'),array('name' => 'icon-atom'),array('name' => 'icon-magnet'),array('name' => 'icon-dumbbell'),array('name' => 'icon-lamp'),array('name' => 'icon-lamp2'),array('name' => 'icon-lamp3'),array('name' => 'icon-lamp4'),array('name' => 'icon-remove'),array('name' => 'icon-remove2'),array('name' => 'icon-remove3'),array('name' => 'icon-briefcase'),array('name' => 'icon-briefcase2'),array('name' => 'icon-briefcase3'),array('name' => 'icon-airplane'),array('name' => 'icon-airplane2'),array('name' => 'icon-paper-plane'),array('name' => 'icon-car'),array('name' => 'icon-gas-pump'),array('name' => 'icon-bus'),array('name' => 'icon-truck'),array('name' => 'icon-bike'),array('name' => 'icon-train'),array('name' => 'icon-boat'),array('name' => 'icon-cube'),array('name' => 'icon-cube4'),array('name' => 'icon-cylinder'),array('name' => 'icon-puzzle'),array('name' => 'icon-puzzle2'),array('name' => 'icon-glasses'),array('name' => 'icon-glasses2'),array('name' => 'icon-sun-glasses'),array('name' => 'icon-accessibility'),array('name' => 'icon-accessibility2'),array('name' => 'icon-brain'),array('name' => 'icon-target'),array('name' => 'icon-shield'),array('name' => 'icon-shield2'),array('name' => 'icon-soccer'),array('name' => 'icon-football'),array('name' => 'icon-baseball'),array('name' => 'icon-basketball'),array('name' => 'icon-golf'),array('name' => 'icon-hockey'),array('name' => 'icon-racing'),array('name' => 'icon-eight-ball'),array('name' => 'icon-bowling-ball'),array('name' => 'icon-bowling'),array('name' => 'icon-lightning'),array('name' => 'icon-power'),array('name' => 'icon-switch'),array('name' => 'icon-power-cord'),array('name' => 'icon-clipboard'),array('name' => 'icon-signup'),array('name' => 'icon-clipboard2'),array('name' => 'icon-clipboard3'),array('name' => 'icon-grid'),array('name' => 'icon-grid2'),array('name' => 'icon-grid3'),array('name' => 'icon-grid4'),array('name' => 'icon-grid5'),array('name' => 'icon-menu'),array('name' => 'icon-menu2'),array('name' => 'icon-menu3'),array('name' => 'icon-menu4'),array('name' => 'icon-menu5'),array('name' => 'icon-menu6'),array('name' => 'icon-cloud'),array('name' => 'icon-download'),array('name' => 'icon-upload'),array('name' => 'icon-globe'),array('name' => 'icon-earth'),array('name' => 'icon-network'),array('name' => 'icon-link'),array('name' => 'icon-link2'),array('name' => 'icon-link3'),array('name' => 'icon-cloud-download'),array('name' => 'icon-cloud-upload'),array('name' => 'icon-link4'),array('name' => 'icon-anchor'),array('name' => 'icon-flag'),array('name' => 'icon-flag2'),array('name' => 'icon-flag3'),array('name' => 'icon-attachment'),array('name' => 'icon-attachment2'),array('name' => 'icon-eye'),array('name' => 'icon-bookmark'),array('name' => 'icon-bookmarks'),array('name' => 'icon-spotlight'),array('name' => 'icon-temperature'),array('name' => 'icon-weather-lightning'),array('name' => 'icon-weather-rain'),array('name' => 'icon-weather-snow'),array('name' => 'icon-windy'),array('name' => 'icon-snowflake'),array('name' => 'icon-sun'),array('name' => 'icon-eye-blocked'),array('name' => 'icon-moon'),array('name' => 'icon-bed'),array('name' => 'icon-star'),array('name' => 'icon-star2'),array('name' => 'icon-star3'),array('name' => 'icon-heart'),array('name' => 'icon-heart2'),array('name' => 'icon-heart-broken'),array('name' => 'icon-thumbs-up'),array('name' => 'icon-thumbs-down'),array('name' => 'icon-man'),array('name' => 'icon-woman'),array('name' => 'icon-people'),array('name' => 'icon-happy'),array('name' => 'icon-happy2'),array('name' => 'icon-smiley'),array('name' => 'icon-smiley2'),array('name' => 'icon-tongue'),array('name' => 'icon-tongue2'),array('name' => 'icon-sad'),array('name' => 'icon-sad2'),array('name' => 'icon-wink'),array('name' => 'icon-wink2'),array('name' => 'icon-grin'),array('name' => 'icon-grin2'),array('name' => 'icon-cool'),array('name' => 'icon-cool2'),array('name' => 'icon-shocked'),array('name' => 'icon-shocked2'),array('name' => 'icon-neutral'),array('name' => 'icon-neutral2'),array('name' => 'icon-hand'),array('name' => 'icon-stack-picture'),array('name' => 'icon-stack-list'),array('name' => 'icon-stack-clubs'),array('name' => 'icon-stack-spades'),array('name' => 'icon-stack-hearts'),array('name' => 'icon-stack-diamonds'),array('name' => 'icon-stack-user'),array('name' => 'icon-stack-music'),array('name' => 'icon-angry'),array('name' => 'icon-angry2'),array('name' => 'icon-evil'),array('name' => 'icon-evil2'),array('name' => 'icon-confused'),array('name' => 'icon-confused2'),array('name' => 'icon-wondering'),array('name' => 'icon-wondering2'),array('name' => 'icon-cursor'),array('name' => 'icon-move'),array('name' => 'icon-warning'),array('name' => 'icon-warning2'),array('name' => 'icon-notification'),array('name' => 'icon-notification2'),array('name' => 'icon-question'),array('name' => 'icon-question2'),array('name' => 'icon-question3'),array('name' => 'icon-plus-circle'),array('name' => 'icon-plus-circle2'),array('name' => 'icon-minus-circle'),array('name' => 'icon-minus-circle2'),array('name' => 'icon-info'),array('name' => 'icon-info2'),array('name' => 'icon-cancel-circle'),array('name' => 'icon-cancel-circle2'),array('name' => 'icon-checkmark-circle'),array('name' => 'icon-checkmark-circle2'),array('name' => 'icon-close'),array('name' => 'icon-close2'),array('name' => 'icon-checkmark'),array('name' => 'icon-checkmark2'),array('name' => 'icon-checkmark3'),array('name' => 'icon-checkmark4'),array('name' => 'icon-minus'),array('name' => 'icon-plus'),array('name' => 'icon-bed2'),array('name' => 'icon-fan'),array('name' => 'icon-umbrella'),array('name' => 'icon-play2'),array('name' => 'icon-pause'),array('name' => 'icon-stop'),array('name' => 'icon-backward'),array('name' => 'icon-forward2'),array('name' => 'icon-play3'),array('name' => 'icon-pause2'),array('name' => 'icon-stop2'),array('name' => 'icon-backward2'),array('name' => 'icon-forward3'),array('name' => 'icon-first'),array('name' => 'icon-last'),array('name' => 'icon-previous'),array('name' => 'icon-next'),array('name' => 'icon-eject'),array('name' => 'icon-volume-high'),array('name' => 'icon-volume-medium'),array('name' => 'icon-volume-low'),array('name' => 'icon-volume-mute'),array('name' => 'icon-arrow-up'),array('name' => 'icon-arrow-right'),array('name' => 'icon-arrow-down'),array('name' => 'icon-arrow-left'),array('name' => 'icon-arrow-up2'),array('name' => 'icon-arrow-right2'),array('name' => 'icon-arrow-down2'),array('name' => 'icon-arrow-left2'),array('name' => 'icon-arrow-up-left'),array('name' => 'icon-arrow-up3'),array('name' => 'icon-arrow-up-right'),array('name' => 'icon-arrow-right3'),array('name' => 'icon-arrow-down-right'),array('name' => 'icon-arrow-down3'),array('name' => 'icon-arrow-down-left'),array('name' => 'icon-arrow-left3'),array('name' => 'icon-arrow-up4'),array('name' => 'icon-arrow-right4'),array('name' => 'icon-arrow-down4'),array('name' => 'icon-arrow-left4'),array('name' => 'icon-arrow-up5'),array('name' => 'icon-arrow-right5'),array('name' => 'icon-arrow-bottom'),array('name' => 'icon-arrow-left5'),array('name' => 'icon-arrow-up6'),array('name' => 'icon-arrow-right6'),array('name' => 'icon-arrow-down5'),array('name' => 'icon-arrow-left6'),array('name' => 'icon-transmission'),array('name' => 'icon-sort'),array('name' => 'icon-loop'),array('name' => 'icon-loop2'),array('name' => 'icon-checkbox-checked'),array('name' => 'icon-checkbox'),array('name' => 'icon-checkbox-checked2'),array('name' => 'icon-crop'),array('name' => 'icon-vector'),array('name' => 'icon-rulers'),array('name' => 'icon-scissors'),array('name' => 'icon-filter'),array('name' => 'icon-font'),array('name' => 'icon-font-size'),array('name' => 'icon-text-height'),array('name' => 'icon-text-width'),array('name' => 'icon-height'),array('name' => 'icon-width'),array('name' => 'icon-page-break'),array('name' => 'icon-page-break2'),array('name' => 'icon-new-tab'),array('name' => 'icon-new-tab2'),array('name' => 'icon-embed'),array('name' => 'icon-code'),array('name' => 'icon-mail'),array('name' => 'icon-mail2'),array('name' => 'icon-mail3'),array('name' => 'icon-table'),array('name' => 'icon-google-plus'),array('name' => 'icon-google-plus2'),array('name' => 'icon-google-plus3'),array('name' => 'icon-facebook'),array('name' => 'icon-facebook2'),array('name' => 'icon-facebook3'),array('name' => 'icon-instagram'),array('name' => 'icon-twitter'),array('name' => 'icon-twitter2'),array('name' => 'icon-feed'),array('name' => 'icon-feed2'),array('name' => 'icon-youtube'),array('name' => 'icon-youtube2'),array('name' => 'icon-vimeo'),array('name' => 'icon-vimeo2'),array('name' => 'icon-lanyrd'),array('name' => 'icon-flickr'),array('name' => 'icon-flickr2'),array('name' => 'icon-picassa'),array('name' => 'icon-picassa2'),array('name' => 'icon-dribbble'),array('name' => 'icon-dribbble2'),array('name' => 'icon-forrst'),array('name' => 'icon-forrst2'),array('name' => 'icon-deviantart'),array('name' => 'icon-deviantart2'),array('name' => 'icon-github'),array('name' => 'icon-github2'),array('name' => 'icon-github3'),array('name' => 'icon-wordpress'),array('name' => 'icon-blogger'),array('name' => 'icon-blogger2'),array('name' => 'icon-tumblr'),array('name' => 'icon-tumblr2'),array('name' => 'icon-apple'),array('name' => 'icon-android'),array('name' => 'icon-windows'),array('name' => 'icon-windows8'),array('name' => 'icon-skype'),array('name' => 'icon-linkedin'),array('name' => 'icon-lastfm'),array('name' => 'icon-lastfm2'),array('name' => 'icon-stumbleupon'),array('name' => 'icon-stumbleupon2'),array('name' => 'icon-pinterest'),array('name' => 'icon-pinterest2'),array('name' => 'icon-xing'),array('name' => 'icon-paypal'),array('name' => 'icon-html5'),array('name' => 'icon-css3'),array('name' => 'icon-file-zip'),array('name' => 'icon-file-xml'),array('name' => 'icon-file-pdf'),array('name' => 'icon-file-word'),array('name' => 'icon-file-excel'),array('name' => 'icon-king'),array('name' => 'icon-queen'),array('name' => 'icon-rock'),array('name' => 'icon-knight'),array('name' => 'icon-github4'),array('name' => 'icon-steam'),array('name' => 'icon-steam2'),array('name' => 'icon-yahoo'),array('name' => 'icon-flickr3'),array('name' => 'icon-google-drive'),array('name' => 'icon-chrome'),array('name' => 'icon-firefox'),array('name' => 'icon-IE'),array('name' => 'icon-opera'),array('name' => 'icon-safari'),array('name' => 'icon-IcoMoon'),array('name' => 'icon-html52'),array('name' => 'icon-vk'),array('name' => 'icon-viadeo'));

	//Button
$virtue_shortcodes['btn'] = array( 
	'title'=>__('Button', 'virtue'), 
	'attr'=>array(
		'text'=>array(
			'type'=>'text', 
			'title'=>__('Button Text', 'virtue')
		),
		'target'=>array(
			'type'=>'checkbox', 
			'title'=>__('Open Link In New Tab?','virtue')
		),
		'tcolor'=>array(
			'type'=>'color', 
			'title'  => __('Font Color','virtue'),
			'default' => '#ffffff',
		),
		'bcolor'=>array(
			'type'=>'color', 
			'title'  => __('Button Color','virtue'),
			'default' => '',
		),
		'link'=>array(
			'type'=>'text', 
			'title'=>__('Link URL', 'virtue')
		),
		'size'=>array(
			'type'=>'select', 
			'title'=>__('Button Size', 'virtue'),
			'values' => array(
				"" => __('Default', 'virtue'),
				"large" => __('Large', 'virtue'),
				"small" => __('Small', 'virtue'),
				)
		),
		'font'=>array(
			'type'=>'select', 
			'title'=>__('Font Family', 'virtue'),
			'values' => array(
				"" => __('Default', 'virtue'),
				"h1-family" => __('H1 Family', 'virtue'),
				)
		),
		'icon'=>array(
			'type'=>'icon-select', 
			'title'=>__('Choose an Icon (optional)', 'virtue'),
			'values' => $icons
		),
	) 
);
$virtue_shortcodes['gmap'] = array( 
	'title'=>__('Google Map', 'virtue'), 
	'attr'=>array(
		'address'=>array(
			'type'=>'text', 
			'title'=>__('Address One', 'virtue')
		),
		'title'=>array(
			'type'=>'text', 
			'title'=>__('Address Title One','virtue'),
			'desc'=>__('Displays in Popup e.g. = Business Name', 'virtue')
		),
		'height'=>array(
			'type'=>'text', 
			'title'=>__('Map Height', 'virtue'),
			'desc'=>__('Just a number e.g. = 400', 'virtue'), 
		),
		'zoom'=>array(
			'type'=>'select', 
			'title'=>__('Map Zoom','virtue'),
			'default' => '15',
			'values' => array(
				"1" => "1",
				"2" => "2",
				"3" => "3",
				"4" => "4",
				"5" => "5",
				"6" => "6",
				"7" => "7",
				"8" => "8",
				"9" => "9",
				"10" => "10",
				"11" => "11",
				"12" => "12",
				"13" => "13",
				"14" => "14",
				"15" => "15",
				"16" => "16",
				"17" => "17",
				"18" => "18",
				"19" => "19",
				"20" => "20",
				)
		),
		'maptype'=>array(
			'type'=>'select', 
			'title'=>__('Map Type','virtue'),
			'default' => 'ROADMAP',
			'values' => array(
				"ROADMAP" => __('ROADMAP', 'virtue'),
				"HYBRID" => __('HYBRID', 'virtue'),
				"TERRAIN" => __('TERRAIN', 'virtue'),
				"SATELLITE" => __('SATELLITE', 'virtue'),
				)
		),
		'address2'=>array(
			'type'=>'text', 
			'title'=>__('Address Two', 'virtue')
		),
		'title2'=>array(
			'type'=>'text', 
			'title'=>__('Address Title Two','virtue'),
			'desc'=>__('Displays in Popup e.g. = Business Name', 'virtue')
		),
		'address3'=>array(
			'type'=>'text', 
			'title'=>__('Address Three', 'virtue')
		),
		'title3'=>array(
			'type'=>'text', 
			'title'=>__('Address Title Three','virtue'),
			'desc'=>__('Displays in Popup e.g. = Business Name', 'virtue')
		),
		'address4'=>array(
			'type'=>'text', 
			'title'=>__('Address Four', 'virtue')
		),
		'title4'=>array(
			'type'=>'text', 
			'title'=>__('Address Title Four','virtue'),
			'desc'=>__('Displays in Popup e.g. = Business Name', 'virtue')
		),
		'center'=>array(
			'type'=>'text', 
			'title'=>__('Map Center','virtue'),
			'desc'=>__('Defaults to Address One', 'virtue')
		)
	) 
);

$virtue_shortcodes['icon'] = array( 
	'title'=>__('Icon', 'virtue'), 
	'attr'=>array(
		'icon'=>array(
			'type'=>'icon-select', 
			'title'=>__('Choose an Icon', 'virtue'),
			'values' => $icons
		),
		'size'=>array(
			'type'=>'select', 
			'title'=>__('Icon Size','virtue'),
			'default' => '14px',
			'values' => array(
				"5px" => "5px",
				"6px" => "6px",
				"7px" => "7px",
				"8px" => "8px",
				"9px" => "9px",
				"10px" => "10px",
				"11px" => "11px",
				"12px" => "12px",
				"13px" => "13px",
				"14px" => "14px",
				"15px" => "15px",
				"16px" => "16px",
				"17px" => "17px",
				"18px" => "18px",
				"19px" => "19px",
				"20px" => "20px",
				"21px" => "21px",
				"22px" => "22px",
				"23px" => "23px",
				"24px" => "24px",
				"25px" => "25px",
				"26px" => "26px",
				"27px" => "27px",
				"28px" => "28px",
				"29px" => "29px",
				"30px" => "30px",
				"31px" => "31px",
				"32px" => "32px",
				"33px" => "33px",
				"34px" => "34px",
				"35px" => "35px",
				"36px" => "36px",
				"37px" => "37px",
				"38px" => "38px",
				"39px" => "39px",
				"40px" => "40px",
				"41px" => "41px",
				"42px" => "42px",
				"43px" => "43px",
				"44px" => "44px",
				"45px" => "45px",
				"46px" => "46px",
				"47px" => "47px",
				"48px" => "48px",
				"49px" => "49px",
				"50px" => "50px",
				"51px" => "51px",
				"52px" => "52px",
				"53px" => "53px",
				"54px" => "54px",
				"55px" => "55px",
				"56px" => "56px",
				"57px" => "57px",
				"58px" => "58px",
				"59px" => "59px",
				"60px" => "60px",
				"61px" => "61px",
				"62px" => "62px",
				"63px" => "63px",
				"64px" => "64px",
				"65px" => "65px",
				"66px" => "66px",
				"67px" => "67px",
				"68px" => "68px",
				"69px" => "69px",
				"70px" => "70px",
				"71px" => "71px",
				"72px" => "72px",
				"73px" => "73px",
				"74px" => "74px",
				"75px" => "75px",
				"76px" => "76px",
				"77px" => "77px",
				"78px" => "78px",
				"79px" => "79px",
				"80px" => "80px",
			)
		),
		'color'=>array(
			'type'=>'color', 
			'title'  => __('Icon Color','virtue'),
			'default' => '',
		),
		'float'=>array(
			'type'=>'select', 
			'title'=>__('Icon Float', 'virtue'),
			'values' => array(
				"" => "none",
				"left" => "Left",
				"right" => "Right",
				)
		),
		'style'=>array(
			'type'=>'select', 
			'title'=>__('Icon Style', 'virtue'),
			'values' => array(
				"" => "none",
				"circle" => __('Circle', 'virtue'),
				"smcircle" => __('Small Circle', 'virtue'),
				"square" => __('Square', 'virtue'),
				"smsquare" => __('Small Square', 'virtue'),
				)
		),
		'background'=>array(
			'type'=>'color', 
			'title'  => __('Background Color','virtue'),
			'default' => '',
		)
	) 
);
$virtue_shortcodes['iconbox'] = array( 
	'title'=>__('Icon Box', 'virtue'), 
	'attr'=>array(
		'icon'=>array(
			'type'=>'icon-select', 
			'title'=>__('Choose an Icon', 'virtue'),
			'values' => $icons
		),
		'iconsize'=>array(
			'type'=>'select', 
			'title'=>__('Icon Size','virtue'),
			'default' => '48px',
			'values' => array(
				"5px" => "5px",
				"6px" => "6px",
				"7px" => "7px",
				"8px" => "8px",
				"9px" => "9px",
				"10px" => "10px",
				"11px" => "11px",
				"12px" => "12px",
				"13px" => "13px",
				"14px" => "14px",
				"15px" => "15px",
				"16px" => "16px",
				"17px" => "17px",
				"18px" => "18px",
				"19px" => "19px",
				"20px" => "20px",
				"21px" => "21px",
				"22px" => "22px",
				"23px" => "23px",
				"24px" => "24px",
				"25px" => "25px",
				"26px" => "26px",
				"27px" => "27px",
				"28px" => "28px",
				"29px" => "29px",
				"30px" => "30px",
				"31px" => "31px",
				"32px" => "32px",
				"33px" => "33px",
				"34px" => "34px",
				"35px" => "35px",
				"36px" => "36px",
				"37px" => "37px",
				"38px" => "38px",
				"39px" => "39px",
				"40px" => "40px",
				"41px" => "41px",
				"42px" => "42px",
				"43px" => "43px",
				"44px" => "44px",
				"45px" => "45px",
				"46px" => "46px",
				"47px" => "47px",
				"48px" => "48px",
				"49px" => "49px",
				"50px" => "50px",
				"51px" => "51px",
				"52px" => "52px",
				"53px" => "53px",
				"54px" => "54px",
				"55px" => "55px",
				"56px" => "56px",
				"57px" => "57px",
				"58px" => "58px",
				"59px" => "59px",
				"60px" => "60px",
				"61px" => "61px",
				"62px" => "62px",
				"63px" => "63px",
				"64px" => "64px",
				"65px" => "65px",
				"66px" => "66px",
				"67px" => "67px",
				"68px" => "68px",
				"69px" => "69px",
				"70px" => "70px",
				"71px" => "71px",
				"72px" => "72px",
				"73px" => "73px",
				"74px" => "74px",
				"75px" => "75px",
				"76px" => "76px",
				"77px" => "77px",
				"78px" => "78px",
				"79px" => "79px",
				"80px" => "80px",
			)
		),
		'color'=>array(
			'type'=>'color', 
			'title'  => __('Icon/Font Color','virtue'),
			'default' => '#ffffff',
		),
		'background'=>array(
			'type'=>'color', 
			'title'  => __('Background Color','virtue'),
			'default' => '#dddddd',
		),
		'hcolor'=>array(
			'type'=>'color', 
			'title'  => __('Hover Icon/Font Color','virtue'),
			'default' => '#ffffff',
		),
		'hbackground'=>array(
			'type'=>'color', 
			'title'  => __('Hover Background Color','virtue'),
			'default' => '',
		),
		'link'=>array(
			'type'=>'text', 
			'title'=>__('Link URL', 'virtue')
		),
		'title'=>array(
			'type'=>'text', 
			'title'=>__('Title', 'virtue')
		),
		'description'=>array(
			'type'=>'textarea', 
			'title'=>__('Description', 'virtue')
		)

	) 
);
$virtue_shortcodes['kad_youtube'] = array( 
	'title'=>__('YouTube', 'virtue'), 
	'attr'=>array(
		'url'=>array(
			'type'=>'text', 
			'title'=>__('Video URL', 'virtue')
		),
		'width'=>array(
			'type'=>'text', 
			'title'=>__('Video Width', 'virtue'),
			'desc' =>__('Just a number e.g. = 600', 'virtue'), 
		),
		'height'=>array(
			'type'=>'text', 
			'title'=>__('Video Height', 'virtue'),
			'desc'=>__('Just a number e.g. = 400', 'virtue'), 
		),
		'maxwidth'=>array(
			'type'=>'text', 
			'title'=>__('Video Max Width', 'virtue'),
			'desc'=>__('Keeps the responsive video from getting too large', 'virtue'), 
		),
		'hidecontrols'=>array(
			'type'=>'checkbox', 
			'title'=>__('Hide Controls','virtue')
		),
		'autoplay'=>array(
			'type'=>'checkbox', 
			'title'=>__('Auto Play','virtue')
		),
		'modestbranding'=>array(
			'type'=>'checkbox', 
			'title'=>__('Modest Branding?','virtue')
		)
	) 
);
$virtue_shortcodes['kad_vimeo'] = array( 
	'title'=>__('Vimeo', 'virtue'), 
	'attr'=>array(
		'url'=>array(
			'type'=>'text', 
			'title'=>__('Video URL', 'virtue')
		),
		'width'=>array(
			'type'=>'text', 
			'title'=>__('Video Width', 'virtue'),
			'desc' =>__('Just a number e.g. = 600', 'virtue'), 
		),
		'height'=>array(
			'type'=>'text', 
			'title'=>__('Video Height', 'virtue'),
			'desc'=>__('Just a number e.g. = 400', 'virtue'), 
		),
		'maxwidth'=>array(
			'type'=>'text', 
			'title'=>__('Video Max Width', 'virtue'),
			'desc'=>__('Keeps the responsive video from getting too large', 'virtue'), 
		),
		'autoplay'=>array(
			'type'=>'checkbox', 
			'title'=>__('Auto Play','virtue')
		)
	) 
);
$postcategories = get_categories();
$cat_options = array();
$cat_options = array("" => "All");
foreach ($postcategories as $cat) {
      $cat_options[$cat->slug] = $cat->name;
}

$virtue_shortcodes['blog_posts'] = array( 
	'title'=>__('Blog Posts', 'virtue'), 
	'attr'=>array(
		'orderby'=>array(
			'type'=>'select', 
			'title'=>__('Order By', 'virtue'),
			'values' => array(
				"date" => __('Date','virtue'),
				"rand" => __('Random','virtue'),
				"menu_order" => __('Menu Order','virtue'),
				)
		),
		'cat'=>array(
			'type'=>'select', 
			'title'=>__('Category', 'virtue'),
			'values' => $cat_options,
		),
		'items'=>array(
			'type'=>'text', 
			'title'=>__('Number of Posts', 'virtue')
		),
	) 
);
	//Button
$virtue_shortcodes['kad_modal'] = array( 
	'title'=>__('Modal', 'virtue'), 
	'attr'=>array(
		'btntitle'=>array(
			'type'=>'text', 
			'title'=>__('Button Title', 'virtue')
		),
		'btncolor'=>array(
			'type'=>'color', 
			'title'  => __('Button Font Color','virtue'),
			'default' => '#ffffff',
		),
		'btnbackground'=>array(
			'type'=>'color', 
			'title'  => __('Button Background Color','virtue'),
			'default' => '',
		),
		'btnsize'=>array(
			'type'=>'select', 
			'title'=>__('Button Size', 'virtue'),
			'values' => array(
				"" => __('Default', 'virtue'),
				"large" => __('Large', 'virtue'),
				"small" => __('Small', 'virtue'),
				)
		),
		'btnfont'=>array(
			'type'=>'select', 
			'title'=>__('Font Family', 'virtue'),
			'values' => array(
				"" => __('Default', 'virtue'),
				"h1-family" => __('H1 Family', 'virtue'),
				)
		),
		'title'=>array(
			'type'=>'text', 
			'title'=>__('Modal Title', 'virtue')
		),
		'content'=>array(
			'type'=>'textarea', 
			'title'=>__('Modal Content', 'virtue')
		)
	) 
);

	ob_start(); ?>
	<div id="kadence-shortcode-container">
		<div id="kadence-shortcode-innercontainer" class="mfp-hide mfp-with-anim">
		 	<div class="kadenceshortcode-content">
		 		<div class="shortcodes-header">
					<div class="kadshort-header"><h3><?php echo __('Virtue Shortcodes', 'virtue'); ?></h3></div>
					<div class="kadshort-select"><select id="kadence-shortcodes" data-placeholder="<?php _e("Choose a shortcode", 'virtue'); ?>">
				    <option></option>
					
					<?php foreach( $virtue_shortcodes as $shortcode => $options ){
						
							$kad_sc_html .= '<option value="'.$shortcode.'">'.$options['title'].'</option>';
							$kad_options_html .= '<div class="shortcode-options" id="options-'.$shortcode.'" data-name="'.$shortcode.'" data-type="'.$options['type'].'">';
							
								if( !empty($options['attr']) ){
									 foreach( $options['attr'] as $name => $attr_option ){
										$kad_options_html .= virtue_shortcode_option( $name, $attr_option, $options['type'], $shortcode );
									 }
								}
			
							$kad_options_html .= '</div>'; 
						
					} 
			
			$kad_sc_html .= '</select></div></div>'; 	
		
	
		 echo $kad_sc_html . $kad_options_html; ?>

 				
			<div class="kad_shortcode_insert">	
				<a href="javascript:void(0);" id="kad-shortcode-insert" class="kad-addshortcode-btn" style=""><?php _e("Add Shortcode", "virtue"); ?></a>
			</div>
	</div> 
	</div>
	</div>
<?php  $output = ob_get_contents();
		ob_end_clean();
	echo $output;
}