<?php 
/*
 * Virtue Premium Widgets 
 */

class kad_gallery_widget extends WP_Widget{

function kad_gallery_widget() {
        $widget_ops = array('classname' => 'virtue_gallery_widget', 'description' => __('Adds a gallery to any widget area.', 'virtue'));
        $this->WP_Widget('virtue_gallery_widget', __('Virtue: Gallery', 'virtue'), $widget_ops);
        $this->alt_option_name = 'virtue_gallery_widget';
    }
     public function widget($args, $instance){ 
        extract( $args ); 
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
        if(!empty($instance["ids"])) {$g_ids = $instance["ids"];} else {$g_ids = '';}
        if(!empty($instance["gallery_width"])) {$g_width = 'width='.$instance["gallery_width"];} else {$g_width = '';}
        if(!empty($instance["gallery_height"])) {$g_height = 'height='.$instance["gallery_height"];} else {$g_height = '';}
        if(!empty($instance["gallery_speed"])) {$g_speed = 'speed='.$instance["gallery_speed"];} else {$g_speed = '';}
        if(!empty($instance["gallery_type"])) { $g_type = $instance["gallery_type"]; } else {$g_type = 'standard';}
        if(!empty($instance["gallery_columns"])) { $g_columns = $instance["gallery_columns"]; } else {$g_columns = '3';}
        if(!empty($instance["gallery_captions"]) && $instance["gallery_captions"] == 'on') { $g_captions = 'caption=true';} else {$g_captions = '';}
        if($g_type == 'masonry') {$masonry = 'true';} else {$masonry = 'false';}

            ?>

          <?php echo $before_widget;
          if ( $title ) echo $before_title . $title . $after_title; 
          echo do_shortcode('[gallery ids='.$g_ids.' type='.$g_type.' '.$g_captions.' masonry='.$masonry.' columns='.$g_columns.' '.$g_speed.' '.$g_height.' '.$g_width .']');
          echo $after_widget;?>

    <?php }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['ids'] = $new_instance['ids'];
        $instance['gallery_type'] = $new_instance['gallery_type'];
        $instance['gallery_columns'] = $new_instance['gallery_columns']; 
        $instance['gallery_captions'] = $new_instance['gallery_captions'];
        $instance['gallery_width'] = (int) $new_instance['gallery_width'];
        $instance['gallery_height'] = (int) $new_instance['gallery_height'];
        $instance['gallery_speed'] = (int) $new_instance['gallery_speed'];
        $instance['title'] = strip_tags( $new_instance['title'] );
        $this->flush_widget_cache();
        return $instance;
    }
      function flush_widget_cache() {
        wp_cache_delete('virtue_gallery_widget', 'widget');
      }

  public function form($instance){ 
    $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
    $ids = isset($instance['ids']) ? esc_attr($instance['ids']) : '';
    $gallery_width = isset($instance['gallery_width']) ? esc_attr($instance['gallery_width']) : '';
    $gallery_height = isset($instance['gallery_height']) ? esc_attr($instance['gallery_height']) : '';
    $gallery_speed = isset($instance['gallery_speed']) ? esc_attr($instance['gallery_speed']) : '';
    if (isset($instance['gallery_type'])) { $gallery_type = esc_attr($instance['gallery_type']); } else {$gallery_type = 'standard';}
    if (isset($instance['gallery_columns'])) { $gallery_columns = esc_attr($instance['gallery_columns']); } else {$gallery_columns = '3';}
    if (isset($instance['gallery_captions'])) { $gallery_captions = esc_attr($instance['gallery_captions']); } else {$gallery_captions = 'off';}
    $gallery_type_array = array();
    $gallery_columns_array = array();
    $gallery_captions_array = array();
    $gallery_options = array(array("slug" => "standard", "name" => __('Standard', 'virtue')), array("slug" => "masonry", "name" => __('Masonry', 'virtue')), array( "slug" => "carousel", "name" => __('Carousel', 'virtue')), array( "slug" => "slider", "name" => __('Slider', 'virtue')));
    $gallery_columns_options = array(array("slug" => "1", "name" => __('1 Column', 'virtue')), array("slug" => "2", "name" => __('2 Columns', 'virtue')), array("slug" => "3", "name" => __('3 Columns', 'virtue')), array("slug" => "4", "name" => __('4 Columns', 'virtue')), array("slug" => "5", "name" => __('5 Columns', 'virtue')), array("slug" => "6", "name" => __('6 Columns', 'virtue')));
    $gallery_caption_options = array(array("slug" => "off", "name" => __('Off', 'virtue')), array("slug" => "on", "name" => __('On', 'virtue')));
     foreach ($gallery_caption_options as $gallery_caption_option) {
      if ($gallery_captions == $gallery_caption_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $gallery_captions_array[] = '<option value="' . $gallery_caption_option['slug'] .'"' . $selected . '>' . $gallery_caption_option['name'] . '</option>';
    }
    foreach ($gallery_options as $gallery_option) {
      if ($gallery_type == $gallery_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $gallery_type_array[] = '<option value="' . $gallery_option['slug'] .'"' . $selected . '>' . $gallery_option['name'] . '</option>';
    }
    foreach ($gallery_columns_options as $gallery_column_option) {
      if ($gallery_columns == $gallery_column_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $gallery_columns_array[] = '<option value="' . $gallery_column_option['slug'] .'"' . $selected . '>' . $gallery_column_option['name'] . '</option>';
    }?>  

    <div id="virtue_gallery_widget<?php echo esc_attr($this->get_field_id('container')); ?>" class="kad_widget_image_gallery">
        <div class="gallery_images">
            <?php
            $attachments = array_filter( explode( ',', $ids ) );
             if ( $attachments )
            foreach ( $attachments as $attachment_id ) {
                $img = wp_get_attachment_image_src($attachment_id, 'thumbnail');
                $imgfull = wp_get_attachment_image_src($attachment_id, 'full');
                    echo '<a class="of-uploaded-image" target="_blank" rel="external" href="' . $imgfull[0] . '">';
                    echo '<img class="gallery-widget-image" id="gallery_widget_image_'.$attachment_id. '" src="' . $img[0] . '" />';
                    echo '</a>';
                }
?>
        </div>
           <?php  echo '<a href="#" onclick="return false;" id="edit-gallery" class="gallery-attachments button button-primary">' . __('Add/Edit Gallery', 'virtue') . '</a> ';
            echo '<a href="#" onclick="return false;" id="clear-gallery" class="gallery-attachments button">' . __('Clear Gallery', 'virtue') . '</a>';
            echo '<input type="hidden" id="' . esc_attr($this->get_field_id('ids')) . '" class="gallery_values" value="' . $ids . '" name="' . esc_attr($this->get_field_name('ids')) . '" />';
            ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('gallery_type'); ?>"><?php _e('Gallery Type', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('gallery_type'); ?>" style="width:100%; max-width:230px" name="<?php echo $this->get_field_name('gallery_type'); ?>"><?php echo implode('', $gallery_type_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('gallery_columns'); ?>"><?php _e('Gallery Columns', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('gallery_columns'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('gallery_columns'); ?>"><?php echo implode('', $gallery_columns_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('gallery_captions'); ?>"><?php _e('Display Captions', 'virtue'); ?></label><br />
               <select id="<?php echo $this->get_field_id('gallery_captions'); ?>" style="width:100%; max-width:230px" name="<?php echo $this->get_field_name('gallery_captions'); ?>"><?php echo implode('', $gallery_captions_array);?></select>  
            </p>
            <p style="font-weight:bold;"><?php echo __('If Type Slider', 'virtue'); ?></p>
            <p>
                <label for="<?php echo $this->get_field_id('gallery_width'); ?>"><?php _e('Slider Width (e.g. = 600)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('gallery_width'); ?>" id="<?php echo $this->get_field_id('gallery_width'); ?>" value="<?php echo $gallery_width; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('gallery_height'); ?>"><?php _e('Slider Height (e.g. = 400)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('gallery_height'); ?>" id="<?php echo $this->get_field_id('gallery_height'); ?>" value="<?php echo $gallery_height; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('gallery_speed'); ?>"><?php _e('Slider Speed (e.g. = 7000)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('gallery_speed'); ?>" id="<?php echo $this->get_field_id('gallery_speed'); ?>" value="<?php echo $gallery_speed; ?>">
            </p>
    </div>

    <style type="text/css">.kad_widget_image_gallery {padding-bottom: 10px;}
.kad_widget_image_gallery .gallery_images:after { content: "."; display: block; height: 0; clear: both; visibility: hidden; }
.kad_widget_image_gallery .gallery_images {padding: 5px 5px 0; margin: 10px 0; background: #f2f2f2;}
.kad_widget_image_gallery .gallery_images img {max-width: 80px; height: auto; float: left; padding: 0 5px 5px 0}
</style>

<?php } }

class kad_carousel_widget extends WP_Widget{

function kad_carousel_widget() {
        $widget_ops = array('classname' => 'virtue_carousel_widget', 'description' => __('Adds a carousel to any widget area', 'virtue'));
        $this->WP_Widget('virtue_carousel_widget', __('Virtue: Carousel', 'virtue'), $widget_ops);
        $this->alt_option_name = 'virtue_carousel_widget';
    }

       public function widget($args, $instance){ 
        extract( $args ); 
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
        if(!empty($instance["type"])) {$c_type = $instance["type"];} else {$c_type = 'post';}
        if(!empty($instance["c_order"])) {$c_order = 'order='.$instance["c_order"];} else {$c_order = '';}
        if(!empty($instance["c_items"])) {$c_items = 'items='.$instance["c_items"];} else {$c_items = 'items=6';}
        if(!empty($instance["c_speed"])) {$c_speed = 'speed='.$instance["c_speed"];} else {$c_speed = '';}
        if(!empty($instance["c_cat"])) {$c_cat = 'cat='.$instance["c_cat"];} else {$c_cat = '';}
        if(!empty($instance["c_columns"])) { $c_columns = $instance["c_columns"]; } else {$c_columns = '1';}
        if(!empty($instance["c_scroll"])) { $c_scroll = $instance["c_scroll"]; } else {$c_scroll = '1';}

            ?>


          <?php echo $before_widget;
            if ( $title ) echo $before_title . $title . $after_title; 
           echo do_shortcode('[carousel type='.$c_type.' '.$c_items.' '.$c_order.' columns='.$c_columns.' '.$c_speed.' '.$c_cat.' scroll='.$c_scroll.']');
           echo $after_widget;?>

    <?php }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['type'] = $new_instance['type'];
        $instance['c_items'] = (int) $new_instance['c_items']; 
        $instance['c_columns'] = $new_instance['c_columns'];
        $instance['c_scroll'] = $new_instance['c_scroll'];
        $instance['c_cat'] = strip_tags( $new_instance['c_cat'] );
        $instance['c_speed'] = (int) $new_instance['c_speed'];
        $instance['title'] = strip_tags( $new_instance['title'] );
        $this->flush_widget_cache();
        return $instance;
    }
      function flush_widget_cache() {
        wp_cache_delete('virtue_carousel_widget', 'widget');
      }

  public function form($instance){ 
    $c_items = isset($instance['c_items']) ? esc_attr($instance['c_items']) : '';
    $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
    $c_cat = isset($instance['c_cat']) ? esc_attr($instance['c_cat']) : '';
    $c_speed = isset($instance['c_speed']) ? esc_attr($instance['c_speed']) : '';
    if (isset($instance['type'])) { $c_type = esc_attr($instance['type']); } else {$c_type = 'post';}
    if (isset($instance['c_scroll'])) { $c_scroll = esc_attr($instance['c_scroll']); } else {$c_scroll = '1';}
    if (isset($instance['c_columns'])) { $c_columns = esc_attr($instance['c_columns']); } else {$c_columns = '1';}
    $carousel_type_array = array();
    $carousel_scroll_array = array();
    $carousel_columns_array = array();
    $carousel_types = array(array("slug" => "post", "name" => __('Blog Posts', 'virtue')), array("slug" => "portfolio", "name" => __('Portfolio Posts', 'virtue')), array( "slug" => "featured-products", "name" => __('Featured Products', 'virtue')), array( "slug" => "sale-products", "name" => __('Sale Products', 'virtue')), array( "slug" => "best-products", "name" => __('Best Products', 'virtue')), array( "slug" => "cat-products", "name" => __('Category of Products', 'virtue')),);
    $carousel_columns_options = array(array("slug" => "1", "name" => __('1 Column', 'virtue')), array("slug" => "2", "name" => __('2 Columns', 'virtue')), array("slug" => "3", "name" => __('3 Columns', 'virtue')), array("slug" => "4", "name" => __('4 Columns', 'virtue')), array("slug" => "5", "name" => __('5 Columns', 'virtue')));
    $carousel_scroll_options = array(array("slug" => "1", "name" => __('1 item', 'virtue')), array("slug" => "all", "name" => __('All Visible', 'virtue')));

    foreach ($carousel_types as $carousel_type) {
      if ($c_type == $carousel_type['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $carousel_type_array[] = '<option value="' . $carousel_type['slug'] .'"' . $selected . '>' . $carousel_type['name'] . '</option>';
    }
    foreach ($carousel_scroll_options as $carousel_scroll_option) {
      if ($c_scroll == $carousel_scroll_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $carousel_scroll_array[] = '<option value="' . $carousel_scroll_option['slug'] .'"' . $selected . '>' . $carousel_scroll_option['name'] . '</option>';
    }
    foreach ($carousel_columns_options as $carousel_column_option) {
      if ($c_columns == $carousel_column_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $carousel_columns_array[] = '<option value="' . $carousel_column_option['slug'] .'"' . $selected . '>' . $carousel_column_option['name'] . '</option>';
    }?>  

    <div id="virtue_carousel_widget<?php echo esc_attr($this->get_field_id('container')); ?>" class="kad_widget_carousel">
          <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('type'); ?>"><?php _e('Carousel Type', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('type'); ?>" style="width:100%; max-width:230px" name="<?php echo $this->get_field_name('type'); ?>"><?php echo implode('', $carousel_type_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('c_columns'); ?>"><?php _e('Carousel Columns', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('c_columns'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('c_columns'); ?>"><?php echo implode('', $carousel_columns_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('c_items'); ?>"><?php _e('Items (e.g. = 8)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('c_items'); ?>" id="<?php echo $this->get_field_id('c_items'); ?>" value="<?php echo $c_items; ?>">
            </p>
             <p>
                <label for="<?php echo $this->get_field_id('c_scroll'); ?>"><?php _e('Scroll Setting', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('c_scroll'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('c_scroll'); ?>"><?php echo implode('', $carousel_scroll_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('c_cat'); ?>"><?php _e('Limit to Category (e.g. = Photos)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('c_cat'); ?>" id="<?php echo $this->get_field_id('c_cat'); ?>" value="<?php echo $c_cat; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('c_speed'); ?>"><?php _e('Carousel Speed (e.g. = 7000)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('c_speed'); ?>" id="<?php echo $this->get_field_id('c_speed'); ?>" value="<?php echo $c_speed; ?>">
            </p>
    </div>

<?php } }
class kad_infobox_widget extends WP_Widget{

function kad_infobox_widget() {
        $widget_ops = array('classname' => 'virtue_infobox_widget', 'description' => __('Adds a info box with icon options', 'virtue'));
        $this->WP_Widget('virtue_infobox_widget', __('Virtue: Info Box', 'virtue'), $widget_ops);
        $this->alt_option_name = 'virtue_infobox_widget';
    }

       public function widget($args, $instance){ 
        extract( $args ); 
        if(!empty($instance["title"])) {$title = '<h4>'.$instance["title"].'</h4>';} else {$title = '';}
        if(!empty($instance["description"])) {$description = '<p>'.$instance["description"].'</p>';} else {$description = '';}
        if(!empty($instance['image_uri'])) {$imglink = esc_url($instance['image_uri']);} else {$imglink = '';}
        if(!empty($instance["info_icon"])) {$icon = 'icon='.$instance["info_icon"];} else {$icon = '';}
        if(!empty($instance["background"])) {$info_background = 'background='.$instance["background"];} else {$info_background = '';}
        if(!empty($instance["iconbackground"])) {$icon_background = 'iconbackground='.$instance["iconbackground"];} else {$icon_background = '';}
        if(!empty($instance["size"])) {$info_size = 'size='.$instance["size"];} else {$info_size = 'size=48';}
        if(!empty($instance["style"])) { $style = 'style='.$instance["style"]; } else {$style = '';}
        if(!empty($instance["link"])) { $link = 'link='.$instance["link"]; } else {$link = '';}
        if(!empty($instance["color"])) { $color = 'color='.$instance["color"]; } else {$color = '';}
        if(!empty($imglink)) {$info_icon = 'image='.$imglink;} else {$info_icon = $icon;}

            ?>


          <?php echo $before_widget;
           echo do_shortcode('[infobox '.$link.' '.$info_icon.' '.$info_size.' '.$info_background.' '.$style .' '.$icon_background.' '.$color.'] '.$title.' '. $description.'[/infobox]');
           echo $after_widget;?>

    <?php }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['info_icon'] = $new_instance['info_icon'];
        $instance['image_uri'] = strip_tags( $new_instance['image_uri'] );
        $instance['background'] = strip_tags( $new_instance['background'] );
        $instance['iconbackground'] = strip_tags($new_instance['iconbackground'] );
        $instance['color'] = strip_tags( $new_instance['color'] );
        $instance['size'] = (int) $new_instance['size']; 
        $instance['style'] = $new_instance['style'];
        $instance['description'] = strip_tags( $new_instance['description'] );
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['link'] = $new_instance['link'];
        $this->flush_widget_cache();
        return $instance;
    }
      function flush_widget_cache() {
        wp_cache_delete('virtue_infobox_widget', 'widget');
      }

  public function form($instance){ 
    $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
    $link = isset($instance['link']) ? esc_attr($instance['link']) : '';
    $background = isset($instance['background']) ? esc_attr($instance['background']) : '';
    $iconbackground = isset($instance['iconbackground']) ? esc_attr($instance['iconbackground']) : '';
    $color = isset($instance['color']) ? esc_attr($instance['color']) : '';
    $size = isset($instance['size']) ? esc_attr($instance['size']) : '';
    if (isset($instance['info_icon'])) { $info_icon = esc_attr($instance['info_icon']); } else {$info_icon = '';}
    $image_uri = isset($instance['image_uri']) ? esc_attr($instance['image_uri']) : '';
    if (isset($instance['style'])) { $style = esc_attr($instance['style']); } else {$style = 'none';}
    $icon_style_array = array();
    $icon_array = array();
    $icon_style_options = array(array("slug" => "none", "name" => __('None', 'virtue')), array("slug" => "kad-circle-iconclass", "name" => __('Circle', 'virtue')), array("slug" => "kad-square-iconclass", "name" => __('Square', 'virtue')));
    $icons = array(array('name' => '', 'value' => ''), array('name' => 'icon-home'),array('name' => 'icon-home2'),array('name' => 'icon-office'),array('name' => 'icon-newspaper'),array('name' => 'icon-pencil'),array('name' => 'icon-pencil2'),array('name' => 'icon-pencil3'),array('name' => 'icon-pencil4'),array('name' => 'icon-quill'),array('name' => 'icon-quill2'),array('name' => 'icon-pen'),array('name' => 'icon-pen2'),array('name' => 'icon-home3'),array('name' => 'icon-marker'),array('name' => 'icon-brush'),array('name' => 'icon-palette'),array('name' => 'icon-palette2'),array('name' => 'icon-droplet'),array('name' => 'icon-droplet2'),array('name' => 'icon-paint-format'),array('name' => 'icon-images'),array('name' => 'icon-image'),array('name' => 'icon-image2'),array('name' => 'icon-images2'),array('name' => 'icon-camera'),array('name' => 'icon-camera2'),array('name' => 'icon-camera3'),array('name' => 'icon-music'),array('name' => 'icon-music2'),array('name' => 'icon-piano'),array('name' => 'icon-guitar'),array('name' => 'icon-headphones'),array('name' => 'icon-play'),array('name' => 'icon-movie'),array('name' => 'icon-film'),array('name' => 'icon-gamepad'),array('name' => 'icon-pacman'),array('name' => 'icon-bullhorn'),array('name' => 'icon-megaphone'),array('name' => 'icon-connection'),array('name' => 'icon-radio'),array('name' => 'icon-mic'),array('name' => 'icon-book'),array('name' => 'icon-books'),array('name' => 'icon-library'),array('name' => 'icon-file'),array('name' => 'icon-profile'),array('name' => 'icon-file2'),array('name' => 'icon-copy'),array('name' => 'icon-paste'),array('name' => 'icon-folder'),array('name' => 'icon-folder-open'),array('name' => 'icon-certificate'),array('name' => 'icon-cc'),array('name' => 'icon-tag'),array('name' => 'icon-tag2'),array('name' => 'icon-tags'),array('name' => 'icon-cart'),array('name' => 'icon-cart2'),array('name' => 'icon-cart3'),array('name' => 'icon-cart4'),array('name' => 'icon-basket'),array('name' => 'icon-basket2'),array('name' => 'icon-bag'),array('name' => 'icon-bag2'),array('name' => 'icon-bag3'),array('name' => 'icon-coin'),array('name' => 'icon-credit'),array('name' => 'icon-support'),array('name' => 'icon-phone'),array('name' => 'icon-address-book'),array('name' => 'icon-envelope'),array('name' => 'icon-mail-send'),array('name' => 'icon-envelope2'),array('name' => 'icon-pushpin'),array('name' => 'icon-location'),array('name' => 'icon-location2'),array('name' => 'icon-compass'),array('name' => 'icon-compass2'),array('name' => 'icon-map'),array('name' => 'icon-map2'),array('name' => 'icon-direction'),array('name' => 'icon-clock'),array('name' => 'icon-clock2'),array('name' => 'icon-watch'),array('name' => 'icon-alarm'),array('name' => 'icon-bell'),array('name' => 'icon-stopwatch'),array('name' => 'icon-calendar'),array('name' => 'icon-calendar2'),array('name' => 'icon-print'),array('name' => 'icon-mouse'),array('name' => 'icon-screen'),array('name' => 'icon-screen2'),array('name' => 'icon-laptop'),array('name' => 'icon-mobile'),array('name' => 'icon-mobile2'),array('name' => 'icon-tablet'),array('name' => 'icon-cabinet'),array('name' => 'icon-drawer'),array('name' => 'icon-drawer2'),array('name' => 'icon-box'),array('name' => 'icon-box-add'),array('name' => 'icon-box-remove'),array('name' => 'icon-cd'),array('name' => 'icon-storage'),array('name' => 'icon-undo'),array('name' => 'icon-redo'),array('name' => 'icon-rotate'),array('name' => 'icon-rotate2'),array('name' => 'icon-undo2'),array('name' => 'icon-redo2'),array('name' => 'icon-forward'),array('name' => 'icon-reply'),array('name' => 'icon-bubble'),array('name' => 'icon-bubbles'),array('name' => 'icon-bubbles2'),array('name' => 'icon-bubbles3'),array('name' => 'icon-user'),array('name' => 'icon-users'),array('name' => 'icon-users2'),array('name' => 'icon-users3'),array('name' => 'icon-vcard'),array('name' => 'icon-tshirt'),array('name' => 'icon-bubble-notification'),array('name' => 'icon-bubble2'),array('name' => 'icon-bubble3'),array('name' => 'icon-quotes-left'),array('name' => 'icon-quotes-right'),array('name' => 'icon-busy'),array('name' => 'icon-spinner'),array('name' => 'icon-spinner2'),array('name' => 'icon-search'),array('name' => 'icon-search2'),array('name' => 'icon-zoom-in'),array('name' => 'icon-zoom-out'),array('name' => 'icon-expand'),array('name' => 'icon-contract'),array('name' => 'icon-key'),array('name' => 'icon-lock'),array('name' => 'icon-wrench'),array('name' => 'icon-settings'),array('name' => 'icon-equalizer'),array('name' => 'icon-equalizer2'),array('name' => 'icon-equalizer3'),array('name' => 'icon-cog'),array('name' => 'icon-cogs'),array('name' => 'icon-tools'),array('name' => 'icon-screwdriver'),array('name' => 'icon-wand'),array('name' => 'icon-aid'),array('name' => 'icon-bug'),array('name' => 'icon-inject'),array('name' => 'icon-construction'),array('name' => 'icon-pie'),array('name' => 'icon-stats'),array('name' => 'icon-stats2'),array('name' => 'icon-stats3'),array('name' => 'icon-bars'),array('name' => 'icon-bars2'),array('name' => 'icon-bars3'),array('name' => 'icon-gift'),array('name' => 'icon-balloon'),array('name' => 'icon-stats-up'),array('name' => 'icon-gift2'),array('name' => 'icon-medal'),array('name' => 'icon-crown'),array('name' => 'icon-trophy'),array('name' => 'icon-glass'),array('name' => 'icon-glass2'),array('name' => 'icon-bottle'),array('name' => 'icon-food'),array('name' => 'icon-food2'),array('name' => 'icon-cup'),array('name' => 'icon-leaf'),array('name' => 'icon-leaf2'),array('name' => 'icon-apple-fruit'),array('name' => 'icon-tree'),array('name' => 'icon-paw'),array('name' => 'icon-steps'),array('name' => 'icon-flower'),array('name' => 'icon-rocket'),array('name' => 'icon-meter'),array('name' => 'icon-meter-fast'),array('name' => 'icon-mug'),array('name' => 'icon-dashboard'),array('name' => 'icon-hammer'),array('name' => 'icon-fire'),array('name' => 'icon-bomb'),array('name' => 'icon-lab'),array('name' => 'icon-atom'),array('name' => 'icon-magnet'),array('name' => 'icon-dumbbell'),array('name' => 'icon-lamp'),array('name' => 'icon-lamp2'),array('name' => 'icon-lamp3'),array('name' => 'icon-lamp4'),array('name' => 'icon-remove'),array('name' => 'icon-remove2'),array('name' => 'icon-remove3'),array('name' => 'icon-briefcase'),array('name' => 'icon-briefcase2'),array('name' => 'icon-briefcase3'),array('name' => 'icon-airplane'),array('name' => 'icon-airplane2'),array('name' => 'icon-paper-plane'),array('name' => 'icon-car'),array('name' => 'icon-gas-pump'),array('name' => 'icon-bus'),array('name' => 'icon-truck'),array('name' => 'icon-bike'),array('name' => 'icon-train'),array('name' => 'icon-boat'),array('name' => 'icon-cube'),array('name' => 'icon-cube4'),array('name' => 'icon-cylinder'),array('name' => 'icon-puzzle'),array('name' => 'icon-puzzle2'),array('name' => 'icon-glasses'),array('name' => 'icon-glasses2'),array('name' => 'icon-sun-glasses'),array('name' => 'icon-accessibility'),array('name' => 'icon-accessibility2'),array('name' => 'icon-brain'),array('name' => 'icon-target'),array('name' => 'icon-shield'),array('name' => 'icon-shield2'),array('name' => 'icon-soccer'),array('name' => 'icon-football'),array('name' => 'icon-baseball'),array('name' => 'icon-basketball'),array('name' => 'icon-golf'),array('name' => 'icon-hockey'),array('name' => 'icon-racing'),array('name' => 'icon-eight-ball'),array('name' => 'icon-bowling-ball'),array('name' => 'icon-bowling'),array('name' => 'icon-lightning'),array('name' => 'icon-power'),array('name' => 'icon-switch'),array('name' => 'icon-power-cord'),array('name' => 'icon-clipboard'),array('name' => 'icon-signup'),array('name' => 'icon-clipboard2'),array('name' => 'icon-clipboard3'),array('name' => 'icon-grid'),array('name' => 'icon-grid2'),array('name' => 'icon-grid3'),array('name' => 'icon-grid4'),array('name' => 'icon-grid5'),array('name' => 'icon-menu'),array('name' => 'icon-menu2'),array('name' => 'icon-menu3'),array('name' => 'icon-menu4'),array('name' => 'icon-menu5'),array('name' => 'icon-menu6'),array('name' => 'icon-cloud'),array('name' => 'icon-download'),array('name' => 'icon-upload'),array('name' => 'icon-globe'),array('name' => 'icon-earth'),array('name' => 'icon-network'),array('name' => 'icon-link'),array('name' => 'icon-link2'),array('name' => 'icon-link3'),array('name' => 'icon-cloud-download'),array('name' => 'icon-cloud-upload'),array('name' => 'icon-link4'),array('name' => 'icon-anchor'),array('name' => 'icon-flag'),array('name' => 'icon-flag2'),array('name' => 'icon-flag3'),array('name' => 'icon-attachment'),array('name' => 'icon-attachment2'),array('name' => 'icon-eye'),array('name' => 'icon-bookmark'),array('name' => 'icon-bookmarks'),array('name' => 'icon-spotlight'),array('name' => 'icon-temperature'),array('name' => 'icon-weather-lightning'),array('name' => 'icon-weather-rain'),array('name' => 'icon-weather-snow'),array('name' => 'icon-windy'),array('name' => 'icon-snowflake'),array('name' => 'icon-sun'),array('name' => 'icon-eye-blocked'),array('name' => 'icon-moon'),array('name' => 'icon-bed'),array('name' => 'icon-star'),array('name' => 'icon-star2'),array('name' => 'icon-star3'),array('name' => 'icon-heart'),array('name' => 'icon-heart2'),array('name' => 'icon-heart-broken'),array('name' => 'icon-thumbs-up'),array('name' => 'icon-thumbs-down'),array('name' => 'icon-man'),array('name' => 'icon-woman'),array('name' => 'icon-people'),array('name' => 'icon-happy'),array('name' => 'icon-happy2'),array('name' => 'icon-smiley'),array('name' => 'icon-smiley2'),array('name' => 'icon-tongue'),array('name' => 'icon-tongue2'),array('name' => 'icon-sad'),array('name' => 'icon-sad2'),array('name' => 'icon-wink'),array('name' => 'icon-wink2'),array('name' => 'icon-grin'),array('name' => 'icon-grin2'),array('name' => 'icon-cool'),array('name' => 'icon-cool2'),array('name' => 'icon-shocked'),array('name' => 'icon-shocked2'),array('name' => 'icon-neutral'),array('name' => 'icon-neutral2'),array('name' => 'icon-hand'),array('name' => 'icon-stack-picture'),array('name' => 'icon-stack-list'),array('name' => 'icon-stack-clubs'),array('name' => 'icon-stack-spades'),array('name' => 'icon-stack-hearts'),array('name' => 'icon-stack-diamonds'),array('name' => 'icon-stack-user'),array('name' => 'icon-stack-music'),array('name' => 'icon-angry'),array('name' => 'icon-angry2'),array('name' => 'icon-evil'),array('name' => 'icon-evil2'),array('name' => 'icon-confused'),array('name' => 'icon-confused2'),array('name' => 'icon-wondering'),array('name' => 'icon-wondering2'),array('name' => 'icon-cursor'),array('name' => 'icon-move'),array('name' => 'icon-warning'),array('name' => 'icon-warning2'),array('name' => 'icon-notification'),array('name' => 'icon-notification2'),array('name' => 'icon-question'),array('name' => 'icon-question2'),array('name' => 'icon-question3'),array('name' => 'icon-plus-circle'),array('name' => 'icon-plus-circle2'),array('name' => 'icon-minus-circle'),array('name' => 'icon-minus-circle2'),array('name' => 'icon-info'),array('name' => 'icon-info2'),array('name' => 'icon-cancel-circle'),array('name' => 'icon-cancel-circle2'),array('name' => 'icon-checkmark-circle'),array('name' => 'icon-checkmark-circle2'),array('name' => 'icon-close'),array('name' => 'icon-close2'),array('name' => 'icon-checkmark'),array('name' => 'icon-checkmark2'),array('name' => 'icon-checkmark3'),array('name' => 'icon-checkmark4'),array('name' => 'icon-minus'),array('name' => 'icon-plus'),array('name' => 'icon-bed2'),array('name' => 'icon-fan'),array('name' => 'icon-umbrella'),array('name' => 'icon-play2'),array('name' => 'icon-pause'),array('name' => 'icon-stop'),array('name' => 'icon-backward'),array('name' => 'icon-forward2'),array('name' => 'icon-play3'),array('name' => 'icon-pause2'),array('name' => 'icon-stop2'),array('name' => 'icon-backward2'),array('name' => 'icon-forward3'),array('name' => 'icon-first'),array('name' => 'icon-last'),array('name' => 'icon-previous'),array('name' => 'icon-next'),array('name' => 'icon-eject'),array('name' => 'icon-volume-high'),array('name' => 'icon-volume-medium'),array('name' => 'icon-volume-low'),array('name' => 'icon-volume-mute'),array('name' => 'icon-arrow-up'),array('name' => 'icon-arrow-right'),array('name' => 'icon-arrow-down'),array('name' => 'icon-arrow-left'),array('name' => 'icon-arrow-up2'),array('name' => 'icon-arrow-right2'),array('name' => 'icon-arrow-down2'),array('name' => 'icon-arrow-left2'),array('name' => 'icon-arrow-up-left'),array('name' => 'icon-arrow-up3'),array('name' => 'icon-arrow-up-right'),array('name' => 'icon-arrow-right3'),array('name' => 'icon-arrow-down-right'),array('name' => 'icon-arrow-down3'),array('name' => 'icon-arrow-down-left'),array('name' => 'icon-arrow-left3'),array('name' => 'icon-arrow-up4'),array('name' => 'icon-arrow-right4'),array('name' => 'icon-arrow-down4'),array('name' => 'icon-arrow-left4'),array('name' => 'icon-arrow-up5'),array('name' => 'icon-arrow-right5'),array('name' => 'icon-arrow-bottom'),array('name' => 'icon-arrow-left5'),array('name' => 'icon-arrow-up6'),array('name' => 'icon-arrow-right6'),array('name' => 'icon-arrow-down5'),array('name' => 'icon-arrow-left6'),array('name' => 'icon-transmission'),array('name' => 'icon-sort'),array('name' => 'icon-loop'),array('name' => 'icon-loop2'),array('name' => 'icon-checkbox-checked'),array('name' => 'icon-checkbox'),array('name' => 'icon-checkbox-checked2'),array('name' => 'icon-crop'),array('name' => 'icon-vector'),array('name' => 'icon-rulers'),array('name' => 'icon-scissors'),array('name' => 'icon-filter'),array('name' => 'icon-font'),array('name' => 'icon-font-size'),array('name' => 'icon-text-height'),array('name' => 'icon-text-width'),array('name' => 'icon-height'),array('name' => 'icon-width'),array('name' => 'icon-page-break'),array('name' => 'icon-page-break2'),array('name' => 'icon-new-tab'),array('name' => 'icon-new-tab2'),array('name' => 'icon-embed'),array('name' => 'icon-code'),array('name' => 'icon-mail'),array('name' => 'icon-mail2'),array('name' => 'icon-mail3'),array('name' => 'icon-table'),array('name' => 'icon-google-plus'),array('name' => 'icon-google-plus2'),array('name' => 'icon-google-plus3'),array('name' => 'icon-facebook'),array('name' => 'icon-facebook2'),array('name' => 'icon-facebook3'),array('name' => 'icon-instagram'),array('name' => 'icon-twitter'),array('name' => 'icon-twitter2'),array('name' => 'icon-feed'),array('name' => 'icon-feed2'),array('name' => 'icon-youtube'),array('name' => 'icon-youtube2'),array('name' => 'icon-vimeo'),array('name' => 'icon-vimeo2'),array('name' => 'icon-lanyrd'),array('name' => 'icon-flickr'),array('name' => 'icon-flickr2'),array('name' => 'icon-picassa'),array('name' => 'icon-picassa2'),array('name' => 'icon-dribbble'),array('name' => 'icon-dribbble2'),array('name' => 'icon-forrst'),array('name' => 'icon-forrst2'),array('name' => 'icon-deviantart'),array('name' => 'icon-deviantart2'),array('name' => 'icon-github'),array('name' => 'icon-github2'),array('name' => 'icon-github3'),array('name' => 'icon-wordpress'),array('name' => 'icon-blogger'),array('name' => 'icon-blogger2'),array('name' => 'icon-tumblr'),array('name' => 'icon-tumblr2'),array('name' => 'icon-apple'),array('name' => 'icon-android'),array('name' => 'icon-windows'),array('name' => 'icon-windows8'),array('name' => 'icon-skype'),array('name' => 'icon-linkedin'),array('name' => 'icon-lastfm'),array('name' => 'icon-lastfm2'),array('name' => 'icon-stumbleupon'),array('name' => 'icon-stumbleupon2'),array('name' => 'icon-pinterest'),array('name' => 'icon-pinterest2'),array('name' => 'icon-xing'),array('name' => 'icon-paypal'),array('name' => 'icon-html5'),array('name' => 'icon-css3'),array('name' => 'icon-file-zip'),array('name' => 'icon-file-xml'),array('name' => 'icon-file-pdf'),array('name' => 'icon-file-word'),array('name' => 'icon-file-excel'),array('name' => 'icon-king'),array('name' => 'icon-queen'),array('name' => 'icon-rock'),array('name' => 'icon-knight'),array('name' => 'icon-github4'),array('name' => 'icon-steam'),array('name' => 'icon-steam2'),array('name' => 'icon-yahoo'),array('name' => 'icon-flickr3'),array('name' => 'icon-google-drive'),array('name' => 'icon-chrome'),array('name' => 'icon-firefox'),array('name' => 'icon-IE'),array('name' => 'icon-opera'),array('name' => 'icon-safari'),array('name' => 'icon-IcoMoon'),array('name' => 'icon-html52'));

    foreach ($icons as $icon) {
      if ($info_icon == $icon['name']) { $selected=' selected="selected"';} else { $selected=""; }
      $icon_array[] = '<option value="' . $icon['name'] .'"' . $selected . '>' . $icon['name'] . '</option>';
    }
    foreach ($icon_style_options as $icon_style_option) {
      if ($style == $icon_style_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $icon_style_array[] = '<option value="' . $icon_style_option['slug'] .'"' . $selected . '>' . $icon_style_option['name'] . '</option>';
    }
    ?>  

    <div id="virtue_infobox_widget<?php echo esc_attr($this->get_field_id('container')); ?>" class="kad_img_upload_widget kad_infobox_widget">
            <p>
                <label for="<?php echo $this->get_field_id('info_icon'); ?>"><?php _e('Choose an Icon', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('info_icon'); ?>" class="kad_icomoon" name="<?php echo $this->get_field_name('info_icon'); ?>"><?php echo implode('', $icon_array);?></select>
            </p>
            <p>
            <img class="kad_custom_media_image" src="<?php if(!empty($instance['image_uri'])){echo $instance['image_uri'];} ?>" style="margin:0;padding:0;max-width:100px;display:block" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('image_uri'); ?>"><?php _e('Or upload a custom icon', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_custom_media_url" name="<?php echo $this->get_field_name('image_uri'); ?>" id="<?php echo $this->get_field_id('image_uri'); ?>" value="<?php echo $image_uri; ?>">
                <input type="button" value="<?php _e('Upload', 'virtue'); ?>" class="button kad_custom_media_upload" id="kad_custom_image_uploader" />
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
             <p>
              <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('description'); ?>" style="min-height: 100px;" id="<?php echo $this->get_field_id('description'); ?>" class="widefat" ><?php if(!empty($instance['description'])) echo $instance['description']; ?></textarea>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('background'); ?>"><?php _e('Box Background Color (e.g. = #f2f2f2)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad-widget-colorpicker" style="width: 70px;"  name="<?php echo $this->get_field_name('background'); ?>" id="<?php echo $this->get_field_id('background'); ?>" value="<?php echo $background; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('size'); ?>"><?php _e('Icon Size (e.g. = 48)', 'virtue'); ?></label><br />
                <input type="number" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('size'); ?>" id="<?php echo $this->get_field_id('size'); ?>" value="<?php echo $size; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('style'); ?>"><?php _e('Icon Style', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('style'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('style'); ?>"><?php echo implode('', $icon_style_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('iconbackground'); ?>"><?php _e('Icon Background Color (e.g. = #444444)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad-widget-colorpicker" style="width: 70px;"  name="<?php echo $this->get_field_name('iconbackground'); ?>" id="<?php echo $this->get_field_id('iconbackground'); ?>" value="<?php echo $iconbackground; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('color'); ?>"><?php _e('Icon Color (e.g. = #f2f2f2)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad-widget-colorpicker" style="width: 70px;"  name="<?php echo $this->get_field_name('color'); ?>" id="<?php echo $this->get_field_id('color'); ?>" value="<?php echo $color; ?>">
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php echo $link; ?>" />
            </p>

    </div>

<?php } }

class kad_gmap_widget extends WP_Widget{

function kad_gmap_widget() {
        $widget_ops = array('classname' => 'virtue_gmap_widget', 'description' => __('Adds a google map to a widget area', 'virtue'));
        $this->WP_Widget('virtue_gmap_widget', __('Virtue: Google Map', 'virtue'), $widget_ops);
        $this->alt_option_name = 'virtue_gmap_widget';
    }

       public function widget($args, $instance){ 
        extract( $args ); 
        if(!empty($instance["location"])) {$location = $instance["location"];} else {$location = '';}
        if(!empty($instance["locationtitle"])) {$locationtitle = $instance["locationtitle"];} else {$locationtitle = '';}
        if(!empty($instance["location2"])) {$location2 = 'address2="'.$instance["location2"].'"';} else {$location2 = '';}
        if(!empty($instance["locationtitle2"])) {$locationtitle2 = 'title2="'.$instance["locationtitle2"].'"';} else {$locationtitle2 = '';}
        if(!empty($instance["location3"])) {$location3 = 'address3="'.$instance["location3"].'"';} else {$location3 = '';}
        if(!empty($instance["locationtitle3"])) {$locationtitle3 = 'title3="'.$instance["locationtitle3"].'"';} else {$locationtitle3 = '';}
        if(!empty($instance["location4"])) {$location4 = 'address4="'.$instance["location4"].'"';} else {$location4 = '';}
        if(!empty($instance["locationtitle4"])) {$locationtitle4 = 'title4="'.$instance["locationtitle4"].'"';} else {$locationtitle4 = '';}
        if(!empty($instance["center"])) {$center = 'center="'.$instance["center"].'"';} else {$center = '';}
        if(!empty($instance['height'])) {$height = 'height="'.esc_attr($instance['height']).'"';} else {$height = '';}
        if(!empty($instance["maptype"])) {$maptype = 'maptype='.$instance["maptype"];} else {$maptype = '';}
        if(!empty($instance["zoom"])) {$zoom = 'zoom='.$instance["zoom"];} else {$zoom = '';}
            ?>


          <?php echo $before_widget;
           echo do_shortcode('[gmap address="'.$location.'" title="'.$locationtitle.'" '.$height.' '.$maptype.' '.$zoom. ' '.$location2.' '.$location3.' '.$location4.' '.$center.' '.$locationtitle2.' '.$locationtitle3.' '.$locationtitle4.']');
           echo $after_widget;?>

    <?php }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['locationtitle'] = strip_tags( $new_instance['locationtitle'] );
        $instance['location'] = $new_instance['location'];
        $instance['locationtitle2'] = strip_tags( $new_instance['locationtitle2'] );
        $instance['location2'] = $new_instance['location2'];
        $instance['locationtitle3'] = strip_tags( $new_instance['locationtitle3'] );
        $instance['location3'] = $new_instance['location3'];
        $instance['locationtitle4'] = strip_tags( $new_instance['locationtitle4'] );
        $instance['location4'] = $new_instance['location4'];
        $instance['center'] = $new_instance['center'];
        $instance['height'] = (int) $new_instance['height'];
        $instance['maptype'] = $new_instance['maptype']; 
        $instance['zoom'] = $new_instance['zoom'];
        $this->flush_widget_cache();
        return $instance;
    }
      function flush_widget_cache() {
        wp_cache_delete('virtue_gmap_widget', 'widget');
      }

  public function form($instance){
    $locationtitle = isset($instance['locationtitle']) ? esc_attr($instance['locationtitle']) : '';
    $locationtitle2 = isset($instance['locationtitle2']) ? esc_attr($instance['locationtitle2']) : '';
    $locationtitle3 = isset($instance['locationtitle3']) ? esc_attr($instance['locationtitle3']) : '';
    $locationtitle4 = isset($instance['locationtitle4']) ? esc_attr($instance['locationtitle4']) : '';
    $height = isset($instance['height']) ? esc_attr($instance['height']) : '';
    if (isset($instance['zoom'])) { $zoom = esc_attr($instance['zoom']); } else {$zoom = '15';}
    if (isset($instance['maptype'])) { $maptype = esc_attr($instance['maptype']); } else {$maptype = 'ROADMAP';}
    $map_type_array = array();
    $zoom_array = array();
    $map_type_options = array(array("slug" => "ROADMAP", "name" => __('ROADMAP', 'virtue')), array("slug" => "HYBRID", "name" => __('HYBRID', 'virtue')), array("slug" => "TERRAIN", "name" => __('TERRAIN', 'virtue')), array("slug" => "SATELLITE", "name" => __('SATELLITE', 'virtue')));
    $zoom_options = array(array("slug" => "1"), array("slug" => "2"), array("slug" => "3"), array("slug" => "4"), array("slug" => "5"), array("slug" => "6"), array("slug" => "7"), array("slug" => "8"), array("slug" => "9"), array("slug" => "10"), array("slug" => "11"), array("slug" => "12"), array("slug" => "13"), array("slug" => "14"), array("slug" => "15"), array("slug" => "16"), array("slug" => "17"), array("slug" => "18"), array("slug" => "19"), array("slug" => "20"), array("slug" => "21"));
    foreach ($zoom_options as $zoom_option) {
      if ($zoom == $zoom_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $zoom_array[] = '<option value="' . $zoom_option['slug'] .'"' . $selected . '>' . $zoom_option['slug'] . '</option>';
    }
    foreach ($map_type_options as $map_type_option) {
      if ($maptype  == $map_type_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $map_type_array[] = '<option value="' . $map_type_option['slug'] .'"' . $selected . '>' . $map_type_option['name'] . '</option>';
    }
    ?>  

    <div id="virtue_gmap_widget<?php echo esc_attr($this->get_field_id('container')); ?>" class="kad_gmap_widget">
            <p>
            <label for="<?php echo $this->get_field_id('locationtitle'); ?>"><?php _e('Marker Title:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('locationtitle'); ?>" name="<?php echo $this->get_field_name('locationtitle'); ?>" type="text" value="<?php echo $locationtitle; ?>" />
            </p>
            <p>
              <label for="<?php echo $this->get_field_id('location'); ?>"><?php _e('Marker Address', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('location'); ?>" style="min-height: 50px;" id="<?php echo $this->get_field_id('location'); ?>" class="widefat" ><?php if(!empty($instance['location'])) echo $instance['location']; ?></textarea>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('maptype'); ?>"><?php _e('Map Type', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('maptype'); ?>" name="<?php echo $this->get_field_name('maptype'); ?>"><?php echo implode('', $map_type_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('zoom'); ?>"><?php _e('Map Zoom', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('zoom'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('zoom'); ?>"><?php echo implode('', $zoom_array);?></select>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('height'); ?>"><?php _e('Map Height (e.g. = 300)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_map_widget_height" name="<?php echo $this->get_field_name('height'); ?>" id="<?php echo $this->get_field_id('height'); ?>" value="<?php echo $height; ?>">
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('locationtitle2'); ?>"><?php _e('Marker Title Two:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('locationtitle2'); ?>" name="<?php echo $this->get_field_name('locationtitle2'); ?>" type="text" value="<?php echo $locationtitle2; ?>" />
            </p>
            <p>
              <label for="<?php echo $this->get_field_id('location2'); ?>"><?php _e('Marker Address Two', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('location2'); ?>" style="min-height: 50px;" id="<?php echo $this->get_field_id('location2'); ?>" class="widefat" ><?php if(!empty($instance['location2'])) echo $instance['location2']; ?></textarea>
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('locationtitle3'); ?>"><?php _e('Marker Title Three:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('locationtitle3'); ?>" name="<?php echo $this->get_field_name('locationtitle3'); ?>" type="text" value="<?php echo $locationtitle3; ?>" />
            </p>
            <p>
              <label for="<?php echo $this->get_field_id('location3'); ?>"><?php _e('Marker Address Three', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('location3'); ?>" style="min-height: 50px;" id="<?php echo $this->get_field_id('location3'); ?>" class="widefat" ><?php if(!empty($instance['location3'])) echo $instance['location3']; ?></textarea>
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('locationtitle4'); ?>"><?php _e('Marker Title Four:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('locationtitle4'); ?>" name="<?php echo $this->get_field_name('locationtitle4'); ?>" type="text" value="<?php echo $locationtitle4; ?>" />
            </p>
            <p>
              <label for="<?php echo $this->get_field_id('location4'); ?>"><?php _e('Marker Address Four', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('location4'); ?>" style="min-height: 50px;" id="<?php echo $this->get_field_id('location4'); ?>" class="widefat" ><?php if(!empty($instance['location4'])) echo $instance['location4']; ?></textarea>
            </p>
            <p>
              <label for="<?php echo $this->get_field_id('center'); ?>"><?php _e('Map Center (defauts to first address)', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('center'); ?>" style="min-height: 50px;" id="<?php echo $this->get_field_id('center'); ?>" class="widefat" ><?php if(!empty($instance['center'])) echo $instance['center']; ?></textarea>
            </p>
    </div>

<?php } }

class kad_calltoaction_widget extends WP_Widget{

function kad_calltoaction_widget() {
        $widget_ops = array('classname' => 'virtue_calltoaction_widget', 'description' => __('Adds a simple call to action', 'virtue'));
        $this->WP_Widget('virtue_calltoaction_widget', __('Virtue: Call to Action', 'virtue'), $widget_ops);
        $this->alt_option_name = 'virtue_calltoaction_widget';
    }

       public function widget($args, $instance){ 
        extract( $args ); 
        if(!empty($instance["title"])) {$title = $instance["title"];} else {$title = '';}
        if(!empty($instance["subtitle"])) {$subtitle = $instance["subtitle"];} else {$subtitle = '';}
        if(!empty($instance['btn_link'])) {$link = esc_url($instance['btn_link']);} else {$link = '';}
        if(!empty($instance["btn_text"])) {$btn = $instance["btn_text"];} else {$btn = '';}
        if(!empty($instance["btn_target"])) {$btn_target = $instance["btn_target"];} else {$btn_target = 'false';}
        if(!empty($instance["tsize"])) {$tsize = 'font-size:'.$instance["tsize"].'px;';} else {$tsize = '';}
        if(!empty($instance["ssize"])) {$ssize = 'font-size:'.$instance["ssize"].'px;';} else {$ssize = '';}
        if(!empty($instance["align"])) { $align = $instance["align"];} else {$align = 'center';}
        if(!empty($instance["tcolor"])) { $tcolor = 'color:'.$instance["tcolor"].';'; } else {$tcolor = '';}
        if(!empty($instance["scolor"])) { $scolor = 'color:'.$instance["scolor"].';'; } else {$scolor = '';}
            ?>


          <?php echo $before_widget;
            echo '<h1 style="'.$tcolor.' '.$tsize.' text-align:'.$align.';">'.$title.'</h1>';
            if($subtitle) { echo '<h5 style="'.$scolor.' '.$ssize.' text-align:'.$align.';">'.$subtitle.'</h5>'; }
            echo '<div style="text-align:'.$align.'">';
            echo do_shortcode('[btn text="'.$btn.'" tcolor="#ffffff" link="'.$link.'" size="large" target="'.$btn_target.'" font="h1-family"]');
            echo '</div>';
           echo $after_widget;?>

    <?php }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['align'] = $new_instance['align'];
        $instance['btn_target'] = $new_instance['btn_target'];
        $instance['btn_link'] = strip_tags( $new_instance['btn_link'] );
        $instance['btn_text'] = strip_tags( $new_instance['btn_text'] );
        $instance['tcolor'] = strip_tags( $new_instance['tcolor'] );
        $instance['scolor'] = strip_tags( $new_instance['scolor'] );
        $instance['tsize'] = (int) $new_instance['tsize'];
        $instance['ssize'] = (int) $new_instance['ssize']; 
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['subtitle'] = strip_tags( $new_instance['subtitle'] );
        $this->flush_widget_cache();
        return $instance;
    }
      function flush_widget_cache() {
        wp_cache_delete('virtue_calltoaction_widget', 'widget');
      }

  public function form($instance){ 
    $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
    $subtitle = isset($instance['subtitle']) ? esc_attr($instance['subtitle']) : '';
    $tcolor = isset($instance['tcolor']) ? esc_attr($instance['tcolor']) : '';
    $scolor = isset($instance['scolor']) ? esc_attr($instance['scolor']) : '';
    $tsize = isset($instance['tsize']) ? esc_attr($instance['tsize']) : '';
    $ssize = isset($instance['ssize']) ? esc_attr($instance['ssize']) : '';
    $btn_link = isset($instance['btn_link']) ? esc_attr($instance['btn_link']) : '';
    $btn_text = isset($instance['btn_text']) ? esc_attr($instance['btn_text']) : '';
    if (isset($instance['align'])) { $align = esc_attr($instance['align']); } else {$align = 'center';}
    if (isset($instance['btn_target'])) { $btn_target = esc_attr($instance['btn_target']); } else {$btn_target = 'false';}
    $align_array = array();
    $btn_target_array = array();
    $align_options = array(array("slug" => "center", "name" => __('Center', 'virtue')), array("slug" => "left", "name" => __('Left', 'virtue')), array("slug" => "right", "name" => __('Right', 'virtue')));
    $btn_target_options = array(array("slug" => "false", "name" => __('Self', 'virtue')), array("slug" => "true", "name" => __('New Window', 'virtue')));
    foreach ($align_options as $align_option) {
      if ($align == $align_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $align_array[] = '<option value="' . $align_option['slug'] .'"' . $selected . '>' . $align_option['name'] . '</option>';
    }
    foreach ($btn_target_options as $btn_target_option) {
      if ($btn_target == $btn_target_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $btn_target_array[] = '<option value="' . $btn_target_option['slug'] .'"' . $selected . '>' . $btn_target_option['name'] . '</option>';
    }
    ?>  

    <div id="virtue_calltoaction_widget<?php echo esc_attr($this->get_field_id('container')); ?>" class="kad_calltoaction_widget kad-colorpick">
            <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('tsize'); ?>"><?php _e('Title Size (e.g. = 48)', 'virtue'); ?></label><br />
                <input type="number" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('tsize'); ?>" id="<?php echo $this->get_field_id('tsize'); ?>" style="width: 70px;" value="<?php echo $tsize; ?>">
            </p>
             <p>
                <label for="<?php echo $this->get_field_id('tcolor'); ?>"><?php _e('Title Color (e.g. = #f2f2f2)', 'virtue'); ?></label><br />
                <input type="text" class="kad-widget-colorpicker" name="<?php echo $this->get_field_name('tcolor'); ?>" id="<?php echo $this->get_field_id('tcolor'); ?>" style="width: 70px;" value="<?php echo $tcolor; ?>">
            </p>
             <p>
              <label for="<?php echo $this->get_field_id('subtitle'); ?>"><?php _e('Subtitle', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('subtitle'); ?>" style="min-height: 50px;" id="<?php echo $this->get_field_id('subtitle'); ?>" class="widefat" ><?php echo $subtitle; ?></textarea>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('ssize'); ?>"><?php _e('Subtitle Size (e.g. = 48)', 'virtue'); ?></label><br />
                <input type="number" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('ssize'); ?>" id="<?php echo $this->get_field_id('ssize'); ?>" style="width: 70px;" value="<?php echo $ssize; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('scolor'); ?>"><?php _e('Subtitle Color (e.g. = #f2f2f2)', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad-widget-colorpicker" name="<?php echo $this->get_field_name('scolor'); ?>" id="<?php echo $this->get_field_id('scolor'); ?>" value="<?php echo $scolor; ?>">
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('align'); ?>"><?php _e('Align', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('align'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('align'); ?>"><?php echo implode('', $align_array);?></select>
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('btn_text'); ?>"><?php _e('Button Text:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('btn_text'); ?>" name="<?php echo $this->get_field_name('btn_text'); ?>" type="text" value="<?php echo $btn_text; ?>" />
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('btn_link'); ?>"><?php _e('Button Link:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('btn_link'); ?>" name="<?php echo $this->get_field_name('btn_link'); ?>" type="text" value="<?php echo $btn_link; ?>" />
            </p>
             <p>
                <label for="<?php echo $this->get_field_id('btn_target'); ?>"><?php _e('Link Target', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('btn_target'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('btn_target'); ?>"><?php echo implode('', $btn_target_array);?></select>
            </p>
    </div>

<?php } }

class kad_imgmenu_widget extends WP_Widget{

function kad_imgmenu_widget() {
        $widget_ops = array('classname' => 'virtue_imgmenu_widget', 'description' => __('Adds an image background with text, link and hover effect.', 'virtue'));
        $this->WP_Widget('virtue_imgmenu_widget', __('Virtue: Image Menu Item', 'virtue'), $widget_ops);
        $this->alt_option_name = 'virtue_imgmenu_widget';
    }

       public function widget($args, $instance){ 
        extract( $args ); 
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
        if(!empty($instance["description"])) {$description = $instance["description"];} else {$description = '';}
        if(!empty($instance['image_uri'])) {$image = esc_url($instance['image_uri']);} else {$image = virtue_img_placeholder();}
        if(!empty($instance["height"])) { $height = $instance["height"];} else {$height = '210';}
        if(!empty($instance["link"])) { $link = $instance["link"];} else {$link = '#';}
        if(!empty($instance["target"]) && $instance["target"] == 'true') { $linktarget = 'target="_blank"';} else {$linktarget = '';}
            ?>

                <?php echo $before_widget; ?>
                <div class="kad-animation" data-animation="fade-in" data-delay="<?php echo $counter*150;?>">
                    <?php if($link != '') echo '<a href="'.$link.'" '.$linktarget.' class="homepromolink">'; ?>
                        <div class="infobanner" style="background: url(<?php echo $image; ?>) center center no-repeat; height:<?php echo $height ?>px; <?php if(empty($imgheight)) echo 'background-size:cover;';?>">
                            <div class="home-message" style="height:<?php echo $height ?>px;">
                                <?php if (!empty($title)) echo '<h4>'.$title.'</h4>'; ?>
                                <?php if (!empty($description)) echo '<h5>'.$description.'</h5>';?>
                            </div>
                        </div>
                    <?php if($link != '') echo '</a>'; ?>
                </div>
                <?php echo $after_widget;?>

    <?php }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['image_uri'] = strip_tags( $new_instance['image_uri'] );
        $instance['description'] = strip_tags( $new_instance['description'] );
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['link'] = $new_instance['link'];
        $instance['height'] = (int) $new_instance['height'];
        $instance['target'] = $new_instance['target'];
        $this->flush_widget_cache();
        return $instance;
    }
      function flush_widget_cache() {
        wp_cache_delete('virtue_imgmenu_widget', 'widget');
      }

  public function form($instance){ 
    $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
    $link = isset($instance['link']) ? esc_attr($instance['link']) : '';
    $height = isset($instance['height']) ? esc_attr($instance['height']) : '';
    $image_uri = isset($instance['image_uri']) ? esc_attr($instance['image_uri']) : '';
    if (isset($instance['target'])) { $target = esc_attr($instance['target']); } else {$target = 'false';}
    $target_options = array(array("slug" => "false", "name" => __('Self', 'virtue')), array("slug" => "true", "name" => __('New Window', 'virtue')));
    foreach ($target_options as $target_option) {
      if ($target == $target_option['slug']) { $selected=' selected="selected"';} else { $selected=""; }
      $target_array[] = '<option value="' . $target_option['slug'] .'"' . $selected . '>' . $target_option['name'] . '</option>';
    }
    ?>  

    <div id="virtue_imgmenu_widget<?php echo esc_attr($this->get_field_id('container')); ?>" class="kad_img_upload_widget kad_infobox_widget">
            <p>
            <img class="kad_custom_media_image" src="<?php if(!empty($instance['image_uri'])){echo $instance['image_uri'];} ?>" style="margin:0;padding:0;max-width:100px;display:block" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('image_uri'); ?>"><?php _e('Upload an image', 'virtue'); ?></label><br />
                <input type="text" class="widefat kad_custom_media_url" name="<?php echo $this->get_field_name('image_uri'); ?>" id="<?php echo $this->get_field_id('image_uri'); ?>" value="<?php echo $image_uri; ?>">
                <input type="button" value="<?php _e('Upload', 'virtue'); ?>" class="button kad_custom_media_upload" id="kad_custom_image_uploader" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('height'); ?>"><?php _e('Item Height (e.g. = 220)', 'virtue'); ?></label><br />
                <input type="number" class="widefat kad_img_widget_link" name="<?php echo $this->get_field_name('height'); ?>" id="<?php echo $this->get_field_id('height'); ?>" style="width: 70px;" value="<?php echo $height; ?>">
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
             <p>
              <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description', 'virtue'); ?></label><br />
              <textarea name="<?php echo $this->get_field_name('description'); ?>" style="min-height: 20px;" id="<?php echo $this->get_field_id('description'); ?>" class="widefat" ><?php if(!empty($instance['description'])) echo $instance['description']; ?></textarea>
            </p>
            <p>
            <label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link:', 'virtue'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php echo $link; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('target'); ?>"><?php _e('Link Target', 'virtue'); ?></label><br />
                <select id="<?php echo $this->get_field_id('target'); ?>" style="width:100%; max-width:230px;" name="<?php echo $this->get_field_name('target'); ?>"><?php echo implode('', $target_array);?></select>
            </p>

    </div>

<?php } }
