<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

// Don't duplicate me!
if (!class_exists('ReduxFramework_kad_icons')) {

    /**
     * Main ReduxFramework_icons class
     *
     * @since       1.0.0
     */
    class ReduxFramework_kad_icons {

        /**
         * Field Constructor.
         *
         * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        function __construct( $field = array(), $value ='', $parent ) {
        
            //parent::__construct( $parent->sections, $parent->args );
            $this->parent = $parent;
            $this->field = $field;
            $this->value = $value;
        
        }

        /**
         * Field Render Function.
         *
         * Takes the vars and outputs the HTML for the field in the settings
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function render() {
             $defaults = array(
                'show' => array(
                    'title' => true,
                    'description' => true,
                    'url' => true,
                ),
                'content_title' => __ ( 'Icon', 'pinnacle' )
            );

             $this->field = wp_parse_args ( $this->field, $defaults );

           echo '<div class="redux-slides-accordion" data-new-content-title="' . esc_attr ( sprintf ( __ ( 'New %s', 'virtue' ), $this->field[ 'content_title' ] ) ) . '">';

            $x = 0;

            $multi = (isset($this->field['multi']) && $this->field['multi']) ? ' multiple="multiple"' : "";

            if (isset($this->value) && is_array($this->value)) {

                $slides = $this->value;

                foreach ($slides as $slide) {
                    
                    if ( empty( $slide ) ) {
                        continue;
                    }

                    $defaults = array(
                        'icon_o' => '',
                        'title' => '',
                        'description' => '',
                        'sort' => '',
                        'target' => '',
                        'link' => '',
                        'url' => '',
                        'thumb' => '',
                        'image' => '',
                        'attachment_id' => '',
                        'height' => '',
                        'width' => '',
                        'select' => array(),
                    );
                    $slide = wp_parse_args( $slide, $defaults );

                    if (empty($slide['url']) && !empty($slide['attachment_id'])) {
                        $img = wp_get_attachment_image_src($slide['attachment_id'], 'full');
                        $slide['url'] = $img[0];
                        $slide['width'] = $img[1];
                        $slide['height'] = $img[2];
                    }

                    echo '<div class="redux-slides-accordion-group"><fieldset class="redux-field" data-id="'.$this->field['id'].'"><h3><span class="redux-slides-header">' . $slide['title'] . '</span></h3><div>';

                    $hide = '';
                    if ( empty( $slide['url'] ) ) {
                        $hide = ' hide';
                    }

                    echo '<div class="screenshot' . $hide . '">';
                    echo '<a class="of-uploaded-image" href="' . $slide['url'] . '">';
                    echo '<img class="redux-slides-image" id="image_image_id_' . $x . '" src="' . $slide['thumb'] . '" alt="" target="_blank" rel="external" />';
                    echo '</a>';
                    echo '</div>';

                    echo '<div class="redux_slides_add_remove">';

                    echo '<span class="button media_upload_button" id="add_' . $x . '">' . __('Upload Icon', 'virtue') . '</span>';

                    $hide = '';
                    if (empty($slide['url']) || $slide['url'] == '')
                        $hide = ' hide';

                    echo '<span class="button remove-image' . $hide . '" id="reset_' . $x . '" rel="' . $slide['attachment_id'] . '">' . __('Remove', 'virtue') . '</span>';

                    echo '</div>' . "\n";
                   $icon_option = array('icon-home' => 'icon-home','icon-home2' => 'icon-home2','icon-office' => 'icon-office','icon-newspaper' => 'icon-newspaper','icon-pencil' => 'icon-pencil','icon-pencil2' => 'icon-pencil2','icon-pencil3' => 'icon-pencil3','icon-pencil4' => 'icon-pencil4','icon-quill' => 'icon-quill','icon-quill2' => 'icon-quill2','icon-pen' => 'icon-pen','icon-pen2' => 'icon-pen2','icon-home3' => 'icon-home3','icon-marker' => 'icon-marker','icon-brush' => 'icon-brush','icon-palette' => 'icon-palette','icon-palette2' => 'icon-palette2','icon-droplet' => 'icon-droplet','icon-droplet2' => 'icon-droplet2','icon-paint-format' => 'icon-paint-format','icon-images' => 'icon-images','icon-image' => 'icon-image','icon-image2' => 'icon-image2','icon-images2' => 'icon-images2','icon-camera' => 'icon-camera','icon-camera2' => 'icon-camera2','icon-camera3' => 'icon-camera3', 'icon-camera4' => 'icon-camera4','icon-camera5' => 'icon-camera5','icon-music' => 'icon-music','icon-music2' => 'icon-music2','icon-piano' => 'icon-piano','icon-guitar' => 'icon-guitar','icon-headphones' => 'icon-headphones','icon-play' => 'icon-play','icon-movie' => 'icon-movie','icon-film' => 'icon-film','icon-gamepad' => 'icon-gamepad','icon-pacman' => 'icon-pacman','icon-bullhorn' => 'icon-bullhorn','icon-megaphone' => 'icon-megaphone','icon-connection' => 'icon-connection','icon-radio' => 'icon-radio','icon-mic' => 'icon-mic','icon-book' => 'icon-book','icon-books' => 'icon-books','icon-library' => 'icon-library','icon-file' => 'icon-file','icon-profile' => 'icon-profile','icon-file2' => 'icon-file2','icon-copy' => 'icon-copy','icon-paste' => 'icon-paste','icon-folder' => 'icon-folder','icon-folder-open' => 'icon-folder-open','icon-certificate' => 'icon-certificate','icon-cc' => 'icon-cc','icon-tag' => 'icon-tag','icon-tag2' => 'icon-tag2','icon-tags' => 'icon-tags','icon-cart' => 'icon-cart','icon-cart2' => 'icon-cart2','icon-cart3' => 'icon-cart3','icon-cart4' => 'icon-cart4','icon-basket' => 'icon-basket','icon-basket2' => 'icon-basket2','icon-bag' => 'icon-bag','icon-bag2' => 'icon-bag2','icon-bag3' => 'icon-bag3','icon-coin' => 'icon-coin','icon-credit' => 'icon-credit','icon-support' => 'icon-support','icon-phone' => 'icon-phone','icon-address-book' => 'icon-address-book','icon-envelope' => 'icon-envelope','icon-mail-send' => 'icon-mail-send','icon-envelope2' => 'icon-envelope2','icon-pushpin' => 'icon-pushpin','icon-location' => 'icon-location','icon-location2' => 'icon-location2','icon-compass' => 'icon-compass','icon-compass2' => 'icon-compass2','icon-map' => 'icon-map','icon-map2' => 'icon-map2','icon-direction' => 'icon-direction','icon-clock' => 'icon-clock','icon-clock2' => 'icon-clock2','icon-watch' => 'icon-watch','icon-alarm' => 'icon-alarm','icon-bell' => 'icon-bell','icon-stopwatch' => 'icon-stopwatch','icon-calendar' => 'icon-calendar','icon-calendar2' => 'icon-calendar2','icon-print' => 'icon-print','icon-mouse' => 'icon-mouse','icon-screen' => 'icon-screen','icon-screen2' => 'icon-screen2','icon-laptop' => 'icon-laptop','icon-mobile' => 'icon-mobile','icon-mobile2' => 'icon-mobile2','icon-tablet' => 'icon-tablet','icon-cabinet' => 'icon-cabinet','icon-drawer' => 'icon-drawer','icon-drawer2' => 'icon-drawer2','icon-box' => 'icon-box','icon-box-add' => 'icon-box-add','icon-box-remove' => 'icon-box-remove','icon-cd' => 'icon-cd','icon-storage' => 'icon-storage','icon-undo' => 'icon-undo','icon-redo' => 'icon-redo','icon-rotate' => 'icon-rotate','icon-rotate2' => 'icon-rotate2','icon-undo2' => 'icon-undo2','icon-redo2' => 'icon-redo2','icon-forward' => 'icon-forward','icon-reply' => 'icon-reply','icon-bubble' => 'icon-bubble','icon-bubbles' => 'icon-bubbles','icon-bubbles2' => 'icon-bubbles2','icon-bubbles3' => 'icon-bubbles3','icon-user' => 'icon-user','icon-users' => 'icon-users','icon-users2' => 'icon-users2','icon-users3' => 'icon-users3','icon-vcard' => 'icon-vcard','icon-tshirt' => 'icon-tshirt','icon-bubble-notification' => 'icon-bubble-notification','icon-bubble2' => 'icon-bubble2','icon-bubble3' => 'icon-bubble3','icon-quotes-left' => 'icon-quotes-left','icon-quotes-right' => 'icon-quotes-right','icon-busy' => 'icon-busy','icon-spinner' => 'icon-spinner','icon-spinner2' => 'icon-spinner2','icon-search' => 'icon-search','icon-search2' => 'icon-search2','icon-zoom-in' => 'icon-zoom-in','icon-zoom-out' => 'icon-zoom-out','icon-expand' => 'icon-expand','icon-contract' => 'icon-contract','icon-key' => 'icon-key','icon-key2' => 'icon-key2','icon-keyhole' => 'icon-keyhole','icon-lock' => 'icon-lock','icon-wrench' => 'icon-wrench','icon-settings' => 'icon-settings','icon-equalizer' => 'icon-equalizer','icon-equalizer2' => 'icon-equalizer2','icon-equalizer3' => 'icon-equalizer3','icon-cog' => 'icon-cog','icon-cogs' => 'icon-cogs','icon-tools' => 'icon-tools','icon-screwdriver' => 'icon-screwdriver','icon-wand' => 'icon-wand','icon-aid' => 'icon-aid','icon-bug' => 'icon-bug','icon-inject' => 'icon-inject','icon-construction' => 'icon-construction','icon-pie' => 'icon-pie','icon-stats' => 'icon-stats','icon-stats2' => 'icon-stats2','icon-stats3' => 'icon-stats3','icon-bars' => 'icon-bars','icon-bars2' => 'icon-bars2','icon-bars3' => 'icon-bars3','icon-gift' => 'icon-gift','icon-balloon' => 'icon-balloon','icon-stats-up' => 'icon-stats-up','icon-gift2' => 'icon-gift2','icon-medal' => 'icon-medal','icon-crown' => 'icon-crown','icon-trophy' => 'icon-trophy','icon-glass' => 'icon-glass','icon-glass2' => 'icon-glass2','icon-bottle' => 'icon-bottle','icon-food' => 'icon-food','icon-food2' => 'icon-food2','icon-cup' => 'icon-cup','icon-leaf' => 'icon-leaf','icon-leaf2' => 'icon-leaf2','icon-apple-fruit' => 'icon-apple-fruit','icon-tree' => 'icon-tree','icon-paw' => 'icon-paw','icon-steps' => 'icon-steps','icon-flower' => 'icon-flower','icon-rocket' => 'icon-rocket','icon-meter' => 'icon-meter','icon-meter-fast' => 'icon-meter-fast','icon-mug' => 'icon-mug','icon-dashboard' => 'icon-dashboard','icon-hammer' => 'icon-hammer','icon-fire' => 'icon-fire','icon-bomb' => 'icon-bomb','icon-lab' => 'icon-lab','icon-atom' => 'icon-atom','icon-magnet' => 'icon-magnet','icon-dumbbell' => 'icon-dumbbell','icon-lamp' => 'icon-lamp','icon-lamp2' => 'icon-lamp2','icon-lamp3' => 'icon-lamp3','icon-lamp4' => 'icon-lamp4','icon-remove' => 'icon-remove','icon-remove2' => 'icon-remove2','icon-remove3' => 'icon-remove3','icon-briefcase' => 'icon-briefcase','icon-briefcase2' => 'icon-briefcase2','icon-briefcase3' => 'icon-briefcase3','icon-airplane' => 'icon-airplane','icon-airplane2' => 'icon-airplane2','icon-paper-plane' => 'icon-paper-plane','icon-car' => 'icon-car','icon-gas-pump' => 'icon-gas-pump','icon-bus' => 'icon-bus','icon-truck' => 'icon-truck','icon-bike' => 'icon-bike','icon-train' => 'icon-train','icon-boat' => 'icon-boat','icon-cube' => 'icon-cube','icon-cube4' => 'icon-cube4','icon-cylinder' => 'icon-cylinder','icon-puzzle' => 'icon-puzzle','icon-puzzle2' => 'icon-puzzle2','icon-glasses' => 'icon-glasses','icon-glasses2' => 'icon-glasses2','icon-sun-glasses' => 'icon-sun-glasses','icon-accessibility' => 'icon-accessibility','icon-accessibility2' => 'icon-accessibility2','icon-brain' => 'icon-brain','icon-target' => 'icon-target','icon-shield' => 'icon-shield','icon-shield2' => 'icon-shield2','icon-soccer' => 'icon-soccer','icon-football' => 'icon-football','icon-baseball' => 'icon-baseball','icon-basketball' => 'icon-basketball','icon-golf' => 'icon-golf','icon-hockey' => 'icon-hockey','icon-racing' => 'icon-racing','icon-eight-ball' => 'icon-eight-ball','icon-bowling-ball' => 'icon-bowling-ball','icon-bowling' => 'icon-bowling','icon-lightning' => 'icon-lightning','icon-power' => 'icon-power','icon-switch' => 'icon-switch','icon-power-cord' => 'icon-power-cord','icon-clipboard' => 'icon-clipboard','icon-signup' => 'icon-signup','icon-clipboard2' => 'icon-clipboard2','icon-clipboard3' => 'icon-clipboard3','icon-grid' => 'icon-grid','icon-grid2' => 'icon-grid2','icon-grid3' => 'icon-grid3','icon-grid4' => 'icon-grid4','icon-grid5' => 'icon-grid5','icon-menu' => 'icon-menu','icon-menu2' => 'icon-menu2','icon-menu3' => 'icon-menu3','icon-menu4' => 'icon-menu4','icon-menu5' => 'icon-menu5','icon-menu6' => 'icon-menu6','icon-cloud' => 'icon-cloud','icon-download' => 'icon-download','icon-upload' => 'icon-upload','icon-globe' => 'icon-globe','icon-earth' => 'icon-earth','icon-network' => 'icon-network','icon-link' => 'icon-link','icon-link2' => 'icon-link2','icon-link3' => 'icon-link3','icon-cloud-download' => 'icon-cloud-download','icon-cloud-upload' => 'icon-cloud-upload','icon-link4' => 'icon-link4','icon-anchor' => 'icon-anchor','icon-flag' => 'icon-flag','icon-flag2' => 'icon-flag2','icon-flag3' => 'icon-flag3','icon-attachment' => 'icon-attachment','icon-attachment2' => 'icon-attachment2','icon-eye' => 'icon-eye','icon-bookmark' => 'icon-bookmark','icon-bookmarks' => 'icon-bookmarks','icon-spotlight' => 'icon-spotlight','icon-temperature' => 'icon-temperature','icon-weather-lightning' => 'icon-weather-lightning','icon-weather-rain' => 'icon-weather-rain','icon-weather-snow' => 'icon-weather-snow','icon-windy' => 'icon-windy','icon-snowflake' => 'icon-snowflake','icon-sun' => 'icon-sun','icon-eye-blocked' => 'icon-eye-blocked','icon-moon' => 'icon-moon','icon-bed' => 'icon-bed','icon-star' => 'icon-star','icon-star2' => 'icon-star2','icon-star3' => 'icon-star3','icon-heart' => 'icon-heart','icon-heart2' => 'icon-heart2','icon-heart-broken' => 'icon-heart-broken','icon-thumbs-up' => 'icon-thumbs-up','icon-thumbs-down' => 'icon-thumbs-down','icon-man' => 'icon-man','icon-woman' => 'icon-woman','icon-people' => 'icon-people','icon-happy' => 'icon-happy','icon-happy2' => 'icon-happy2','icon-smiley' => 'icon-smiley','icon-smiley2' => 'icon-smiley2','icon-tongue' => 'icon-tongue','icon-tongue2' => 'icon-tongue2','icon-sad' => 'icon-sad','icon-sad2' => 'icon-sad2','icon-wink' => 'icon-wink','icon-wink2' => 'icon-wink2','icon-grin' => 'icon-grin','icon-grin2' => 'icon-grin2','icon-cool' => 'icon-cool','icon-cool2' => 'icon-cool2','icon-shocked' => 'icon-shocked','icon-shocked2' => 'icon-shocked2','icon-neutral' => 'icon-neutral','icon-neutral2' => 'icon-neutral2','icon-hand' => 'icon-hand','icon-stack-picture' => 'icon-stack-picture','icon-stack-list' => 'icon-stack-list','icon-stack-clubs' => 'icon-stack-clubs','icon-stack-spades' => 'icon-stack-spades','icon-stack-hearts' => 'icon-stack-hearts','icon-stack-diamonds' => 'icon-stack-diamonds','icon-stack-user' => 'icon-stack-user','icon-stack-music' => 'icon-stack-music','icon-angry' => 'icon-angry','icon-angry2' => 'icon-angry2','icon-evil' => 'icon-evil','icon-evil2' => 'icon-evil2','icon-confused' => 'icon-confused','icon-confused2' => 'icon-confused2','icon-wondering' => 'icon-wondering','icon-wondering2' => 'icon-wondering2','icon-cursor' => 'icon-cursor','icon-move' => 'icon-move','icon-warning' => 'icon-warning','icon-warning2' => 'icon-warning2','icon-notification' => 'icon-notification','icon-notification2' => 'icon-notification2','icon-question' => 'icon-question','icon-question2' => 'icon-question2','icon-question3' => 'icon-question3','icon-plus-circle' => 'icon-plus-circle','icon-plus-circle2' => 'icon-plus-circle2','icon-minus-circle' => 'icon-minus-circle','icon-minus-circle2' => 'icon-minus-circle2','icon-info' => 'icon-info','icon-info2' => 'icon-info2','icon-cancel-circle' => 'icon-cancel-circle','icon-cancel-circle2' => 'icon-cancel-circle2','icon-checkmark-circle' => 'icon-checkmark-circle','icon-checkmark-circle2' => 'icon-checkmark-circle2','icon-close' => 'icon-close','icon-close2' => 'icon-close2','icon-checkmark' => 'icon-checkmark','icon-checkmark2' => 'icon-checkmark2','icon-checkmark3' => 'icon-checkmark3','icon-checkmark4' => 'icon-checkmark4','icon-minus' => 'icon-minus','icon-plus' => 'icon-plus','icon-bed2' => 'icon-bed2','icon-fan' => 'icon-fan','icon-umbrella' => 'icon-umbrella','icon-play2' => 'icon-play2','icon-pause' => 'icon-pause','icon-stop' => 'icon-stop','icon-backward' => 'icon-backward','icon-forward2' => 'icon-forward2','icon-play3' => 'icon-play3','icon-pause2' => 'icon-pause2','icon-stop2' => 'icon-stop2','icon-backward2' => 'icon-backward2','icon-forward3' => 'icon-forward3','icon-first' => 'icon-first','icon-last' => 'icon-last','icon-previous' => 'icon-previous','icon-next' => 'icon-next','icon-eject' => 'icon-eject','icon-volume-high' => 'icon-volume-high','icon-volume-medium' => 'icon-volume-medium','icon-volume-low' => 'icon-volume-low','icon-volume-mute' => 'icon-volume-mute','icon-arrow-up' => 'icon-arrow-up','icon-arrow-right' => 'icon-arrow-right','icon-arrow-down' => 'icon-arrow-down','icon-arrow-left' => 'icon-arrow-left','icon-arrow-up2' => 'icon-arrow-up2','icon-arrow-right2' => 'icon-arrow-right2','icon-arrow-down2' => 'icon-arrow-down2','icon-arrow-left2' => 'icon-arrow-left2','icon-arrow-up-left' => 'icon-arrow-up-left','icon-arrow-up3' => 'icon-arrow-up3','icon-arrow-up-right' => 'icon-arrow-up-right','icon-arrow-right3' => 'icon-arrow-right3','icon-arrow-down-right' => 'icon-arrow-down-right','icon-arrow-down3' => 'icon-arrow-down3','icon-arrow-down-left' => 'icon-arrow-down-left','icon-arrow-left3' => 'icon-arrow-left3','icon-arrow-up4' => 'icon-arrow-up4','icon-arrow-right4' => 'icon-arrow-right4','icon-arrow-down4' => 'icon-arrow-down4','icon-arrow-left4' => 'icon-arrow-left4','icon-arrow-up5' => 'icon-arrow-up5','icon-arrow-right5' => 'icon-arrow-right5','icon-arrow-bottom' => 'icon-arrow-bottom','icon-arrow-left5' => 'icon-arrow-left5','icon-arrow-up6' => 'icon-arrow-up6','icon-arrow-right6' => 'icon-arrow-right6','icon-arrow-down5' => 'icon-arrow-down5','icon-arrow-left6' => 'icon-arrow-left6','icon-transmission' => 'icon-transmission','icon-sort' => 'icon-sort','icon-loop' => 'icon-loop','icon-loop2' => 'icon-loop2','icon-checkbox-checked' => 'icon-checkbox-checked','icon-checkbox' => 'icon-checkbox','icon-checkbox-checked2' => 'icon-checkbox-checked2','icon-crop' => 'icon-crop','icon-vector' => 'icon-vector','icon-rulers' => 'icon-rulers','icon-scissors' => 'icon-scissors','icon-filter' => 'icon-filter','icon-font' => 'icon-font','icon-font-size' => 'icon-font-size','icon-text-height' => 'icon-text-height','icon-text-width' => 'icon-text-width','icon-height' => 'icon-height','icon-width' => 'icon-width','icon-page-break' => 'icon-page-break','icon-page-break2' => 'icon-page-break2','icon-new-tab' => 'icon-new-tab','icon-new-tab2' => 'icon-new-tab2','icon-embed' => 'icon-embed','icon-code' => 'icon-code','icon-mail' => 'icon-mail','icon-mail2' => 'icon-mail2','icon-mail3' => 'icon-mail3','icon-table' => 'icon-table','icon-google-plus' => 'icon-google-plus','icon-google-plus2' => 'icon-google-plus2','icon-google-plus3' => 'icon-google-plus3','icon-facebook' => 'icon-facebook','icon-facebook2' => 'icon-facebook2','icon-facebook3' => 'icon-facebook3','icon-instagram' => 'icon-instagram','icon-twitter' => 'icon-twitter','icon-twitter2' => 'icon-twitter2','icon-feed' => 'icon-feed','icon-feed2' => 'icon-feed2','icon-youtube' => 'icon-youtube','icon-youtube2' => 'icon-youtube2','icon-vimeo' => 'icon-vimeo','icon-vimeo2' => 'icon-vimeo2','icon-lanyrd' => 'icon-lanyrd','icon-flickr' => 'icon-flickr','icon-flickr2' => 'icon-flickr2','icon-picassa' => 'icon-picassa','icon-picassa2' => 'icon-picassa2','icon-dribbble' => 'icon-dribbble','icon-dribbble2' => 'icon-dribbble2','icon-forrst' => 'icon-forrst','icon-forrst2' => 'icon-forrst2','icon-deviantart' => 'icon-deviantart','icon-deviantart2' => 'icon-deviantart2','icon-github' => 'icon-github','icon-github2' => 'icon-github2','icon-github3' => 'icon-github3','icon-wordpress' => 'icon-wordpress','icon-blogger' => 'icon-blogger','icon-blogger2' => 'icon-blogger2','icon-tumblr' => 'icon-tumblr','icon-tumblr2' => 'icon-tumblr2','icon-apple' => 'icon-apple','icon-android' => 'icon-android','icon-windows' => 'icon-windows','icon-windows8' => 'icon-windows8','icon-skype' => 'icon-skype','icon-linkedin' => 'icon-linkedin','icon-lastfm' => 'icon-lastfm','icon-lastfm2' => 'icon-lastfm2','icon-stumbleupon' => 'icon-stumbleupon','icon-stumbleupon2' => 'icon-stumbleupon2','icon-pinterest' => 'icon-pinterest','icon-pinterest2' => 'icon-pinterest2','icon-xing' => 'icon-xing','icon-paypal' => 'icon-paypal','icon-html5' => 'icon-html5','icon-css3' => 'icon-css3','icon-file-zip' => 'icon-file-zip','icon-file-xml' => 'icon-file-xml','icon-file-pdf' => 'icon-file-pdf','icon-file-word' => 'icon-file-word','icon-file-excel' => 'icon-file-excel','icon-king' => 'icon-king','icon-queen' => 'icon-queen','icon-rock' => 'icon-rock','icon-knight' => 'icon-knight','icon-github4' => 'icon-github4','icon-steam' => 'icon-steam','icon-steam2' => 'icon-steam2','icon-yahoo' => 'icon-yahoo','icon-flickr3' => 'icon-flickr3','icon-google-drive' => 'icon-google-drive','icon-chrome' => 'icon-chrome','icon-firefox' => 'icon-firefox','icon-IE' => 'icon-IE','icon-opera' => 'icon-opera','icon-safari' => 'icon-safari','icon-IcoMoon' => 'icon-IcoMoon','icon-html52' => 'icon-html52', 'icon-vk' => 'icon-vk', 'icon-viadeo' => 'icon-viadeo',);
                   
                        $placeholder = (isset($this->field['placeholder']['icon_o'])) ? esc_attr($this->field['placeholder']['icon_o']) : __( 'Select an Icon', 'virtue' );
                        if ( isset( $this->field['select2'] ) ) { // if there are any let's pass them to js
                            $select2_params = json_encode( esc_attr( $this->field['select2'] ) );
                            $select2_params = htmlspecialchars( $select2_params , ENT_QUOTES);
                            echo '<input type="hidden" class="select2_params" value="'. $select2_params .'">';
                        }

                        echo '<select id="'.$this->field['id'].'-icon_o" data-placeholder="'.$placeholder.'" name="' . $this->field['name'] . '[' . $x . '][icon_o]" class="redux-select-item font-icons '.$this->field['class'].'" rows="6" style="width:93%;">';
                            echo '<option></option>';
                            foreach($icon_option as $k => $v){
                                if (is_array($slide['icon_o'])) {
                                    $selected = (is_array($slide['icon_o']) && in_array($k, $slide['icon_o']))?' selected="selected"':'';                   
                                } else {
                                    $selected = selected($slide['icon_o'], $k, false);
                                }
                                echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>';
                            }//foreach
                        echo '</select>'; 
   
                    echo '<ul id="' . $this->field['id'] . '-ul" class="redux-slides-list">';
                    echo '<li><input type="hidden" id="' . $this->field['id'] . '-url_' . $x . '" name="' . $this->field['name'] . '[' . $x . '][url]" value="' . esc_attr($slide['url']) . '" class="full-text upload" placeholder="'.__('URL', 'virtue').'" /></li>';
                    echo '<li><input type="text" id="' . $this->field['id'] . '-title_' . $x . '" name="' . $this->field['name'] . '[' . $x . '][title]" value="' . esc_attr($slide['title']) . '" placeholder="'.__('Title', 'virtue').'" class="full-text slide-title" /></li>';
                    echo '<li><textarea name="' . $this->field['name'] . '[' . $x . '][description]" id="' . $this->field['id'] . '-description_' . $x . '" placeholder="'.__('Description', 'virtue').'" class="large-text" rows="6">' . esc_attr($slide['description']) . '</textarea></li>';
                    echo '<li><input type="text" id="' . $this->field['id'] . '-link_' . $x . '" name="' . $this->field['name'] . '[' . $x . '][link]" value="' . esc_attr($slide['link']) . '" placeholder="'.__('Icon Link', 'virtue').'" class="full-text" /></li>';
                
                    echo '<li><label for="'. $this->field['id'] .  '-target_' . $x . '" class="icon-link-target">';
                    echo '<input type="checkbox" class="checkbox-slide-target" id="' . $this->field['id'] . '-target_' . $x . '" value="1" ' . checked(  $slide['target'], '1', false ) . ' name="' . $this->field['name'] . '[' . $x . '][target]" />';
                    echo ' '.__('Open Link in New Tab/Window', 'virtue'). '</label></li>';

                    echo '<li><input type="hidden" class="slide-sort" name="' . $this->field['name'] . '[' . $x . '][sort]" id="' . $this->field['id'] . '-sort_' . $x . '" value="' . $slide['sort'] . '" />';
                    echo '<li><input type="hidden" class="upload-id" name="' . $this->field['name'] . '[' . $x . '][attachment_id]" id="' . $this->field['id'] . '-image_id_' . $x . '" value="' . $slide['attachment_id'] . '" />';
                    echo '<input type="hidden" class="upload-thumbnail" name="' . $this->field['name'] . '[' . $x . '][thumb]" id="' . $this->field['id'] . '-thumb_url_' . $x . '" value="' . $slide['thumb'] . '" readonly="readonly" />';
                    echo '<input type="hidden" class="upload" name="' . $this->field['name'] . '[' . $x . '][image]" id="' . $this->field['id'] . '-image_url_' . $x . '" value="' . $slide['image'] . '" readonly="readonly" />';
                    echo '<input type="hidden" class="upload-height" name="' . $this->field['name'] . '[' . $x . '][height]" id="' . $this->field['id'] . '-image_height_' . $x . '" value="' . $slide['height'] . '" />';
                    echo '<input type="hidden" class="upload-width" name="' . $this->field['name'] . '[' . $x . '][width]" id="' . $this->field['id'] . '-image_width_' . $x . '" value="' . $slide['width'] . '" /></li>';


                    echo '<li><a href="javascript:void(0);" class="button deletion redux-slides-remove">' . __('Delete Icon', 'virtue') . '</a></li>';
                    echo '</ul></div></fieldset></div>';
                    $x++;
                
                }
            }

            if ($x == 0) {
                echo '<div class="redux-slides-accordion-group"><fieldset class="redux-field" data-id="'.$this->field['id'].'"><h3><span class="redux-slides-header">New Icon</span></h3><div>';

                $hide = ' hide';

                echo '<div class="screenshot' . $hide . '">';
                echo '<a class="of-uploaded-image" href="">';
                echo '<img class="redux-slides-image" id="image_image_id_' . $x . '" src="" alt="" target="_blank" rel="external" />';
                echo '</a>';
                echo '</div>';

                //Upload controls DIV
                echo '<div class="upload_button_div">';

                //If the user has WP3.5+ show upload/remove button
                echo '<span class="button media_upload_button" id="add_' . $x . '">' . __('Upload Icon', 'virtue') . '</span>';

                echo '<span class="button remove-image' . $hide . '" id="reset_' . $x . '" rel="' . $this->parent->args['opt_name'] . '[' . $this->field['id'] . '][attachment_id]">' . __('Remove', 'virtue') . '</span>';

                echo '</div>' . "\n";
                    $icon_option = array('icon-home' => 'icon-home','icon-home2' => 'icon-home2','icon-office' => 'icon-office','icon-newspaper' => 'icon-newspaper','icon-pencil' => 'icon-pencil','icon-pencil2' => 'icon-pencil2','icon-pencil3' => 'icon-pencil3','icon-pencil4' => 'icon-pencil4','icon-quill' => 'icon-quill','icon-quill2' => 'icon-quill2','icon-pen' => 'icon-pen','icon-pen2' => 'icon-pen2','icon-home3' => 'icon-home3','icon-marker' => 'icon-marker','icon-brush' => 'icon-brush','icon-palette' => 'icon-palette','icon-palette2' => 'icon-palette2','icon-droplet' => 'icon-droplet','icon-droplet2' => 'icon-droplet2','icon-paint-format' => 'icon-paint-format','icon-images' => 'icon-images','icon-image' => 'icon-image','icon-image2' => 'icon-image2','icon-images2' => 'icon-images2','icon-camera' => 'icon-camera','icon-camera2' => 'icon-camera2','icon-camera3' => 'icon-camera3', 'icon-camera4' => 'icon-camera4','icon-camera5' => 'icon-camera5','icon-music' => 'icon-music','icon-music2' => 'icon-music2','icon-piano' => 'icon-piano','icon-guitar' => 'icon-guitar','icon-headphones' => 'icon-headphones','icon-play' => 'icon-play','icon-movie' => 'icon-movie','icon-film' => 'icon-film','icon-gamepad' => 'icon-gamepad','icon-pacman' => 'icon-pacman','icon-bullhorn' => 'icon-bullhorn','icon-megaphone' => 'icon-megaphone','icon-connection' => 'icon-connection','icon-radio' => 'icon-radio','icon-mic' => 'icon-mic','icon-book' => 'icon-book','icon-books' => 'icon-books','icon-library' => 'icon-library','icon-file' => 'icon-file','icon-profile' => 'icon-profile','icon-file2' => 'icon-file2','icon-copy' => 'icon-copy','icon-paste' => 'icon-paste','icon-folder' => 'icon-folder','icon-folder-open' => 'icon-folder-open','icon-certificate' => 'icon-certificate','icon-cc' => 'icon-cc','icon-tag' => 'icon-tag','icon-tag2' => 'icon-tag2','icon-tags' => 'icon-tags','icon-cart' => 'icon-cart','icon-cart2' => 'icon-cart2','icon-cart3' => 'icon-cart3','icon-cart4' => 'icon-cart4','icon-basket' => 'icon-basket','icon-basket2' => 'icon-basket2','icon-bag' => 'icon-bag','icon-bag2' => 'icon-bag2','icon-bag3' => 'icon-bag3','icon-coin' => 'icon-coin','icon-credit' => 'icon-credit','icon-support' => 'icon-support','icon-phone' => 'icon-phone','icon-address-book' => 'icon-address-book','icon-envelope' => 'icon-envelope','icon-mail-send' => 'icon-mail-send','icon-envelope2' => 'icon-envelope2','icon-pushpin' => 'icon-pushpin','icon-location' => 'icon-location','icon-location2' => 'icon-location2','icon-compass' => 'icon-compass','icon-compass2' => 'icon-compass2','icon-map' => 'icon-map','icon-map2' => 'icon-map2','icon-direction' => 'icon-direction','icon-clock' => 'icon-clock','icon-clock2' => 'icon-clock2','icon-watch' => 'icon-watch','icon-alarm' => 'icon-alarm','icon-bell' => 'icon-bell','icon-stopwatch' => 'icon-stopwatch','icon-calendar' => 'icon-calendar','icon-calendar2' => 'icon-calendar2','icon-print' => 'icon-print','icon-mouse' => 'icon-mouse','icon-screen' => 'icon-screen','icon-screen2' => 'icon-screen2','icon-laptop' => 'icon-laptop','icon-mobile' => 'icon-mobile','icon-mobile2' => 'icon-mobile2','icon-tablet' => 'icon-tablet','icon-cabinet' => 'icon-cabinet','icon-drawer' => 'icon-drawer','icon-drawer2' => 'icon-drawer2','icon-box' => 'icon-box','icon-box-add' => 'icon-box-add','icon-box-remove' => 'icon-box-remove','icon-cd' => 'icon-cd','icon-storage' => 'icon-storage','icon-undo' => 'icon-undo','icon-redo' => 'icon-redo','icon-rotate' => 'icon-rotate','icon-rotate2' => 'icon-rotate2','icon-undo2' => 'icon-undo2','icon-redo2' => 'icon-redo2','icon-forward' => 'icon-forward','icon-reply' => 'icon-reply','icon-bubble' => 'icon-bubble','icon-bubbles' => 'icon-bubbles','icon-bubbles2' => 'icon-bubbles2','icon-bubbles3' => 'icon-bubbles3','icon-user' => 'icon-user','icon-users' => 'icon-users','icon-users2' => 'icon-users2','icon-users3' => 'icon-users3','icon-vcard' => 'icon-vcard','icon-tshirt' => 'icon-tshirt','icon-bubble-notification' => 'icon-bubble-notification','icon-bubble2' => 'icon-bubble2','icon-bubble3' => 'icon-bubble3','icon-quotes-left' => 'icon-quotes-left','icon-quotes-right' => 'icon-quotes-right','icon-busy' => 'icon-busy','icon-spinner' => 'icon-spinner','icon-spinner2' => 'icon-spinner2','icon-search' => 'icon-search','icon-search2' => 'icon-search2','icon-zoom-in' => 'icon-zoom-in','icon-zoom-out' => 'icon-zoom-out','icon-expand' => 'icon-expand','icon-contract' => 'icon-contract','icon-key' => 'icon-key','icon-key2' => 'icon-key2','icon-keyhole' => 'icon-keyhole','icon-lock' => 'icon-lock','icon-wrench' => 'icon-wrench','icon-settings' => 'icon-settings','icon-equalizer' => 'icon-equalizer','icon-equalizer2' => 'icon-equalizer2','icon-equalizer3' => 'icon-equalizer3','icon-cog' => 'icon-cog','icon-cogs' => 'icon-cogs','icon-tools' => 'icon-tools','icon-screwdriver' => 'icon-screwdriver','icon-wand' => 'icon-wand','icon-aid' => 'icon-aid','icon-bug' => 'icon-bug','icon-inject' => 'icon-inject','icon-construction' => 'icon-construction','icon-pie' => 'icon-pie','icon-stats' => 'icon-stats','icon-stats2' => 'icon-stats2','icon-stats3' => 'icon-stats3','icon-bars' => 'icon-bars','icon-bars2' => 'icon-bars2','icon-bars3' => 'icon-bars3','icon-gift' => 'icon-gift','icon-balloon' => 'icon-balloon','icon-stats-up' => 'icon-stats-up','icon-gift2' => 'icon-gift2','icon-medal' => 'icon-medal','icon-crown' => 'icon-crown','icon-trophy' => 'icon-trophy','icon-glass' => 'icon-glass','icon-glass2' => 'icon-glass2','icon-bottle' => 'icon-bottle','icon-food' => 'icon-food','icon-food2' => 'icon-food2','icon-cup' => 'icon-cup','icon-leaf' => 'icon-leaf','icon-leaf2' => 'icon-leaf2','icon-apple-fruit' => 'icon-apple-fruit','icon-tree' => 'icon-tree','icon-paw' => 'icon-paw','icon-steps' => 'icon-steps','icon-flower' => 'icon-flower','icon-rocket' => 'icon-rocket','icon-meter' => 'icon-meter','icon-meter-fast' => 'icon-meter-fast','icon-mug' => 'icon-mug','icon-dashboard' => 'icon-dashboard','icon-hammer' => 'icon-hammer','icon-fire' => 'icon-fire','icon-bomb' => 'icon-bomb','icon-lab' => 'icon-lab','icon-atom' => 'icon-atom','icon-magnet' => 'icon-magnet','icon-dumbbell' => 'icon-dumbbell','icon-lamp' => 'icon-lamp','icon-lamp2' => 'icon-lamp2','icon-lamp3' => 'icon-lamp3','icon-lamp4' => 'icon-lamp4','icon-remove' => 'icon-remove','icon-remove2' => 'icon-remove2','icon-remove3' => 'icon-remove3','icon-briefcase' => 'icon-briefcase','icon-briefcase2' => 'icon-briefcase2','icon-briefcase3' => 'icon-briefcase3','icon-airplane' => 'icon-airplane','icon-airplane2' => 'icon-airplane2','icon-paper-plane' => 'icon-paper-plane','icon-car' => 'icon-car','icon-gas-pump' => 'icon-gas-pump','icon-bus' => 'icon-bus','icon-truck' => 'icon-truck','icon-bike' => 'icon-bike','icon-train' => 'icon-train','icon-boat' => 'icon-boat','icon-cube' => 'icon-cube','icon-cube4' => 'icon-cube4','icon-cylinder' => 'icon-cylinder','icon-puzzle' => 'icon-puzzle','icon-puzzle2' => 'icon-puzzle2','icon-glasses' => 'icon-glasses','icon-glasses2' => 'icon-glasses2','icon-sun-glasses' => 'icon-sun-glasses','icon-accessibility' => 'icon-accessibility','icon-accessibility2' => 'icon-accessibility2','icon-brain' => 'icon-brain','icon-target' => 'icon-target','icon-shield' => 'icon-shield','icon-shield2' => 'icon-shield2','icon-soccer' => 'icon-soccer','icon-football' => 'icon-football','icon-baseball' => 'icon-baseball','icon-basketball' => 'icon-basketball','icon-golf' => 'icon-golf','icon-hockey' => 'icon-hockey','icon-racing' => 'icon-racing','icon-eight-ball' => 'icon-eight-ball','icon-bowling-ball' => 'icon-bowling-ball','icon-bowling' => 'icon-bowling','icon-lightning' => 'icon-lightning','icon-power' => 'icon-power','icon-switch' => 'icon-switch','icon-power-cord' => 'icon-power-cord','icon-clipboard' => 'icon-clipboard','icon-signup' => 'icon-signup','icon-clipboard2' => 'icon-clipboard2','icon-clipboard3' => 'icon-clipboard3','icon-grid' => 'icon-grid','icon-grid2' => 'icon-grid2','icon-grid3' => 'icon-grid3','icon-grid4' => 'icon-grid4','icon-grid5' => 'icon-grid5','icon-menu' => 'icon-menu','icon-menu2' => 'icon-menu2','icon-menu3' => 'icon-menu3','icon-menu4' => 'icon-menu4','icon-menu5' => 'icon-menu5','icon-menu6' => 'icon-menu6','icon-cloud' => 'icon-cloud','icon-download' => 'icon-download','icon-upload' => 'icon-upload','icon-globe' => 'icon-globe','icon-earth' => 'icon-earth','icon-network' => 'icon-network','icon-link' => 'icon-link','icon-link2' => 'icon-link2','icon-link3' => 'icon-link3','icon-cloud-download' => 'icon-cloud-download','icon-cloud-upload' => 'icon-cloud-upload','icon-link4' => 'icon-link4','icon-anchor' => 'icon-anchor','icon-flag' => 'icon-flag','icon-flag2' => 'icon-flag2','icon-flag3' => 'icon-flag3','icon-attachment' => 'icon-attachment','icon-attachment2' => 'icon-attachment2','icon-eye' => 'icon-eye','icon-bookmark' => 'icon-bookmark','icon-bookmarks' => 'icon-bookmarks','icon-spotlight' => 'icon-spotlight','icon-temperature' => 'icon-temperature','icon-weather-lightning' => 'icon-weather-lightning','icon-weather-rain' => 'icon-weather-rain','icon-weather-snow' => 'icon-weather-snow','icon-windy' => 'icon-windy','icon-snowflake' => 'icon-snowflake','icon-sun' => 'icon-sun','icon-eye-blocked' => 'icon-eye-blocked','icon-moon' => 'icon-moon','icon-bed' => 'icon-bed','icon-star' => 'icon-star','icon-star2' => 'icon-star2','icon-star3' => 'icon-star3','icon-heart' => 'icon-heart','icon-heart2' => 'icon-heart2','icon-heart-broken' => 'icon-heart-broken','icon-thumbs-up' => 'icon-thumbs-up','icon-thumbs-down' => 'icon-thumbs-down','icon-man' => 'icon-man','icon-woman' => 'icon-woman','icon-people' => 'icon-people','icon-happy' => 'icon-happy','icon-happy2' => 'icon-happy2','icon-smiley' => 'icon-smiley','icon-smiley2' => 'icon-smiley2','icon-tongue' => 'icon-tongue','icon-tongue2' => 'icon-tongue2','icon-sad' => 'icon-sad','icon-sad2' => 'icon-sad2','icon-wink' => 'icon-wink','icon-wink2' => 'icon-wink2','icon-grin' => 'icon-grin','icon-grin2' => 'icon-grin2','icon-cool' => 'icon-cool','icon-cool2' => 'icon-cool2','icon-shocked' => 'icon-shocked','icon-shocked2' => 'icon-shocked2','icon-neutral' => 'icon-neutral','icon-neutral2' => 'icon-neutral2','icon-hand' => 'icon-hand','icon-stack-picture' => 'icon-stack-picture','icon-stack-list' => 'icon-stack-list','icon-stack-clubs' => 'icon-stack-clubs','icon-stack-spades' => 'icon-stack-spades','icon-stack-hearts' => 'icon-stack-hearts','icon-stack-diamonds' => 'icon-stack-diamonds','icon-stack-user' => 'icon-stack-user','icon-stack-music' => 'icon-stack-music','icon-angry' => 'icon-angry','icon-angry2' => 'icon-angry2','icon-evil' => 'icon-evil','icon-evil2' => 'icon-evil2','icon-confused' => 'icon-confused','icon-confused2' => 'icon-confused2','icon-wondering' => 'icon-wondering','icon-wondering2' => 'icon-wondering2','icon-cursor' => 'icon-cursor','icon-move' => 'icon-move','icon-warning' => 'icon-warning','icon-warning2' => 'icon-warning2','icon-notification' => 'icon-notification','icon-notification2' => 'icon-notification2','icon-question' => 'icon-question','icon-question2' => 'icon-question2','icon-question3' => 'icon-question3','icon-plus-circle' => 'icon-plus-circle','icon-plus-circle2' => 'icon-plus-circle2','icon-minus-circle' => 'icon-minus-circle','icon-minus-circle2' => 'icon-minus-circle2','icon-info' => 'icon-info','icon-info2' => 'icon-info2','icon-cancel-circle' => 'icon-cancel-circle','icon-cancel-circle2' => 'icon-cancel-circle2','icon-checkmark-circle' => 'icon-checkmark-circle','icon-checkmark-circle2' => 'icon-checkmark-circle2','icon-close' => 'icon-close','icon-close2' => 'icon-close2','icon-checkmark' => 'icon-checkmark','icon-checkmark2' => 'icon-checkmark2','icon-checkmark3' => 'icon-checkmark3','icon-checkmark4' => 'icon-checkmark4','icon-minus' => 'icon-minus','icon-plus' => 'icon-plus','icon-bed2' => 'icon-bed2','icon-fan' => 'icon-fan','icon-umbrella' => 'icon-umbrella','icon-play2' => 'icon-play2','icon-pause' => 'icon-pause','icon-stop' => 'icon-stop','icon-backward' => 'icon-backward','icon-forward2' => 'icon-forward2','icon-play3' => 'icon-play3','icon-pause2' => 'icon-pause2','icon-stop2' => 'icon-stop2','icon-backward2' => 'icon-backward2','icon-forward3' => 'icon-forward3','icon-first' => 'icon-first','icon-last' => 'icon-last','icon-previous' => 'icon-previous','icon-next' => 'icon-next','icon-eject' => 'icon-eject','icon-volume-high' => 'icon-volume-high','icon-volume-medium' => 'icon-volume-medium','icon-volume-low' => 'icon-volume-low','icon-volume-mute' => 'icon-volume-mute','icon-arrow-up' => 'icon-arrow-up','icon-arrow-right' => 'icon-arrow-right','icon-arrow-down' => 'icon-arrow-down','icon-arrow-left' => 'icon-arrow-left','icon-arrow-up2' => 'icon-arrow-up2','icon-arrow-right2' => 'icon-arrow-right2','icon-arrow-down2' => 'icon-arrow-down2','icon-arrow-left2' => 'icon-arrow-left2','icon-arrow-up-left' => 'icon-arrow-up-left','icon-arrow-up3' => 'icon-arrow-up3','icon-arrow-up-right' => 'icon-arrow-up-right','icon-arrow-right3' => 'icon-arrow-right3','icon-arrow-down-right' => 'icon-arrow-down-right','icon-arrow-down3' => 'icon-arrow-down3','icon-arrow-down-left' => 'icon-arrow-down-left','icon-arrow-left3' => 'icon-arrow-left3','icon-arrow-up4' => 'icon-arrow-up4','icon-arrow-right4' => 'icon-arrow-right4','icon-arrow-down4' => 'icon-arrow-down4','icon-arrow-left4' => 'icon-arrow-left4','icon-arrow-up5' => 'icon-arrow-up5','icon-arrow-right5' => 'icon-arrow-right5','icon-arrow-bottom' => 'icon-arrow-bottom','icon-arrow-left5' => 'icon-arrow-left5','icon-arrow-up6' => 'icon-arrow-up6','icon-arrow-right6' => 'icon-arrow-right6','icon-arrow-down5' => 'icon-arrow-down5','icon-arrow-left6' => 'icon-arrow-left6','icon-transmission' => 'icon-transmission','icon-sort' => 'icon-sort','icon-loop' => 'icon-loop','icon-loop2' => 'icon-loop2','icon-checkbox-checked' => 'icon-checkbox-checked','icon-checkbox' => 'icon-checkbox','icon-checkbox-checked2' => 'icon-checkbox-checked2','icon-crop' => 'icon-crop','icon-vector' => 'icon-vector','icon-rulers' => 'icon-rulers','icon-scissors' => 'icon-scissors','icon-filter' => 'icon-filter','icon-font' => 'icon-font','icon-font-size' => 'icon-font-size','icon-text-height' => 'icon-text-height','icon-text-width' => 'icon-text-width','icon-height' => 'icon-height','icon-width' => 'icon-width','icon-page-break' => 'icon-page-break','icon-page-break2' => 'icon-page-break2','icon-new-tab' => 'icon-new-tab','icon-new-tab2' => 'icon-new-tab2','icon-embed' => 'icon-embed','icon-code' => 'icon-code','icon-mail' => 'icon-mail','icon-mail2' => 'icon-mail2','icon-mail3' => 'icon-mail3','icon-table' => 'icon-table','icon-google-plus' => 'icon-google-plus','icon-google-plus2' => 'icon-google-plus2','icon-google-plus3' => 'icon-google-plus3','icon-facebook' => 'icon-facebook','icon-facebook2' => 'icon-facebook2','icon-facebook3' => 'icon-facebook3','icon-instagram' => 'icon-instagram','icon-twitter' => 'icon-twitter','icon-twitter2' => 'icon-twitter2','icon-feed' => 'icon-feed','icon-feed2' => 'icon-feed2','icon-youtube' => 'icon-youtube','icon-youtube2' => 'icon-youtube2','icon-vimeo' => 'icon-vimeo','icon-vimeo2' => 'icon-vimeo2','icon-lanyrd' => 'icon-lanyrd','icon-flickr' => 'icon-flickr','icon-flickr2' => 'icon-flickr2','icon-picassa' => 'icon-picassa','icon-picassa2' => 'icon-picassa2','icon-dribbble' => 'icon-dribbble','icon-dribbble2' => 'icon-dribbble2','icon-forrst' => 'icon-forrst','icon-forrst2' => 'icon-forrst2','icon-deviantart' => 'icon-deviantart','icon-deviantart2' => 'icon-deviantart2','icon-github' => 'icon-github','icon-github2' => 'icon-github2','icon-github3' => 'icon-github3','icon-wordpress' => 'icon-wordpress','icon-blogger' => 'icon-blogger','icon-blogger2' => 'icon-blogger2','icon-tumblr' => 'icon-tumblr','icon-tumblr2' => 'icon-tumblr2','icon-apple' => 'icon-apple','icon-android' => 'icon-android','icon-windows' => 'icon-windows','icon-windows8' => 'icon-windows8','icon-skype' => 'icon-skype','icon-linkedin' => 'icon-linkedin','icon-lastfm' => 'icon-lastfm','icon-lastfm2' => 'icon-lastfm2','icon-stumbleupon' => 'icon-stumbleupon','icon-stumbleupon2' => 'icon-stumbleupon2','icon-pinterest' => 'icon-pinterest','icon-pinterest2' => 'icon-pinterest2','icon-xing' => 'icon-xing','icon-paypal' => 'icon-paypal','icon-html5' => 'icon-html5','icon-css3' => 'icon-css3','icon-file-zip' => 'icon-file-zip','icon-file-xml' => 'icon-file-xml','icon-file-pdf' => 'icon-file-pdf','icon-file-word' => 'icon-file-word','icon-file-excel' => 'icon-file-excel','icon-king' => 'icon-king','icon-queen' => 'icon-queen','icon-rock' => 'icon-rock','icon-knight' => 'icon-knight','icon-github4' => 'icon-github4','icon-steam' => 'icon-steam','icon-steam2' => 'icon-steam2','icon-yahoo' => 'icon-yahoo','icon-flickr3' => 'icon-flickr3','icon-google-drive' => 'icon-google-drive','icon-chrome' => 'icon-chrome','icon-firefox' => 'icon-firefox','icon-IE' => 'icon-IE','icon-opera' => 'icon-opera','icon-safari' => 'icon-safari','icon-IcoMoon' => 'icon-IcoMoon','icon-html52' => 'icon-html52', 'icon-vk' => 'icon-vk', 'icon-viadeo' => 'icon-viadeo',);
                   
                        $placeholder = (isset($this->field['placeholder']['icon_o'])) ? esc_attr($this->field['placeholder']['icon_o']) : __( 'Select an Icon', 'virtue' );
                        if ( isset( $this->field['select2'] ) ) { // if there are any let's pass them to js
                            $select2_params = json_encode( esc_attr( $this->field['select2'] ) );
                            $select2_params = htmlspecialchars( $select2_params , ENT_QUOTES);
                            echo '<input type="hidden" class="select2_params" value="'. $select2_params .'">';
                        }

                        echo '<select '.$multi.' id="'.$this->field['id'].'-select" data-placeholder="'.$placeholder.'" name="' . $this->field['name'] . '[' . $x . '][icon_o]" class="redux-select-item font-icons '.$this->field['class'].'" rows="6" style="width:93%;">';
                            echo '<option></option>';
                            foreach($icon_option as $k => $v){
                                if (is_array($this->value)) {
                                    $selected = (is_array($this->value) && in_array($k, $this->value))?' selected="selected"':'';                   
                                } else {
                                    $selected = selected($this->value, $k, false);
                                }
                                echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>';
                            }//foreach
                        echo '</select>';                           
                echo '<ul id="' . $this->field['id'] . '-ul" class="redux-slides-list">';
                $placeholder = (isset($this->field['placeholder']['url'])) ? esc_attr($this->field['placeholder']['url']) : __( 'URL', 'virtue' );
                echo '<li><input type="hidden" id="' . $this->field['id'] . '-url_' . $x . '" name="' . $this->field['name'] . '[' . $x . '][url]" value="" class="full-text upload" placeholder="'.$placeholder.'" /></li>';
                $placeholder = (isset($this->field['placeholder']['title'])) ? esc_attr($this->field['placeholder']['title']) : __( 'Title', 'virtue' );
                echo '<li><input type="text" id="' . $this->field['id'] . '-title_' . $x . '" name="' . $this->field['name'] . '[' . $x . '][title]" value="" placeholder="'.$placeholder.'" class="full-text slide-title" /></li>';
                $placeholder = (isset($this->field['placeholder']['description'])) ? esc_attr($this->field['placeholder']['description']) : __( 'Description', 'virtue' );
                echo '<li><textarea name="' . $this->field['name'] . '[' . $x . '][description]" id="' . $this->field['id'] . '-description_' . $x . '" placeholder="'.$placeholder.'" class="large-text" rows="6"></textarea></li>';
                $placeholder = (isset($this->field['placeholder']['link'])) ? esc_attr($this->field['placeholder']['link']) : __( 'Icon Link', 'virtue' );
                echo '<li><input type="text" id="' . $this->field['id'] . '-link_' . $x . '" name="' . $this->field['name'] . '[' . $x . '][link]" value="" placeholder="'.$placeholder.'" class="full-text" /></li>';
                
                echo '<li><label for="'. $this->field['id'] .  '-target_' . $x . '">';
                echo '<input type="checkbox" class="checkbox-slide-target" id="' . $this->field['id'] . '-target_' . $x . '" value="" ' . checked(  '', '1', false ) . ' name="' . $this->field['name'] . '[' . $x . '][target]" />';
                echo ' '.__('Open Link in New Tab/Window', 'virtue'). '</label></li>';

                echo '<li><input type="hidden" class="slide-sort" name="' . $this->field['name'] . '[' . $x . '][sort]" id="' . $this->field['id'] . '-sort_' . $x . '" value="' . $x . '" />';
                echo '<li><input type="hidden" class="upload-id" name="' . $this->field['name'] . '[' . $x . '][attachment_id]" id="' . $this->field['id'] . '-image_id_' . $x . '" value="" />';
                echo '<input type="hidden" class="upload" name="' . $this->field['name'] . '[' . $x . '][url]" id="' . $this->field['id'] . '-image_url_' . $x . '" value="" readonly="readonly" />';
                echo '<input type="hidden" class="upload-height" name="' . $this->field['name'] . '[' . $x . '][height]" id="' . $this->field['id'] . '-image_height_' . $x . '" value="" />';
                echo '<input type="hidden" class="upload-width" name="' . $this->field['name'] . '[' . $x . '][width]" id="' . $this->field['id'] . '-image_width_' . $x . '" value="" /></li>';


                echo '<li><a href="javascript:void(0);" class="button deletion redux-slides-remove">' . __('Delete Icon', 'virtue') . '</a></li>';
                echo '</ul></div></fieldset></div>';
            }
            echo '</div><a href="javascript:void(0);" class="button redux-slides-add2 kad_redux-icon-add button-primary" rel-id="' . $this->field['id'] . '-ul" rel-name="' . $this->field['name'] . '[title][]">' . __('Add Icon', 'virtue') . '</a><br/>';
            
        }  
           public function enqueue () {

            wp_enqueue_script (
                'redux-field-media-js', 
                ReduxFramework::$_url . 'inc/fields/media/field_media' . Redux_Functions::isMin () . '.js', 
                array( 'jquery' ), 
                time (), 
                true
            );

            wp_enqueue_style (
                'redux-field-media-css', 
                ReduxFramework::$_url . 'inc/fields/media/field_media.css', 
                time (), 
                true
            );

            wp_enqueue_script (
                'kad-field-icons-js', 
                get_template_directory_uri() . '/themeoptions/options/extensions/kad_icons/kad_icons/field_kad_icons' . Redux_Functions::isMin () . '.js', 
                array( 'jquery', 'jquery-ui-core', 'jquery-ui-accordion', 'wp-color-picker' ), 
                time (), 
                true
            );

            wp_enqueue_style (
                'kad-field-icons-css', 
                get_template_directory_uri() . '/themeoptions/options/extensions/kad_icons/kad_icons/field_kad_icons.css', 
                time (), 
                true
            );
        }              

    }
}
