<?php
/*
Plugin Name: Aviary for WordPress
Plugin URI: http://codecanyon.net/user/GreenTreeLabs
Description: A plugin that with the power of Aviary to edit images and add effects. You MUST get a free API key from http://www.aviary.com/web-key
Version: 1.0.3
Author: Green Tree Labs
Author URI: http://codecanyon.net/user/GreenTreeLabs
*/

/* Disallow direct access to the plugin file */
if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    die('Sorry, but you cannot access this page directly.');
}


if (!class_exists("AviaryWP")) {
    
    class AviaryWP
    {
        
        static $wp_version;
        static $plugin_path;
        
        public function __construct()
        {
            $this->plugin_path = plugins_url('aviary-editor');  
            $this->wp_version = substr(get_bloginfo('version'), 0, 3);
            
            add_action('admin_menu', array(
                $this,
                'create_options_page'
            ));
            add_action('admin_init', array(
                $this,
                'register_and_build_fields'
            ));
            
            add_action('wp_ajax_wpaviary_save', array(
                $this,
                'wpaviary_save'
            ));
            add_action('admin_print_scripts-upload.php', array(
                $this,
                'aviary_js'
            ));
            add_filter('attachment_fields_to_edit', array(
                $this,
                'media_form_extension'
            ));            
        }
        
        function media_form_extension($form_fields)
        {   
        	if(! strpos($_SERVER['SCRIPT_NAME'], "async-upload.php") &&
               ! strpos($_SERVER['SCRIPT_NAME'], "admin-ajax.php")) {
	            $this->aviary_js();
	        }
            return $form_fields;
        }
        
        public function aviary_js()
        {
            $options = get_option('aviary_options');
            
?>
  		<style>
  		.media-item-info .button, 
  		.wp_attachment_image .button {
	  		display: none;
  		}
  		</style>    
		<script type="text/javascript" src="//feather.aviary.com/js/feather.js"></script>		<script type='text/javascript'>
		
		var wp_version = "<?php print $this->wp_version; ?>";
		jQuery(function () {
			var id_query = wp_version == "3.4" ? "#attachment_id" : "#post_ID";
						
			jQuery("#imgedit-open-btn-" + jQuery(id_query).val()).after(
				"<a href='#'><img src='<?php print $this->plugin_path ?>/button.png' alt='Edit with Aviary' onclick='return launchEditor()' /></a>"
			);
		});
		
		var apiKey = '<?php print (isset($options['apikey'])) ? $options['apikey'] : ''; ?>';
		var featherEditor = new Aviary.Feather({
		       apiKey: apiKey,
		       language: '<?php print (isset($options['wpaviary_lang'])) ? $options['wpaviary_lang'] : 'en'; ?>',
		       apiVersion: 3,
		       theme: 'dark', // Check out our new 'light' and 'dark' themes!
		       tools: 'all',
		       appendTo: '',
		       onSave: function(imageID, newURL) {
		       	   featherEditor.showWaitIndicator();
		           onAviarySave(imageID, newURL);
		       },
		       onError: function(errorObj) {
		           alert(errorObj.message);
		       },
		       cropPresets: <?php print $this->cropPresets() ?>
		   });
		   function launchEditor() {
		   	   if(apiKey == '') {
			   	   alert("Aviary API key not found.");			   	  
			   	   return false;
		   	   }
		   	   var src_query = wp_version == "3.5" ? 
		   	   		"[name=attachment_url]" : ".urlfield";		   	   
			   var src = jQuery(src_query).val();
			   
			   var id = "aviary-media";
			   var img_query = ".wp_attachment_image img.thumbnail";
               if(wp_version == "3.5")
                    img_query = ".wp_attachment_image img.thumbnail";

			   jQuery(img_query).attr("id", id);

		       featherEditor.launch({
		           image: id,
		           url: src
		       });
		      return false;
		   }
		</script>
		
		<div id='injection_site'></div>      
      
    <script type="text/javascript">
        function onAviarySave (imageID, newURL) {
          var id_query = wp_version == "3.4" ? "#attachment_id" : "#post_ID";
          var data = {
          	  action: 'wpaviary_save',
              post_id: jQuery(id_query).val(),
              avaiary_url: newURL,
            };
            jQuery.post(ajaxurl, data, function(response) {
	            var cur_src = jQuery('#aviary-media').attr("src");
	            jQuery('#aviary-media').attr("src", cur_src + "?refresh=" + Math.random());
	            
	            featherEditor.hideWaitIndicator();
	            featherEditor.close();
            });
        }
		
    </script>

    <?php
        }
        
        public function wpaviary_save()
        {    
        	$id = $_POST['post_id'];
        	$image = get_post( $id );    
        	
            $url = $_POST['avaiary_url'];
            $tmp = download_url($url);
            
            $fullsizepath = get_attached_file( $image->ID );
            copy($tmp, str_replace(".txt", ".jpg", $fullsizepath));
            
            $metadata = wp_generate_attachment_metadata( $image->ID, $fullsizepath );
            wp_update_attachment_metadata( $image->ID, $metadata );
            clean_post_cache( $id );
        }
        
        public function create_options_page()
        {
            add_options_page(__('Aviary for WordPress'), __('Aviary for WordPress'), 'manage_options', __FILE__, array(
                $this,
                'options_page_fn'
            ));
        }
        
        public function register_and_build_fields()
        {
            register_setting('aviary_options', 'aviary_options', array(
                $this,
                'validate_setting'
            ));
            add_settings_section('main_section', 'Main Settings', array(
                $this,
                'section_cb'
            ), __FILE__);
            add_settings_field('apikey', __('API Key:'), array(
                $this,
                'api_key_field'
            ), __FILE__, 'main_section');
            add_settings_field('wpaviary_lang', __('Editor Language:'), array(
                $this,
                'widget_lnguage'
            ), __FILE__, 'main_section');
        }
        
        public function options_page_fn()
        {
?>
          <div class="icon32" id="icon-tools"></div>

          <h2>Aviary for WordPress</h2>

          <form method="post" action="options.php" enctype="multipart/form-data">
             <?php settings_fields('aviary_options'); ?>
             <?php do_settings_sections(__FILE__); ?>
             <p class="submit">
                <input name="Submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save Changes'); ?>" />
             </p>
       </form>
    <?php
        }
        
        public function api_key_field()
        {
            $options = get_option('aviary_options');
            echo "<input name='aviary_options[apikey]' type='text' value='" . $options['apikey'] ."' />";
            echo "<br />" . __('Get a free API key here: <a href="http://www.aviary.com/web-key" target="_blank">http://www.aviary.com/web-key</a>');
        }
        
        public function widget_lnguage()
        {
            $options = get_option('aviary_options');
            $items   = array(
                'en' => 'English (default)',
                'ca' => ' Catalan',
                'zh_HANS' => 'Chinese (simplified)',
                'zh_HANT' => 'Chinese (traditional)',
                'nl' => 'Dutch',
                'fr' => 'French',
                'de' => 'German',
                'he' => 'Hebrew',
                'id' => 'Indonesian',
                'it' => 'Italian',
                'ja' => 'Japanese',
                'ko' => 'Korean',
                'lv' => 'Latvian',
                'lt' => 'Lithuanian',
                'pl' => 'Polish',
                'pt' => ' Portuguese',
                'pt_BR' => 'Portuguese (Brazilian)',
                'ru' => 'Russian',
                'es' => 'Spanish',
                'vi' => 'Vietnamese'
            );
            
            echo "<select name='aviary_options[wpaviary_lang]'>";
            foreach ($items as $key => $val) {
                $selected = ($options['wpaviary_lang'] === $key) ? 'selected = "selected"' : '';
                echo "<option value='$key' $selected>$val</option>";
            }
            echo "</select>";
        }
        
        public function validate_setting($aviary_options)
        {
            return $aviary_options;
        }
        
        public function section_cb()
        {
        }
        
        public function cropPresets()
        {
            $image_sizes = get_intermediate_image_sizes();
            foreach ($image_sizes as $size_name => $size_attrs) {
                $labled = "['" . $size_name . "', '" . $size_name . "']," . "\n";
            }
            return "[" . "\n" . $labled . "'320x240','640x480','800x600','1280x1024','1600x1200',
		        '240x320','480x640','600x800','1024x1280','1200x1600',
		        'Original',
		        ['Square', '1:1'],
		        'Custom',
		        '3:2', '3:5', '4:3', '4:6', '5:7', '8:10', '16:9'" . "\n" . "]";
        }
    }
}
$aviary = new AviaryWP;