<?php
/**
 * Plugin Name: WooCommerce Custom Order Statuses & Actions
 * Plugin URI: http://actualityextensions.com/
 * Description: Allows users to manage WooCommerce order statuses, create the action button that triggers the status and set up the email notification that is sent when status is applied.
 * Version: 1.1.1
 * Author: Actuality Extensions
 * Author URI: http://actualityextensions.com/
 * Tested up to: 3.8
 *
 * Copyright: (c) 2012-2013 Actuality Extensions
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package     WC-Custom-Status
 * @author      Actuality Extensions
 * @category    Plugin
 * @copyright   Copyright (c) 2012-2013, Actuality Extensions
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */
global $woocommerce_status_actions_db_version;
$woocommerce_status_actions_db_version = '1.0.1';

ini_set('zlib.output_compression','off');
register_activation_hook( __FILE__, 'wc_install_db_tables' );
add_action('plugins_loaded', 'wc_custom_status_init', 0);
add_action('admin_init','add_admin_stylesheets');
add_action( 'admin_footer', 'woocommerce_status_actions_bulk', 11 );
add_action( 'load-edit.php', 'woocommerce_status_actions_bulk_handler' );

add_action( 'woocommerce_status_actions_check_db_version', 'wc_install_db_tables' );
do_action( 'woocommerce_status_actions_check_db_version' );

function woocommerce_action_status_compile_less( $less_file, $css_file ) {

    global $woocommerce;


        if ( ! class_exists( 'lessc' ) )
            include_once( WC()->plugin_path() . '/includes/libraries/class-lessc.php' );

        if ( ! class_exists( 'cssmin' ) )
            include_once( WC()->plugin_path() . '/includes/libraries/class-cssmin.php' );



    $less           = new lessc( $less_file );
    $compiled_css   = $less->parse();

    if ( $compiled_css )
        file_put_contents( $css_file, $compiled_css );
}

function woocommerce_status_actions_generate_action_icons() {
    ############ GENERATE CSS FILE ##################
    $font_file = plugin_dir_path( __FILE__ ) . 'css/fonts/icomoon.svg';
    if( file_exists( $font_file ) ) {
        $file = file_get_contents( $font_file );
        $matches = array();
        preg_match_all( "/glyph unicode=\"(.*?)\"/", $file, $matches);
        foreach( $matches[1] as $unicode ) {
            $class_name = str_replace('&#x', '', $unicode);
            $class_name = str_replace(';', '', $class_name);
            file_put_contents( plugin_dir_path( __FILE__ ) . '/css/action_icons.less' ,  '.woocommerce_status_actions_'. $class_name .':after {content: "\\'.$class_name.'";}' . PHP_EOL, FILE_APPEND);
        }
        // Compile Icons CSS
        $less_file = plugin_dir_path(__FILE__ ) . '/css/action_icons.less';
        $css_file = plugin_dir_path(__FILE__ ) . '/css/action_icons.css';
        woocommerce_action_status_compile_less( $less_file, $css_file );
    }
}

function woocommerce_custom_status_action_column_width_override() {
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function(){
            if( jQuery('.status_text.hhh').length > 0 ) {
                jQuery('.column-order_status').css( 'width', '80px' );
            }
            else if ( jQuery('.status_line_text.hhh').length > 0 ) {
                jQuery('.column-order_status').css( 'width', '80px' );
            }
        });
    </script>
    <?php
}

/**
 * Adds the plugin's stylesheets to the dashboard
 */
function add_admin_stylesheets() {
    global $woocommerce;
    // Ensure our specific CSS is loaded only on our pages so as to not affect other pages
    if( (isset( $_GET['page'] ) && strpos( $_GET['page'], 'woocommerce_status_and_actions') != -1) || ( isset($_GET['post_type']) && strpos( $_GET['post_type'], 'shop_order') != -1) ) {
        add_action( 'admin_footer',  'woocommerce_custom_status_action_column_width_override' );
    }


    if( !file_exists( plugin_dir_path(__FILE__ ) . '/css/action_icons.less' ) )
        woocommerce_status_actions_generate_action_icons();

    $action_icons_file_url = plugin_dir_url(__FILE__) . '/css/action_icons.css';


    if( !file_exists( plugin_dir_path(__FILE__ ) . '/css/admin.css' ) ) {
        // Compile Admin CSS
        $less_file = plugin_dir_path(__FILE__ ) . '/css/admin.less';
        $css_file = plugin_dir_path(__FILE__ ) . '/css/admin.css';
        woocommerce_action_status_compile_less( $less_file, $css_file );

    }

    $css_file_url = plugin_dir_url(__FILE__) . '/css/admin.css';

    wp_enqueue_style('status_actions_less', $css_file_url );
    wp_enqueue_style('status_actions_less_icons_test', $action_icons_file_url );

    wp_register_style( 'woocommerce_frontend_styles', plugins_url() . '/woocommerce/assets/css/admin.css' );
    wp_enqueue_style( 'woocommerce_frontend_styles' );


    wp_register_script( 'woocommerce_tiptip_js', plugins_url() . '/woocommerce/assets/js/jquery-tiptip/jquery.tipTip.min.js' );
    wp_enqueue_script( 'woocommerce_tiptip_js' );
    wp_enqueue_style('thickbox');
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
    wp_enqueue_script(
        'jquery-validate',
        plugin_dir_url( __FILE__ ) . 'js/jquery.validate.min.js',
        array('jquery'),
        '1.11.0',
        true
    );
    wp_enqueue_script('media-upload');
    wp_enqueue_script(
        'retina',
        plugin_dir_url( __FILE__ ) . 'js/retina.js',
        '0.0.2',
        true
    );
    // Handles the deletion of the statuses
    wp_enqueue_script( 'delete-custom-scripts', plugin_dir_url(__FILE__) . 'js/custom-status-action-delete.js', array('jquery') );
}

/**
 * Registers the hooks required for the plugin
 * @return void
 */
function wc_custom_status_init() {
    if ( !in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
        return;
    }
    global $woocommerce;

    // Email handling
    $GLOBALS['wc_custom_status_mailer_object'] = $woocommerce->mailer();
    define( 'WC_CUSTOM_STATUS_PLUGIN_PATH', plugin_dir_url(__FILE__) );

    require dirname(__FILE__)  . '/classes/wc_custom_status_email.class.php';

    // Localization domain
    load_plugin_textdomain('woocommerce_status_actions', false, dirname( plugin_basename( __FILE__ ) ) . '/languages');

    // The core of the plugin
    $GLOBALS['wc_custom_status_object'] = new WC_Custom_Status_Plugin();

    // Adds the action hook for when the action button is clicked from the orders table (action column)
    $action_list = WC_Custom_Status::get_status_list();
    foreach($action_list as $action){
        add_action("wp_ajax_woocommerce-mark-order-{$action}", 'process_custom_action');
    }

    add_action('admin_notices', 'wc_custom_order_bulk_admin_notices' );
}


/**
 * Adds the admin messages on successful changes/update of our custom actions/statuses
 * @return [type] [description]
 */
function wc_custom_order_bulk_admin_notices() {
    global $post_type, $pagenow;

    if (isset($_REQUEST['order_status_changed'])) {
        $number = absint( $_REQUEST['order_status_changed'] );
        $message_title = __('Order Status Changed','woocommerce_status_actions');
    } else {
        return;
    }

    if ( 'edit.php' == $pagenow && 'shop_order' == $post_type ) {
        $message = sprintf( __( $message_title . '. %s orders affected.', $number, 'woocommerce_status_actions' ), number_format_i18n( $number ) );
        echo '<div class="updated"><p>' . $message . '</p></div>';
    }
}

function woocommerce_status_actions_bulk() {
   global $post_type;
   $status_list = WC_Custom_Status::get_status_list();
   $status_list = array_merge($status_list,WC_Custom_Status::$default_status_list);
   unset($status_list[array_search('processing',$status_list)]);
   unset($status_list[array_search('completed',$status_list)]);
   asort($status_list);
   if ( 'shop_order' == $post_type ) {
       ?>
       <script type="text/javascript">
           jQuery(document).ready(function() {
               jQuery('.custom_payment_status').each(function(){jQuery(this).parent().parent().css('background-color',jQuery(this).attr('rowcolor'));});
               <?php
               foreach($status_list as $status_name){
                   echo "
                       jQuery('<option>').val('mark_custom_status_{$status_name}').text('".__( "Mark {$status_name}", "woocommerce_status_actions" )."').appendTo('select[name=action]');
                       jQuery('<option>').val('mark_custom_status_{$status_name}').text('".__( "Mark {$status_name}", "woocommerce_status_actions" )."').appendTo('select[name=action2]');";
               }
               ?>
            });
        </script>
        <?php
    }
}

function woocommerce_status_actions_bulk_handler() {
    if(!isset($_REQUEST['post'])){
        return;
    }
    $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
    $action = $wp_list_table->current_action();

    $changed = 0;
    $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );
    if(strstr($action,'mark_custom_status')) {
       $new_status = substr($action,strlen('mark_custom_status_'));
       $report_action = "order_status_changed";
       foreach( $post_ids as $post_id ) {
           $order = new WC_Order($post_id);
           $order->update_status( $new_status );
           $changed++;
       }
    } else{
        return;
    }
    $sendback = add_query_arg( array( 'post_type' => 'shop_order', $report_action => $changed, 'ids' => join( ',', $post_ids ) ), '' );
    wp_redirect( $sendback );
    exit();
}


/**
 * Processes the custom action to mark an order with our custom status
 * @return void
 */
function process_custom_action(){
    if(!isset($_GET['custom_action_name'])) die;
    $action_name = strip_tags($_GET['custom_action_name']);
    if ( empty($action_name) ) die;
    if ( !is_admin() ) die;
    if ( !current_user_can('edit_shop_orders') ) wp_die( __( 'You do not have sufficient permissions to access this page.', 'woocommerce' ) );
    if ( !check_admin_referer("woocommerce-mark-order-{$action_name}")) wp_die( __( 'You have taken too long. Please go back and retry.', 'woocommerce' ) );
    $order_id = isset($_GET['order_id']) && (int) $_GET['order_id'] ? (int) $_GET['order_id'] : '';
    if (!$order_id) die;

    $order = new WC_Order( $order_id );
    $wc_custom_action = new WC_Custom_Status();
    $test = $wc_custom_action->load_status_from_db($action_name);
    if( $test ){
        $order->update_status( $action_name );
    }

    wp_safe_redirect( wp_get_referer() );
}

/**
 * On plugin's installation/activation, create our custom database tables
 * @return void
 */
function wc_install_db_tables(){
    global $wpdb, $woocommerce_status_actions_db_version;
      $wpdb->hide_errors();
      $installed_ver = get_option( "woocommerce_status_actions_db_version" );
    if( $installed_ver != $woocommerce_status_actions_db_version ){
        $table_name = $wpdb->prefix . "woocommerce_order_status_action";
        $sql = "CREATE TABLE $table_name (
                id INT NOT NULL AUTO_INCREMENT,
                term_id INT(10) NOT NULL,
                term_taxonomy_id INT(10) NOT NULL,
                created datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                updated datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                status_name VARCHAR(55) NOT NULL,
                status_icon TEXT NOT NULL,
                status_color VARCHAR(10) NOT NULL,
                status_color_type VARCHAR(1) NOT NULL,
                sends_email VARCHAR(1) NOT NULL,
                display_completed VARCHAR(1) NOT NULL,
                display_processing VARCHAR(1) NOT NULL,
                can_cancel VARCHAR(1) NOT NULL,
                display_in_reports VARCHAR(1) NOT NULL,
                email_to VARCHAR(15),
                custom_email_address VARCHAR(100),
                email_subject VARCHAR(200),
                from_name VARCHAR(200),
                from_address VARCHAR(100),
                display_essential_info VARCHAR(1) NOT NULL,
                display_custom_info VARCHAR(1) NOT NULL,
                custom_title VARCHAR(200),
                custom_info TEXT,
                payment_status VARCHAR(20),
                action_icon TEXT NOT NULL,
                display_for TEXT NOT NULL,
                new_status VARCHAR(55) NOT NULL,
                PRIMARY KEY  (id)
               );";

        error_log($sql);
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );

         if(get_option( "woocommerce_status_actions_db_version" )) {
          update_option( "woocommerce_status_actions_db_version", $woocommerce_status_actions_db_version );
        }else{
          add_option( "woocommerce_status_actions_db_version", $woocommerce_status_actions_db_version );
        }
    }
}

require dirname(__FILE__) . '/classes/wc_custom_status_plugin.class.php';
require dirname(__FILE__) . '/classes/wc_custom_status.class.php';
require dirname(__FILE__) . '/classes/exceptions/requiredfieldmissing.class.php';
require dirname(__FILE__) . '/classes/exceptions/wperrorexception.class.php';

if(!class_exists('WP_List_Table')){
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

require dirname(__FILE__) . '/classes/tables/wc_custom_status_table.class.php';

?>
