<?php
/**
 * Settings class.
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if (class_exists('WC_Settings_Page')){
class TM_Settings_Extra_Product_Options extends WC_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'tm_extra_product_options';
		$this->label = __('Extra Product Options', TM_EPO_TRANSLATION);

		add_filter( 'woocommerce_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
		add_action( 'woocommerce_settings_' . $this->id, array( $this, 'output' ) );
		add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );
	}

	/**
	 * Get settings array
	 *
	 * @return array
	 */
	public function get_settings() {

		return apply_filters( 'tm_' . $this->id . '_settings', array(

			array( 'title' => __( 'General Settings', TM_EPO_TRANSLATION ), 
				'type' => 'title', 
				//'desc' => "",
				'id' => 'epo_page_options' ),

			array(
					'title' 	=> __( 'Display', TM_EPO_TRANSLATION ),
					'desc' 		=> '<div>'.__( 'This controls how your fields are displayed on the front-end.<br />If you choose "Show using action hooks" you have to manually write the code to your theme or plugin to display the fields. See more at the documentation.', TM_EPO_TRANSLATION ).'</div>',
					'id' 		=> 'tm_epo_display',
					'class'		=> 'chosen_select',
					'css' 		=> 'min-width:300px;',
					'default'	=> 'normal',
					'type' 		=> 'select',
					'options' 	=> array(
						'normal' => __( 'Normal', TM_EPO_TRANSLATION ),
						'action' => __( 'Show using action hooks', TM_EPO_TRANSLATION ),
					),
					'desc_tip'	=>  false,
				),

			array(
					'title' 	=> __( 'Force Select Options', TM_EPO_TRANSLATION ),
					'desc' 		=> '<div>'.__( 'This changes the add to cart button to display select options when the product has extra product options.<br />Enabling this will remove the ajax functionality.', TM_EPO_TRANSLATION ).'</div>',
					'id' 		=> 'tm_epo_force_select_options',
					'class'		=> 'chosen_select',
					'css' 		=> 'min-width:300px;',
					'default'	=> 'normal',
					'type' 		=> 'select',
					'options' 	=> array(
						'normal' 	=> __( 'Disable', TM_EPO_TRANSLATION ),
						'display' 	=> __( 'Enable', TM_EPO_TRANSLATION ),
					),
					'desc_tip'	=>  false,
				),

			array(
					'title' => __( 'Final total box', TM_EPO_TRANSLATION ),
					'desc' 		=> '<div>'.__( 'Select when to show the final total box', TM_EPO_TRANSLATION ).'</div>',
					'id' 		=> 'tm_epo_final_total_box',
					'class'		=> 'chosen_select',
					'css' 		=> 'min-width:300px;',
					'default'	=> 'normal',
					'type' 		=> 'select',
					'options' 	=> array(
						'normal' 			=> __( 'Show Both Final and Options total box', TM_EPO_TRANSLATION ),
						'final' 			=> __( 'Show only Final box', TM_EPO_TRANSLATION ),
						'hideoptionsifzero' => __( 'Show Final box and hide Options if zero', TM_EPO_TRANSLATION ),
						'hide' 				=> __( 'Hide Final total box', TM_EPO_TRANSLATION ),
					),
					'desc_tip'	=>  false,
				),

			array(
					'title' => __( 'Clear cart button', TM_EPO_TRANSLATION ),
					'desc' 		=> '<div>'.__( 'Enables or disables the clear cart button', TM_EPO_TRANSLATION ).'</div>',
					'id' 		=> 'tm_epo_clear_cart_button',
					'class'		=> 'chosen_select',
					'css' 		=> 'min-width:300px;',
					'default'	=> 'normal',
					'type' 		=> 'select',
					'options' 	=> array(
						'normal' 	=> __( 'Hide', TM_EPO_TRANSLATION ),
						'show' 		=> __( 'Show', TM_EPO_TRANSLATION )
						
					),
					'desc_tip'	=>  false,
				),

			array(
					'title' => __( 'Cart Field Display', TM_EPO_TRANSLATION ),
					'desc' 		=> '<div>'.__( 'Select how to display your fields in the cart', TM_EPO_TRANSLATION ).'</div>',
					'id' 		=> 'tm_epo_cart_field_display',
					'class'		=> 'chosen_select',
					'css' 		=> 'min-width:300px;',
					'default'	=> 'normal',
					'type' 		=> 'select',
					'options' 	=> array(
						'normal' 	=> __( 'Normal display', TM_EPO_TRANSLATION ),
						'link' 		=> __( 'Display a pop-up link', TM_EPO_TRANSLATION )						
					),
					'desc_tip'	=>  false,
				),

			array( 'type' => 'sectionend', 'id' => 'epo_page_options' )			

		)); // End pages settings
	}
}
new TM_Settings_Extra_Product_Options();
}
?>