(function($) {
    "use strict";

    if (!$().cpfdependson) {
    $.fn.cpfdependson = function(fields, toggle, what) {
        var elements    = this,
            matches     = 0;
        
        if (!toggle){
            toggle="show";
        }
        if (!what){
            what="all";
        }

        function tm_check_rules(o){
            o.each(function(){
                var matches = $(this).data("matches"),
                    toggle  = $(this).data("toggle"),
                    what    = $(this).data("what"),
                    fields  = $(this).data("fields"),
                    checked = 0,
                    show    = false;

                switch (toggle){
                    case "show":
                        show=false;
                    break;
                    case "hide":
                        show=true;
                    break;
                }

                $.each(fields,function(i,field){
                    if (tm_check_field_match(field)){
                        checked++;
                    }
                });

                if (what=="all"){
                    if (matches==checked){
                        show=!show;
                    }
                }else{
                    if (checked>0){
                        show=!show;
                    }

                }                

                $(this).toggle(show);

            });
        }
        
        function get_element_from_field(element){
            if ($(element).length==0){
                return;
            }
            var _class=element.attr("class").split(' ')
                .map(function(cls) {
                    if (cls.indexOf("cpf-type-", 0) !== -1) {
                        return cls;
                    }
                })
                .filter(function(v, k, el) {
                    if (v !== null && v !== undefined) {
                        return v;
                    }
                });
            if (_class.length>0){
                _class=_class[0];
                switch (_class){
                    case "cpf-type-radio" :
                        return element.find(".tmcp-field.tmcp-radio");
                        break;
                    case "cpf-type-checkbox" :
                        return element.find(".tmcp-field.tmcp-checkbox");
                        break;
                    case "cpf-type-select" :
                        return element.find(".tmcp-field.tmcp-select");
                        break;
                    case "cpf-type-textarea" :
                        return element.find(".tmcp-field.tmcp-textarea");
                        break;
                    case "cpf-type-textfield" :
                        return element.find(".tmcp-field.tmcp-textfield");
                        break;
                }
                return;
            }
            return;
        }

        function tm_check_field_match(f){
            var element     = $(f.element),
                operator    = f.operator,
                value       = f.value,
                val,
                _class      = element.attr("class").split(' ')
                .map(function(cls) {
                    if (cls.indexOf("cpf-type-", 0) !== -1) {
                        return cls;
                    }
                })
                .filter(function(v, k, el) {
                    if (v !== null && v !== undefined) {
                        return v;
                    }
                });

            if (_class.length>0){
                _class=_class[0];
                switch (_class){
                    case "cpf-type-radio" :
                        var radio           = element.find(".tmcp-field.tmcp-radio"),
                            radio_checked   = element.find(".tmcp-field.tmcp-radio:checked");

                        if (radio_checked.length==0){
                            return false;
                        }
                        var eq=radio.index(radio_checked),
                            builder_addition="_"+eq;

                        builder_addition=builder_addition.length;                        
                        val=element.find(".tmcp-field.tmcp-radio:checked").val();
                        val=val.slice(0,-builder_addition);                        
                        break;
                    case "cpf-type-checkbox" :
                        var checkbox            = element.find(".tmcp-field.tmcp-checkbox"),
                            checkbox_checked    = element.find(".tmcp-field.tmcp-checkbox:checked");

                        if (checkbox_checked.length==0){
                            return false;
                        }
                        var ret=false;
                        checkbox_checked.each(function(i,el){
                            var eq                  = checkbox.index($(el)),
                                builder_addition    = "_"+eq;

                            builder_addition=builder_addition.length;
                            val=$(el).val();
                            val=val.slice(0,-builder_addition);
                            if (tm_check_match(val,value,operator)){
                                ret=true;
                            }
                        });
                        return ret;
                        break;
                    case "cpf-type-select" :
                        var select = element.find(".tmcp-field.tmcp-select"),
                            options = element.find(".tmcp-field.tmcp-select").children('option'),
                            selected = element.find(".tmcp-field.tmcp-select").children('option:selected');
                        var eq=options.index(selected),
                            builder_addition="_"+eq;

                        builder_addition=builder_addition.length;
                        val=element.find(".tmcp-field.tmcp-select").val();
                        val=val.slice(0,-builder_addition); 

                        break;
                    case "cpf-type-textarea" :
                        val=element.find(".tmcp-field.tmcp-textarea").val();
                        break;
                    case "cpf-type-textfield" :
                        val=element.find(".tmcp-field.tmcp-textfield").val();
                        break;
                }
                return tm_check_match(val,value,operator);

            }else{
                return false;
            }

            return false;
                
        }

        function tm_check_match(val1, val2, operator){
            val1 = val1 ? val1.toLowerCase() : "";
            val2 = val2 ? val2.toLowerCase() : "";
            switch(operator){
            case "is" :
                return val1 == val2;
                break;

            case "isnot" :
                return val1 != val2;
                break;
            }
            return false;
        }

        if (elements.length==0){
            return;
        }
        if (!typeof fields =="object"){
            return;
        }
        
        $.each(fields,function(i,field){
            if (!typeof fields =="object"){
                return true;
            }
            var element=get_element_from_field(field.element);
            if (element){
                var _events="change.cpflogic";
                if ($(element).is(":text") || $(element).is("textarea")){
                    _events="change.cpflogic keyup.cpflogic";
                }
                $(element).on(_events,function(e){
                    tm_check_rules(elements);
                });
            }
            matches++;
        });
        
        elements.each(function(i,el){                       
            $(this).data("matches",matches);
            $(this).data("toggle",toggle);
            $(this).data("what",what);
            $(this).data("fields",fields);
            var show=false;
            switch (toggle){
                case "show":
                    show=false;
                break;
                case "hide":
                    show=true;
                break;
            }
            $(this).toggle(show);
        });

        //hide the dependent fields
        return elements.each(function(){
            tm_check_rules($(this));
        });
    };
    }


    var validate_logic=function(l){
        return (typeof l =="object") && ("toggle" in l) && ("what" in l) && ("rules" in l) && (l.rules.length>0);
    }

    var cpf_section_logic=function(obj){
        $(obj).find(".cpf-section").each(function(index,el){
            var id          = $(el).data("uniqid"),
                logic       = $(el).data("logic"),
                haslogic    = parseInt($(el).data("haslogic"));

            if (haslogic==1 && validate_logic(logic)){
                var fields=[];
                $.each(logic.rules,function(i,rule){
                    var section     = rule.section,
                        element     = rule.element,
                        operator    = rule.operator,
                        value       = rule.value,
                        obj_section = $(obj).find('.cpf-section[data-uniqid="'+section+'"]'),
                        obj_element = obj_section.find(".cpf_hide_element").eq(element);

                    fields.push({
                        "element":obj_element,
                        "operator":operator,
                        "value":value
                    });
                });
                $(el).cpfdependson(fields,logic.toggle,logic.what);
            }
        });
    }

    var cpf_element_logic=function(obj){
        $(obj).find(".cpf_hide_element").each(function(index,el){
            var id          = $(el).data("uniqid"),
                logic       = $(el).data("logic"),
                haslogic    = parseInt($(el).data("haslogic"));

            if (haslogic==1 && validate_logic(logic)){
                var fields=[];
                $.each(logic.rules,function(i,rule){
                    var section     = rule.section,
                        element     = rule.element,
                        operator    = rule.operator,
                        value       = rule.value,
                        obj_section = $(obj).find('.cpf-section[data-uniqid="'+section+'"]'),
                        obj_element = obj_section.find(".cpf_hide_element").eq(element);
                    fields.push({
                        "element":obj_element,
                        "operator":operator,
                        "value":value
                    });
                });
                $(el).cpfdependson(fields,logic.toggle,logic.what);
            }
        });
    }

    $(document).ready(function() {
        
        $(".tm-collapse").tmtoggle();
        $(".tm-cart-link").tmpoplink();
        /**
         * Start Condition Logic
         */
        cpf_section_logic($(".tm-extra-product-options"));
        cpf_element_logic($(".tm-extra-product-options"));


        /**
         * Holds the main cart when using Composite Products
         */
        var main_cart=false;
        
        /**
         * Holds the active precentage of total current price type fields
         */
        var late_fields_prices=[];

        var add_late_fields_prices=function(product_price,bid){
            var total=0;
            $.each(late_fields_prices,function(i,field){
                var price=field["price"],
                    setter=field["setter"],
                    id=setter.attr("name"),
                    hidden=$('#'+id+'_hidden'),
                    bundleid=field["bundleid"];
                
                if (bundleid==bid){
                    if (setter.is("option")){
                        id=setter.closest("select").attr("name");
                        hidden=$('#'+id+'_hidden');
                    }
                    price=(price/100)*product_price;
                    if (setter.data('isset')==1){
                        total=total+price;
                    }
                    var formatted_price = tm_set_price(price);
                    setter.data('price', price);
                    setter.data('pricew', price);
                    setter.closest('.tmcp-field-wrap').find('.amount').html(formatted_price);
                    if (hidden.length==0){
                        if (setter.is("option")){
                            setter=setter.closest("select");
                            id=setter.attr("name");
                        }
                        setter.after('<input type="hidden" id="'+id+'_hidden" name="'+id+'_hidden" value="'+price+'" />');
                    }
                    hidden.val(price);
                }else{
                    if (setter.data('pricew')!==undefined){
                        var formatted_price = tm_set_price(setter.data('pricew'));
                        setter.closest('.tmcp-field-wrap').find('.amount').html(formatted_price);
                    }
                }
            });
            late_fields_prices=[];

            return total;
        }

        /**
         * Limit checkbox selection
         */
        var checkbox_selector=".tm-extra-product-options input.tmcp-field[type='checkbox']";
        $(checkbox_selector).change(function () {            
            var allowed=parseInt($(this).attr('data-limit'));
            if (allowed>0){
                var checked = $(this).closest(".tm-extra-product-options-checkbox").find("input.tmcp-field[type='checkbox']:checked").length;
                if (checked>allowed){
                    $(this).prop("checked", "");
                }
            }
        });
        
        /**
         * Return a formatted currency value
         */
        function tm_set_price(value) {
            return accounting.formatMoney(value, {
                symbol: tm_epo_js.currency_format_symbol,
                decimal: tm_epo_js.currency_format_decimal_sep,
                thousand: tm_epo_js.currency_format_thousand_sep,
                precision: tm_epo_js.currency_format_num_decimals,
                format: tm_epo_js.currency_format
            });
        }

        /**
         * Set field price rules
         */
        function tm_epo_rules() {
            late_fields_prices=[];
            var all_carts = $('.cart');                
            if (!all_carts.length>0){
                return;
            }
            all_carts.each(function(cart_index,cart){
                cart=$(cart);
                var per_product_pricing=true,
                    bto = $(this).closest('.bto_item'),
                    current_variation=cart.find('input[name^=variation_id]').val(),
                    is_bto=false,bundleid=cart.attr( 'data-product_id' );
                if (!bundleid){
                    bundleid=0;
                }

                if (bto.length>0){
                    is_bto=true;
                    var container_id = bto.attr('data-container-id'),
                        price_data = $( '.bto_form_' + container_id ).data( 'price_data' );

                    per_product_pricing = price_data[ 'per_product_pricing' ];
                }
                // get current woocommerce variation
                if (!current_variation) {
                    current_variation = 0;
                }
                // set initial prices for all fields
                cart.find('.tmcp-attributes, .tmcp-elements').each(function(index, element) {
                    var rules = $(element).data('rules');
                    // if rule doesn't exit then init an empty rule
                    if (typeof rules !== "object") {
                        rules = {
                            0: "0"
                        };
                    }
                    if (typeof rules === "object") {
                        // we skip price validation test so that every field has at least a price of 0
                        var price = rules[current_variation],
                            formatted_price = tm_set_price(price);

                        $(element).find('.tmcp-field').each(function(i, e) {
                            if (per_product_pricing){
                                $(e).data('price', price);
                                $(e).closest('.tmcp-field-wrap').find('.amount').html(formatted_price);
                            }else{
                                $(e).data('price', 0);
                                $(e).closest('.tmcp-field-wrap').find('.amount').empty();
                            }
                        });
                    }
                });
                // skip specific field rules if per_product_pricing is false
                if (!per_product_pricing){
                    return true;
                }
                
                //  apply specific field rules
                cart.find('.tm-extra-product-options .tmcp-field').each(function(index, element) {
                    var setter = $(element);
                    if ($(element).is('select')) {
                        setter = $(element).find('option:selected');
                    }
                    var rules           = setter.data('rules'),
                        rulestype       = setter.data('rulestype'),
                        _rules, 
                        _rulestype, 
                        pricetype, 
                        price, 
                        formatted_price,
                        product_price,
                        cpf_bto_price   = cart.find('.cpf-bto-price');
                    
                    // Composite Products                    
                    if (bto.length>0){                    
                        if (cpf_bto_price.length>0){
                            if (cpf_bto_price.data('per_product_pricing')){
                                product_price = cpf_bto_price.val();
                            }else{
                                product_price = 0;
                            }
                            cpf_bto_price.val(product_price);                        
                        }
                    }else{
                        var $totals = setter.closest('.cart').find('.tm-epo-totals');
                        if ($totals.length){
                            product_price = $totals.data('price');
                            cpf_bto_price.val(product_price);
                        }
                    }
                                   
                    pricetype='';
                    if (typeof rules === "object") {

                        if (current_variation in rules) {
                            price = rules[current_variation];
                        } else {
                            _rules = $(element).closest('.tmcp-ul-wrap').data('rules');

                            if (typeof _rules === "object") {
                                if (current_variation in _rules) {
                                    price = _rules[current_variation];
                                } else {
                                    price = rules[0];
                                }
                            } else {
                                price = rules[0];
                            }
                        }

                        if (typeof rulestype === "object") {
                            if (current_variation in rulestype) {
                                pricetype = rulestype[current_variation];
                            }else{
                                _rulestype = $(element).closest('.tmcp-ul-wrap').data('rulestype');
                                if (typeof _rulestype === "object") {
                                    if (current_variation in _rulestype) {
                                        pricetype = _rulestype[current_variation];
                                    }else{
                                        pricetype = rulestype[0];
                                    }
                                }else{
                                    pricetype = rulestype[0];
                                }
                            }
                        }else{
                            rulestype = $(element).closest('.tmcp-ul-wrap').data('rulestype');
                            if (typeof rulestype === "object") {
                                if (current_variation in rulestype) {
                                    pricetype = rulestype[current_variation];
                                } else {
                                    pricetype = rulestype[0];
                                }
                            }
                        }
                        if (pricetype=='percent'){
                            price=(price/100)*product_price;
                        }
                        if (pricetype=='percentcurrenttotal'){
                            late_fields_prices.push({"setter":setter,"price":price,"bundleid":bundleid});
                            price=0;
                            setter.data('islate', 1);
                        }

                        formatted_price = tm_set_price(price);
                        setter.data('price', price);
                        setter.closest('.tmcp-field-wrap').find('.amount').html(formatted_price);

                    } else {
                        rules = $(element).closest('.tmcp-ul-wrap').data('rules');

                        if (typeof rules === "object") {
                            if (current_variation in rules) {
                                price = rules[current_variation];
                            } else {
                                price = rules[0];
                            }

                            if (typeof rulestype === "object") {
                                if (current_variation in rulestype) {
                                    pricetype = rulestype[current_variation];
                                }else{
                                    _rulestype = $(element).closest('.tmcp-ul-wrap').data('rulestype');
                                    if (typeof _rulestype === "object") {
                                        if (current_variation in _rulestype) {
                                            pricetype = _rulestype[current_variation];
                                        }else{
                                            pricetype = rulestype[0];
                                        }
                                    }else{
                                        pricetype = rulestype[0];
                                    }
                                }
                            }else{
                                rulestype = $(element).closest('.tmcp-ul-wrap').data('rulestype');
                                if (typeof rulestype === "object") {
                                    if (current_variation in rulestype) {
                                        pricetype = rulestype[current_variation];
                                    } else {
                                        pricetype = rulestype[0];
                                    }
                                }
                            }
                            if (pricetype=='percent'){
                                price=(price/100)*product_price;
                            }
                            if (pricetype=='percentcurrenttotal'){
                                late_fields_prices.push({"setter":setter,"price":price,"bundleid":bundleid});
                                price=0;
                                setter.data('islate', 1);
                            }

                            formatted_price = tm_set_price(price);
                            setter.data('price', price);
                            setter.closest('.tmcp-field-wrap').find('.amount').html(formatted_price);

                        }

                    }
                });

            });
            
        }

        /**
         * Set event handlers
         */
        function tm_epo_init($form,$formcart) {
            var container_id;
            if (!$form){
                $form = $('.cart:last').parent();
                main_cart = $('.cart:last');
            }else{
                // Composite bundle id
                container_id = $form.attr('data-container-id');                
            }
            
            // update price amount for select elements
            $form.find('.tm-extra-product-options select.tmcp-field')
            .off('tm-select-change')
            .on('tm-select-change', function() {
                if ($formcart && main_cart && main_cart.data('per_product_pricing')!=undefined && !main_cart.data('per_product_pricing')){
                    return;
                }
                var formatted_price = tm_set_price($(this).find('option:selected').data('price'));
                $(this).closest('.tmcp-field-wrap').find('.amount').html(formatted_price);
                var $cart = $formcart || $(this).closest('.cart');
                $cart.trigger('tm-epo-update');
            });

            // trigger global custom update event for every field
            $form.find('.cart .tm-extra-product-options .tmcp-field')
            .off('change.cpf')
            .on('change.cpf',  function() {
                var $cart = $formcart || $(this).closest('.cart');
                $cart.trigger('tm-epo-update');
                $(this).trigger('tm-select-change');

            });

            $form.find('.cart input.qty')
            .off('change.cpf')
            .on('change.cpf',  function() {              
                var $cart = $formcart || $(this).closest('.cart');
                $cart.trigger('tm-epo-update');
            });          

            // trigger global custom update event when variation changes
            $form.find('.cart')
            .off("change.cpf")
            .on('change.cpf', 'input[name=variation_id]', function(event) {
                var $cart = $formcart || $(this).closest('.cart');
                $cart.trigger('tm-epo-update');
                $cart.find("select").trigger('tm-select-change');
                
            });

            // global custom update event
            $form.find('.cart')
            .off("tm-epo-update")
            .on('tm-epo-update', function(pass) { 

                tm_epo_rules();
                
                var check_for_bto_internal_show,
                    $cart       = $(this),
                    $_formcart  = $formcart || $cart,
                    $totals     = $_formcart.find('.tm-epo-totals');
                if ($formcart){
                    $totals.addClass("cpf-bto-totals");
                }
                var product_price       = 0,
                    total               = 0,
                    product_type        = $totals.data('type'),
                    show_total          = false,
                    qty                 = parseFloat($cart.find('input.qty').val()),
                    cpf_bto_price       = $_formcart.find('.cpf-bto-price'),
                    per_product_pricing = true,
                    is_bto=false,bundleid=$_formcart.attr( 'data-product_id' );
                
                if (!bundleid){
                    bundleid=0;
                }

                if ($totals.length){
                    product_price = $totals.data('price');
                }else{
                    if (cpf_bto_price.length>0){
                        product_price = cpf_bto_price.val();
                    }
                }

                // Composite Products
                if ($formcart && $cart.find('.cpf-bto-price').length>0){
                    is_bto=true;
                    product_price=parseFloat($cart.find('.cpf-bto-price').val());
                    per_product_pricing=$cart.find('.cpf-bto-price').data('per_product_pricing');

                }else if (!$formcart && $('.cpf-bto-price').length>0){
                    
                    check_for_bto_internal_show=1;                   
                    
                    $('.cpf-bto-price').each(function(){                        
                        if (!isNaN( parseFloat($(this).val()))){
                            var _qty=$(this).closest('.cart').find('input.qty');
                            if (_qty.length>0){
                                _qty=parseFloat(_qty.val());
                            }else{
                                _qty=1;
                            }
                            product_price=parseFloat(product_price)+parseFloat($(this).val()*_qty);
                        }
                    });
                    
                    $('.cpf-bto-optionsprice').each(function(){
                        if (!isNaN( parseFloat($(this).val()))){
                            product_price=parseFloat(product_price)+parseFloat($(this).val());
                        }
                    });
                    
                }                
                
                if (product_type == 'variable') {
                    $cart.find('.single_variation').after($totals);
                }
                if (product_type == 'bto') {
                    $cart.find('.bundle_price').after($totals);
                }

                $cart.find('.tmcp-field').each(function() {

                    var option_price = 0;

                    if ($(this).is('.tmcp-checkbox, .tmcp-radio')) {
                        if ($(this).is(':checked')) {
                            option_price = $(this).data('price');
                            show_total = true;
                            $(this).data('isset',1);
                        }else{
                            $(this).data('isset',0);
                        }
                    } else if ($(this).is('.tmcp-select')) {
                        option_price = $(this).find('option:selected').data('price');
                        show_total = true;
                        $(this).find('option').data('isset',0);
                        $(this).find('option:selected').data('isset',1);
                    } else {
                        if ($(this).val()) {
                            option_price = $(this).data('price');
                            show_total = true;
                            $(this).data('isset',1);
                        }else{
                            $(this).data('isset',0);
                        }
                    }

                    if (!option_price) {
                        option_price = 0;
                    }

                    total = parseFloat(total) + parseFloat(option_price);

                });

                if ($totals.attr('data-type')=="bto"){

                    var bto_show=main_cart.find('.tm-epo-totals').data('btois');

                    if (bto_show==='show'){
                        show_total=true;
                    }

                }
                
                if (check_for_bto_internal_show){
                    show_total=true;
                }
                
                if ($formcart && !per_product_pricing){
                    show_total=false;
                }

                if (show_total && qty > 0) {
                    var _total=total;

                    total = parseFloat(total * qty);

                    var formatted_options_total = tm_set_price(total),
                        formatted_final_total;
                    
                    if (product_price || total>0) {
                        var product_total_price = parseFloat(product_price * qty),
                            extra_fee=0;
                        if (tm_epo_js.extra_fee){
                            extra_fee=parseFloat(tm_epo_js.extra_fee);
                            if (isNaN(extra_fee)){
                                extra_fee=0;
                            }
                        }
                        
                        var late_total_price= add_late_fields_prices(parseFloat(product_price) + parseFloat(_total),bundleid);
                        
                         
                                                
                        _total = _total + late_total_price;

                        total = parseFloat(_total * qty);
                        
                        formatted_options_total = tm_set_price(total);

                        product_total_price = parseFloat(product_total_price + total + extra_fee);
                        formatted_final_total = tm_set_price(product_total_price);
                    }
                    var html = '<dl class="tm-extra-product-options-totals tm-custom-price-totals">';
                    if (tm_epo_js.tm_epo_final_total_box!='final' && tm_epo_js.tm_epo_final_total_box!='hide' && (!(total==0 && tm_epo_js.tm_epo_final_total_box=='hideoptionsifzero')) ){                        
                        html = html + '<dt class="tm-options-totals">' + tm_epo_js.i18n_options_total + '</dt><dd class="tm-options-totals"><span class="amount options">' + formatted_options_total + '</span></dd>';
                    }
                    if (extra_fee) {
                        var formatted_extra_fee=tm_set_price(extra_fee);
                        html = html + '<dt class="tm-extra-fee">' + tm_epo_js.i18n_extra_fee + '</dt><dd class="tm-extra-fee"><span class="amount options extra-fee">' + formatted_extra_fee + '</span></dd>';
                    }
                    if (formatted_final_total && tm_epo_js.tm_epo_final_total_box!='hide') {                        
                        html = html + '<dt class="tm-final-totals">' + tm_epo_js.i18n_final_total + '</dt><dd class="tm-final-totals"><span class="amount final">' + formatted_final_total + '</span></dd>';
                    }
                    html = html + '</dl>';
                    if (tm_epo_js.tm_epo_final_total_box=='hide'){
                        html='';
                        if (formatted_final_total){
                            $_formcart.find(".single_variation .price .amount, .bundle_price .price .amount").html(formatted_final_total);
                        }
                    }
                    $totals.html(html);

                    if ($formcart){
                        if (per_product_pricing){
                            $cart.find('.cpf-bto-optionsprice').val(parseFloat(total));
                        }
                        main_cart.trigger("tm-epo-update");
                    }else{
                        main_cart.find('.tm-epo-totals').data('is_active',true);
                    }
                } else {
                    $totals.empty();

                    if ($formcart){
                        if (per_product_pricing){
                            $cart.find('.cpf-bto-optionsprice').val(parseFloat(total*qty));    
                        }                        
                        main_cart.trigger("tm-epo-update");
                    }
                }
                if (container_id){
                    $( '.bto_form_' + container_id ).trigger('cpf_bto_review');
                }
            });

            // update prices when a variation is found
            $form.find('.variations_form').on('found_variation', function(event, variation) {
                var $variation_form = $(this),
                    $totals         = $variation_form.find('.tm-epo-totals'),
                    variations      = $totals.data('variations'),
                    product_price;

                if (variations && variation.variation_id && variations[variation.variation_id]){
                    product_price=variations[variation.variation_id];
                    $totals.data('price', product_price);
                }
                else if ($(variation.price_html).find('.amount:last').size()) {
                    product_price = $(variation.price_html).find('.amount:last').text();
                    product_price = product_price.replace(tm_epo_js.currency_format_thousand_sep, '');
                    product_price = product_price.replace(tm_epo_js.currency_format_decimal_sep, '.');
                    product_price = product_price.replace(/[^0-9\.]/g, '');
                    product_price = parseFloat(product_price);
                    $totals.data('price', product_price);
                }
                    
                $variation_form.find('.cpf-product-price').val(product_price);
                $variation_form.trigger('tm-epo-update');
            });
            $form.find('.variations select').on('blur',function() {
                var $variation_form = $(this).closest('.cart');
                $variation_form.trigger('tm-epo-update');
            });

        }

        function bto_support(){

            $('.bto_item')
            .on('found_variation.cpf', function(event, variation) {
                var $bto            = $(this),
                    $totals         = main_cart.find('.tm-epo-totals'),
                    item            = $(this),
                    container_id    = item.attr('data-container-id'),
                    price_data      = $( '.bto_form_' + container_id ).data( 'price_data' ),
                    product_price,
                    item_id         = item.attr('data-item-id');

                $(".bto_form").find( ' .review .price_' + item_id ).removeData('cpf_review_price');
                $(".bto_form").find( ' .review .price_' + item_id ).find('.amount').empty();

                if ( price_data[ 'per_product_pricing' ] == true ) {                   
                    product_price = parseFloat(variation.price);
                }
                $bto.find('.cpf-bto-price').data('per_product_pricing',price_data[ 'per_product_pricing' ] );
                $bto.find('.cpf-bto-price').val(product_price);
                main_cart.data('per_product_pricing',price_data[ 'per_product_pricing' ] );

                $bto.find('.cart').trigger('tm-epo-update');
                main_cart.find('.tm-epo-totals').data('btois','none');

            })
            .on( 'wc-composite-item-updated.cpf', function() {
                var $bto = $(this);
                /**
                 * Start Condition Logic
                 */
                cpf_section_logic($bto.find(".tm-extra-product-options"));
                cpf_element_logic($bto.find(".tm-extra-product-options"));

                var $totals         = main_cart.find('.tm-epo-totals'),
                    item            = $(this),
                    container_id    = item.attr('data-container-id'),
                    price_data      = $( '.bto_form_' + container_id ).data( 'price_data' ),
                    product_price,
                    item_id         = item.attr('data-item-id');

                $(".bto_form").find( ' .review .price_' + item_id ).removeData('cpf_review_price');
                $(".bto_form").find( ' .review .price_' + item_id ).find('.amount').empty();

                if ( price_data[ 'per_product_pricing' ] == true ) {                   
                    product_price = parseFloat($bto.find( '.bto_item_data' ).data( 'price' ));
                }
                $bto.find('.cpf-bto-price').data('per_product_pricing',price_data[ 'per_product_pricing' ] );
                $bto.find('.cpf-bto-price').val(product_price);
                main_cart.data('per_product_pricing',price_data[ 'per_product_pricing' ] );

                tm_epo_init($(this),$(this).find('.cart'));
                main_cart.trigger('tm-epo-update');                

            })           
            .on( 'change', '.bto_item_options select', function( event ) {
                var item    = $(this),
                    item_id = item.attr('data-item-id');

                $(".bto_form").find( ' .review .price_' + item_id ).removeData('cpf_review_price');
                $(".bto_form").find( ' .review .price_' + item_id ).find('.amount').empty();
                if ($(this).val()=== ''){                                                         
                    main_cart.find('.tm-epo-totals').data('passed',false);
                    main_cart.find('.tm-epo-totals').data('btois','none');
                }else{
                    main_cart.trigger('tm-epo-update');
                }
            } )
            .on( 'woocommerce_variation_select_change.cpf', function( event ) {
                var item    = $(this),
                    item_id = item.attr('data-item-id');

                $(".bto_form").find( ' .review .price_' + item_id ).removeData('cpf_review_price');
                $(".bto_form").find( ' .review .price_' + item_id ).find('.amount').empty();
                if ($(this).find( '.variations .attribute-options select' ).val()===''){                                                     
                    main_cart.find('.tm-epo-totals').data('passed',false);
                    main_cart.find('.tm-epo-totals').data('btois','none');
                }
            });

            $('.bundle_wrap').on('show_bundle.cpf',function(){
                var $bto=$(this).closest('.cart'),
                    id=$bto.attr('data-container-id');
                check_bto(id);                
            });

            $( '.bto_form'  )
            .off( 'woocommerce-product-addons-update.cpf cpf_bto_review')
            .on( 'woocommerce-product-addons-update.cpf cpf_bto_review', function() {
                var bto_form=$(this);
                $(this).parent().find( '.bto_item' ).each( function(){
                    var item        = $(this),
                        item_id     = item.attr('data-item-id'),
                        html        = bto_form.find( ' .review .price_' + item_id ),
                        value,
                        options     = item.find(".cpf-bto-optionsprice").val();

                    if (html.data('cpf_review_price')){
                        value = accounting.unformat(html.data('cpf_review_price'));
                    }else{
                        value = accounting.unformat(html.find('.amount').html());
                        html.data('cpf_review_price',value);
                    }

                    if (options){
                        var total = parseFloat(value)+parseFloat(options);
                        html.find('.amount').html(tm_set_price(total));
                    }
                });                        

            } );

            $('.bto_item').trigger('wc-composite-item-updated.cpf');

        }

        function check_bto(id){
            var show=true;
            $( '.bto_form_' + id ).parent().find( '.bto_item' ).each( function(){
                var item        = $(this),
                    item_id         = item.attr('data-item-id'),
                    form_data       = $( '.bto_form_' + id + ' .bundle_wrap .bundle_button .form_data_' + item_id ),
                    product_input   = form_data.find( 'input.product_input' ).val(),
                    quantity_input  = form_data.find( 'input.quantity_input' ).val(),
                    variation_input = form_data.find( 'input.variation_input' ).val(),
                    product_type    = item.find( '.bto_item_data' ).data( 'product_type' );
                
                if ( product_type == undefined || product_type == '' || product_input === '' ){
                    show = false;
                }
                else if ( product_type != 'none' && quantity_input == '' ){
                    show = false;
                }
                else if ( product_type == 'variable' && variation_input == undefined ) {
                    show = false;
                }
            });
            
            if (show){
                main_cart.find('.tm-epo-totals').data('btois','show');
            }else{
                main_cart.find('.tm-epo-totals').data('btois','none');
            }
            main_cart.trigger('tm-epo-update');
        }

        // Init field price rules
        tm_epo_rules();
        late_fields_prices=[];
        if ($('.variations_form').length > 0) {
            $('.variations_form').on('wc_variation_form.cpf', function() {
                tm_epo_init();
                $('.cart').trigger('tm-epo-update');
            });
        } else {
            tm_epo_init();
            bto_support();
            $('.cart').trigger('tm-epo-update');
        }

    });
})(jQuery);