<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WC_Zapier_Trigger_New_Customer extends WC_Zapier_Trigger {

	public function __construct() {

		// Prefix the trigger key with wc. to denote that this is a trigger that relates to a WooCommerce order
		$this->trigger_key         = 'wc.new_customer';

		$this->trigger_title       = __( 'New Customer', 'wc_zapier' );

		$this->trigger_description = sprintf( __( 'Triggers if a customer chooses to register for an account. This can happen during the checkout process, or via the My Account page.<br />Note: this trigger will only occur if your <a href="%s">WooCommerce general settings</a> have the <em>Allow registration on the checkout page</em> and/or <em>Allow registration on the "My Account" page</em> setting(s) enabled.', 'wc_zapier' ), admin_url( 'admin.php?page=woocommerce_settings' ) );

		$this->sort_order = 2;

		// WooCommerce action(s)
		$this->actions['woocommerce_created_customer'] = 1;

		parent::__construct();
	}


	public function assemble_data( $args, $action_name ) {

		$customer_id = null;
		if ( $this->is_sample() ) {
			// Use the currently logged in user's details for testing
			$current_user = wp_get_current_user();
			$customer_id = empty( $current_user ) ? 1 : $current_user->ID;
		} else {
			$customer_id = intval( $args[0] );
		}

		$customer_data = get_user_by( 'id', $customer_id );

		if ( ! $customer_data ) {
			// No user/customer information found
			return false;
		}

		$customer = array();

		// Gather customer's data so it can be sent to Zapier
		$customer['id']              = $customer_data->ID;
		$customer['first_name']      = $customer_data->first_name;
		$customer['last_name']       = $customer_data->last_name;
		$customer['email_address']   = $customer_data->user_email;
		$customer['username']        = $customer_data->user_login;
		$customer['paying_customer'] = (bool) $customer_data->paying_customer;

		WC_Zapier()->log( "Assembled customer data.", $customer['id'], 'Customer' );

		return $customer;

	}

}