<?php
/**
 * For more information about WP_List_Table http://codex.wordpress.org/Class_Reference/WP_List_Table
 */
class WC_Custom_Status_Table extends WP_List_Table {

    function __construct(){
        parent::__construct(array('singular' => 'wc_custom_status_table',
            'ajax' => false));
    }

    /**
     * Defines the table's columns
     * @return [array] [key => title for table headers]
     */
    function get_columns(){
        return array(
            'cb' => '<input type="checkbox" />',
            'col_status_name' => __('Status Name','woocommerce_status_actions'),
            'col_status_icon' => '<span style="margin: auto; float: none;" class="woocommerce_status_font_icon woocommerce_status_actions_e23a tips status-table-icons-headings" data-tip="' . esc_attr__( 'Status', 'woocommerce' ) . '"></span>',
            'col_sends_email' => '<span style="margin: auto; float: none;" class="woocommerce_status_font_icon woocommerce_status_actions_e0ec tips status-table-icons-headings" data-tip="' . esc_attr__( 'Email Notification', 'woocommerce' ) . '"></span>',
            'col_include_invoice' => '<span style="margin: auto; float: none;" class="woocommerce_status_font_icon woocommerce_status_actions_e07d tips status-table-icons-headings" data-tip="' . esc_attr__( 'Include Invoice', 'woocommerce' ) . '"></span>',
			'col_recipient_email' => '<span style="margin: auto; float: none;" class="woocommerce_status_font_icon woocommerce_status_actions_e0ed tips status-table-icons-headings" data-tip="' . esc_attr__( 'Email Recipient (s)', 'woocommerce' ) . '"></span>',
			'col_action_icon' => __('Action Icon', 'woocommerce_status_actions'),
            'number_of_orders' => '<span style="margin: auto; float: none;" class="woocommerce_status_font_icon woocommerce_status_actions_e0c3 tips status-table-icons-headings" data-tip="' . esc_attr__( 'Number of Orders', 'woocommerce' ) . '"></span>'
        );
    }

    /**
     * Prepares the data/rows to be displayed in the table
     * @return void
     */
    function prepare_items(){
        global $wpdb, $_wp_column_headers;
        $screen = get_current_screen();

        $table_name = $wpdb->prefix . 'woocommerce_order_status_action';
        /* -- Preparing your query -- */
        $query = "SELECT * FROM {$table_name}";

        /* -- Ordering parameters -- */
        //Parameters that are going to be used to order the result
        $orderby = !empty($_GET["orderby"]) ? mysql_real_escape_string($_GET["orderby"]) : 'ASC';
        $order = !empty($_GET["order"]) ? mysql_real_escape_string($_GET["order"]) : '';
        if(!empty($orderby) & !empty($order)){ $query.=' ORDER BY '.$orderby.' '.$order; }

        /* -- Pagination parameters -- */
        //Number of elements in your table?
        $totalitems = $wpdb->query($query); //return the total number of affected rows
        //How many to display per page?
        $perpage = 10;
        //Which page is this?
        $paged = !empty($_GET["paged"]) ? mysql_real_escape_string($_GET["paged"]) : '';
        //Page Number
        if(empty($paged) || !is_numeric($paged) || $paged<=0 ){ $paged=1; }
        //How many pages do we have in total?
        $totalpages = ceil($totalitems/$perpage);
        //adjust the query to take pagination into account
        if(!empty($paged) && !empty($perpage)){
            $offset=($paged-1)*$perpage;
            $query.=' LIMIT '.(int)$offset.','.(int)$perpage;
        }

        /* -- Register the pagination -- */
        $this->set_pagination_args( array(
            "total_items" => $totalitems,
            "total_pages" => $totalpages,
            "per_page" => $perpage,
        ) );
        //The pagination links are automatically built according to those parameters

        /* -- Register the Columns -- */
        $this->_column_headers = array(
            $this->get_columns(),		// columns
            array(),			// hidden
            $this->get_sortable_columns(),	// sortable
        );

        /* -- Fetch the items -- */
        $this->items = $wpdb->get_results($query);
    }

    /**
     * For each of the record output the corresponding table row (tr)
     * @return void
     */
    function display_rows() {
        global $woocommerce;

        //Get the records registered in the prepare_items method
        $records = $this->items;

        //Get the columns registered in the get_columns and get_sortable_columns methods
        list( $columns, $hidden ) = $this->get_column_info();



        //Loop for each record
        if(!empty($records)){foreach($records as $rec){

            //Open the line
            echo '<tr id="record_'.$rec->id.'">';
            foreach ( $columns as $column_name => $column_display_name ) {
                // For Action icons to appear exactly as in orders page
                $actions_class = '';
                if( $column_name == 'col_action_icon' ) {
                    $actions_class = ' column-order_actions';
                }

                //Style attributes for each col
                $class = "class='$column_name column-$column_name $actions_class'";
                $style = "";
                if ( in_array( $column_name, $hidden ) ) $style = ' style="display:none;"';
                $attributes = $class . $style;

                //edit link
                $editlink  = admin_url().'admin.php?page=woocommerce_status_and_actions&tab=edit_status&status_id='.(int)$rec->id;
                $deletelink = admin_url().'admin.php?page=woocommerce_status_and_actions&tab=delete_status&status_id='.(int)$rec->term_id;

                //Display the cell
                switch ( $column_name ) {
                    case "col_status_icon":
                        // Style!
                        $style = '';
                        $class = '';
                        if( empty( $rec->status_color_type ) || $rec->status_color_type == '0' ) {
                            $style = 'style="color:'. $rec->status_color .'; border: 1px solid '. $status->status_color .';"';
                            $class = 'new_status_icon';
                        } else if( $rec->status_color_type == '1' ){
                            $style = 'style="background-color: '.$rec->status_color.';"';
                            $class = 'old_status_icon';
                        }
                        echo '<td '.$attributes.' style="text-align:center;">';
                        if( empty( $rec->status_color_type ) || $rec->status_color_type == '0' || $rec->status_color_type == '1' ) {
                            echo '<span '.$style.'  class="woocommerce_status_font_icon woocommerce_status_actions_'.$rec->status_icon.' tips '.$class.'" data-tip="'.$rec->status_name.'" alt="'.$rec->status_name.'"></span></td>';
                        } else if( $rec->status_color_type == '2' ){
                            echo '<strong class="status_orders_page status_text" style="background-color:'.$rec->status_color.';">'.$rec->status_name.'</strong>';
                        } else {
	                        echo '<strong class="status_orders_page status_line_text" style="color:'.$rec->status_color.';">'.$rec->status_name.'</strong>';
                        }
                        break;
                    case "col_status_name":
                        echo '<td '.$attributes.'>
                        	<strong>
                        	<a class="row-title" style="text-transform: capitalize;" href="'.$editlink.'" title="Edit “'.stripslashes($rec->status_name).'”">'.stripslashes($rec->status_name).'</a></strong>'; // <a href="'.$editlink.'">Edit</a>
                        $actions = array(
                            'edit'      => sprintf('<a href="%s">Edit</a>',$editlink),
                            'delete' => sprintf('<a href="%s">Delete Permanently</a>',$deletelink)
                        );

                        //Return the title contents
                        echo $this->row_actions($actions);

                        echo '</td>';
                        break;
                    case "col_sends_email":
                        if($rec->sends_email == '1'){
                            echo '<td '.$attributes.'><span style="color: #73a724;" class="woocommerce_status_font_icon woocommerce_status_actions_e370 tips status-table-icons" data-tip="' . esc_attr__( 'Email Sent', 'woocommerce' ) . '"></span></td>';
                        } else {
                            echo '<td '.$attributes.'><span style="color: #a00;" class="woocommerce_status_font_icon woocommerce_status_actions_e36b tips status-table-icons" data-tip="' . esc_attr__( 'No Email Sent', 'woocommerce' ) . '"></span></td>';
                        }
                        break;
					case "col_include_invoice":
                        if($rec->display_essential_info == '1'){
                            echo '<td '.$attributes.'><span style="color: #73a724;" class="woocommerce_status_font_icon woocommerce_status_actions_e370 tips status-table-icons" data-tip="' . esc_attr__( 'Includes Order Information', 'woocommerce' ) . '"></span></td>';
                        } else {
                            echo '<td '.$attributes.'><span style="color: #a00;" class="woocommerce_status_font_icon woocommerce_status_actions_e36b tips status-table-icons" data-tip="' . esc_attr__( 'No Order Information', 'woocommerce' ) . '"></span></td>';
                        }
                        break;
					case "col_recipient_email":
                        if($rec->email_to == 'customer'){
                            echo '<td '.$attributes.'><span class="woocommerce_status_font_icon woocommerce_status_actions_e185 tips status-table-icons" data-tip="' . esc_attr__( 'Customer', 'woocommerce' ) . '"></span></td>';
                        } else if($rec->email_to == 'admin'){
							echo '<td '.$attributes.'><span class="woocommerce_status_font_icon woocommerce_status_actions_e199 tips status-table-icons" data-tip="' . esc_attr__( 'Admin', 'woocommerce' ) . '"></span></td>';
						} else if($rec->email_to == 'both'){
							echo '<td '.$attributes.'><span class="woocommerce_status_font_icon woocommerce_status_actions_e186 tips status-table-icons" data-tip="' . esc_attr__( 'Customer & Admin', 'woocommerce' ) . '"></span></td>';
						} else if($rec->email_to == 'custom'){
                            echo '<td '.$attributes.'><span class="woocommerce_status_font_icon woocommerce_status_actions_e012 tips status-table-icons" data-tip="' . esc_attr__( 'Custom Email Address', 'woocommerce' ) . '"></span></td>';
                        } else {
	                        echo '<td '.$attributes.'></td>';
                        }
                        break;
                    case 'col_action_icon':
                        $rec->status_name = ucfirst($rec->status_name);
                        echo "<td $attributes>";

                            // Version 2.1
                            $action_icon = empty($rec->action_icon)?'e17':$rec->action_icon;
                            ?>
                            <a class="button default-action-icon-selector woocommerce_status_action_font_icon woocommerce_status_actions_<?php echo $action_icon; ?>" href="javascript:;">Icon Preview</a>
                            <?php
                        echo "</td>";
                    break;
                    case 'number_of_orders':
                        $term = get_term_by( 'id', $rec->term_id, 'shop_order_status' );
                        echo '<td style="text-align: center;" '.$attributes.'>' . $term->count . '</td>';
                    break;
                    case 'cb':
                        echo sprintf( '<td><input type="checkbox" name="%1$s[]" value="%2$s" /></td>',
                        /*$1%s*/ 'status_id',  //Let's simply repurpose the table's singular label ("movie")
                        /*$2%s*/ $rec->term_id                //The value of the checkbox should be the record's id
                        );
                    break;
                }
            }

            //Close the line
            echo'</tr>';
        }}
    }

    /**
     * Auto generate the bulk actions list
     * @return [array] [key => label for the bulk action selectbox]
     */
    function get_bulk_actions() {
        $actions = array(
            'delete'    => 'Delete Permanently'
        );
        return $actions;
    }
}
?>
