<?php
/**
 * Solilouqy Support
 *
 * @package PrintingShop
 * @subpackage Includes
 * @since 1.0.0
 */

/**
 * filter soliloquy home page slider so that it is the correct image size
 *
 * @since  1.0.0
 * @param  $image
 * @param  $id
 * @param  $attachment
 * @param  $size
 * @return return new wp_get_attachment_image_src with 'ps-home-slider' size
 */
function printing_shop_slider_size( $image, $id, $attachment, $size ) {

	return wp_get_attachment_image_src( $attachment->ID, 'ps-home-slider' );
}

/**
 * use filter to modify slider width
 * @since  1.0.0
 * @return int width in pixels
 */
function printing_shop_slider_width() {
    return 780;
}

/**
 *  use filter to modify slider height
 * @since  1.0.0
 * @return int height in pixels
 */
function printing_shop_slider_height() {
    return 405;
}

/**
 * create link for soliquy and wrap around text or html
 * @since  1.0.0
 * @param  int 	     $id     id of slide
 * @param  array     $image  array of slide image
 * @param  string    $output html to be wrapped
 * @return string
 */
function printing_shop_slider_wrap_link( $id, $image, $output ) {
	$title 			= empty( $image['title'] ) ? apply_filters( 'tgmsp_no_title', '', $id, $image ) : $image['title'];
	$link_title 	= empty( $image['linktitle'] ) ? apply_filters( 'tgmsp_no_link_title', '', $id, $image ) : $image['linktitle'];
	$link_target 	= empty( $image['linktab'] ) ? apply_filters( 'tgmsp_no_link_target', '', $id, $image ) : 'target="_blank"';
	if ( ! empty( $image['link'] ) )
		$output = apply_filters( 'tgmsp_link_output', '<a href="' . esc_url( $image['link'] ) . '" title="' . esc_attr( $link_title ) . '" ' . $link_target . '>', $id, $image, $link_title, $link_target ) . $output . '</a>';
	return $output;	
}

/**
 * modify slider to add additional elements and match html for our design
 * @since  1.0.0
 * @param  string    $slide  html of slide
 * @param  int 	     $id     id of slide
 * @param  array     $image  array of slide image
 * @return string
 */
function printing_shop_add_meta( $slide, $id, $image, $i ) {

	if ( empty( $image['mime'] ) || 'image' == $image['mime'] ) { // only for image sliders

		$alt 			= empty( $image['alt'] ) ? apply_filters( 'tgmsp_no_alt', '', $id, $image ) : $image['alt'];
		$title 			= empty( $image['title'] ) ? apply_filters( 'tgmsp_no_title', '', $id, $image ) : $image['title'];
		
		$slide = '<li id="soliloquy-' . esc_attr( $id ) . '-item-' . $i . '" class="soliloquy-item" style="' . apply_filters( 'tgmsp_slider_item_style', 'display: none;', $id, $image, $i ) . '" ' . apply_filters( 'tgmsp_slider_item_attr', '', $id, $image, $i ) . '><div class="ps-slide-content">';
			$img = apply_filters( 'tgmsp_image_output', '<img class="soliloquy-item-image" src="' . esc_url( $image['src'] ) . '" alt="' . esc_attr( $alt ) . '" title="' . esc_attr( $title ) . '" />', $id, $image, $alt, $title );
			$slide .= printing_shop_slider_wrap_link( $id, $image, $img );
			$slide .= '<div class="ps-slider-meta">';
				if ( ! empty( $title ) ) {	
					$slide .= '<h3>' . printing_shop_slider_wrap_link( $id, $image, esc_attr( $title) ) . '</h3>';
				}
				if ( ! empty( $image['caption'] ) ) {
					$slide .= apply_filters( 'tgmsp_caption_output', '<div>' . printing_shop_slider_wrap_link( $id, $image, $image['caption'] ) . '</div>', $id, $image );
				}
			$slide .= '</div>';
		$slide .= '</li>';

	}

	return $slide;
}