<?php
/**
 * Adds plugin installation via TGM-Plugin-Activation class https://github.com/thomasgriffin/TGM-Plugin-Activation
 *
 * @package	   PrintingShop
 * @subpackage Includes
 * @version	   1.0.0
 */

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'printing_shop_register_plugins' );
/**
 * Register the required plugins for this theme.
 */
function printing_shop_register_plugins() {

	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(

		
		// woocommerce
		array(
			'name' 		=> __( 'WooCommerce', 'printing-shop' ),
			'slug' 		=> 'woocommerce',
			'required' 	=> false,
		),
		// soliloquy
		array(
			'name' 		=> __( 'Soliloquy Lite', 'printing-shop' ),
			'slug' 		=> 'soliloquy-lite',
			'required' 	=> false,
		),
		// grid columbns
		array(
			'name' 		=> __( 'Grid Columns', 'printing-shop' ),
			'slug' 		=> 'grid-columns',
			'required' 	=> false,
		),
		// whistles
		array(
			'name' 		=> __( 'Whistles - Tabs, Toggles, and Accordians', 'printing-shop' ),
			'slug' 		=> 'whistles',
			'required' 	=> false,
		),
		// yoast
		array(
			'name' 		=> __( 'WordPress SEO', 'printing-shop' ),
			'slug' 		=> 'wordpress-seo',
			'required' 	=> false,
		),
		// google maps
		array(
			'name' 		=> __( 'Simple Google Maps Short Code', 'printing-shop' ),
			'slug' 		=> 'simple-google-maps-short-code',
			'required' 	=> false,
		),
		// ninja forms
		array(
			'name' 		=> __( 'Ninja Forms', 'printing-shop' ),
			'slug' 		=> 'ninja-forms',
			'required' 	=> false,
		),
		// widgets
		array(
			'name' 		=> __( 'Widget Importer & Exporter', 'printing-shop' ),
			'slug' 		=> 'widget-importer-exporter',
			'required' 	=> false,
		),
		// user status
		array(
			'name' 		=> __( 'User Status Shortcode', 'printing-shop' ),
			'slug' 		=> 'user-status-shortcode',
			'required' 	=> false,
		)		

	);

	/**
	 * Array of configuration settings. Amend each line as needed
	 */
	$config = array(
		'domain'       		=> 'printing-shop',         	// Text domain - likely want to be the same as your theme.
		'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
		'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
		'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
		'menu'         		=> 'djr-theme-plugins', 		// Menu slug
		'has_notices'      	=> true,                       	// Show admin notices or not
		'is_automatic'    	=> true,					   	// Automatically activate plugins after installation or not
		'message' 			=> '',							// Message to output right before the plugins table
		'strings'      		=> array(
			'page_title'                       			=> __( 'Install Optional Plugins', 'printing-shop' ),
			'menu_title'                       			=> __( 'Supported Plugins', 'printing-shop' ),
			'installing'                       			=> __( 'Installing Plugin: %s', 'printing-shop' ), // %1$s = plugin name
			'oops'                             			=> __( 'Something went wrong with the plugin API.', 'printing-shop' ),
			'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
			'notice_can_install_recommended'			=> _n_noop( 'The following plugins can optionally be installed for additional features: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
			'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
			'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
			'notice_can_activate_recommended'			=> _n_noop( 'The following optional plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
			'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
			'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
			'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
			'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
			'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
			'return'                           			=> __( 'Return to Supported Plugins', 'printing-shop' ),
			'plugin_activated'                 			=> __( 'Plugin activated successfully.', 'printing-shop' ),
			'complete' 									=> __( 'All plugins installed and activated successfully. %s', 'printing-shop' ), // %1$s = dashboard link
			'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa( $plugins, $config );
}